var Service = require('Service');
var utils = require('utils');
var util = require('util');
var FriendGroup = require('../../dao/user_friend_group');

/**
 * 添加分组
 **/

var createGroup = function() {
    Service.call(this);
};

util.inherits(createGroup, Service);

module.exports = createGroup;

createGroup.prototype.process = function(req, res) {
    if (!req.data.name) {
        this.onLogicError(1, '请提供分组名称！');
        return;
    }
    if (req.data.name.length > 10) {
        this.onLogicError(2, '分组名称最大长度为10！');
        return;

    }
    var self = this;
    var friendGroup = new FriendGroup(this);

    self.pipe(require('./getGroup'), req, res, function(data) {
        if (data) {
            self.onLogicError(2, '该分组名称已存在！');
        } else {
            var obj = {}
            obj.org_id = req.session.orgId;
            obj.user_id = req.session.userId;
            obj.name = req.data.name;
            obj.createtime = new Date();
            obj.status = 0;
            friendGroup.create(obj, function(ret) {
                obj.id = ret.insertId;
                res.data = obj;
                return self.end(res);
            });
        }
    });

}