var Service = require('Service');
var utils = require('utils');
var util = require('util');
var FriendDao = require('../../dao/user_friend');

/**
 * 添加分组
 **/

var createGroup = function() {
    Service.call(this);
};

util.inherits(createGroup, Service);

module.exports = createGroup;

createGroup.prototype.process = function(req, res) {
    if (!req.friend_id) {
        this.onLogicError(1, '请提供好友编号！');
        return;
    }
    var self = this;
    var dao = new FriendDao(this);

    dao.query({
        fields: 'id',
        where: 'org_id=? and user_id=? and friend_id=? and status=0',
        params: [req.session.orgId, req.session.userId, req.friend_id]
    }, function(rows) {
        if (rows.length > 0) {
            self.onLogicError(2, '该联系人已经添加过了！');
        } else {
            var obj = {}
            obj.org_id = req.session.orgId;
            obj.user_id = req.session.userId;
            obj.group_id = req.group_id;
            obj.friend_id = req.friend_id;
            obj.createtime = new Date();
            obj.status = 0;
            dao.create(obj, function(ret) {
                obj.id = ret.insertId;
                res.data = obj;
                return self.end(res);
            });
        }
    });
}