var util = require('util');
var Dao = require('Dao');

/**
 * 用户视图数据模型类
 */
var VUser = function (service) {
  Dao.call(this, service, 'system', 'vuser');
};

util.inherits(VUser, Dao);

module.exports = VUser;

/**
 * 查询所有有效的用户
 * @param  {Function} cb 回调函数
 */
VUser.prototype.findAllValid = function (cb) {
  this.query({
    where: 'status=0',
    fields: 'id,code,name,loginname,org_id,sex,head_id,post,'
      + 'motto,mobile,nickname,email,tel_short,tel_work,password',
    order: 'code ASC,id ASC'
  }, cb);
};

/**
 * 查询指定组织所有有效的用户
 * @param  {Function} cb 回调函数
 */
VUser.prototype.findByOrgId = function (orgId, cb) {
  this.query({
    where: 'status=0 and org_id=' + orgId,
    fields: 'id,code,name,loginname,org_id,sex,head_id,post,'
      + 'motto,mobile,nickname,email,tel_short,tel_work,password',
    order: 'code ASC,id ASC'
  }, cb);
};

/**
 * 查询指定登录名的用户
 * @param  {Number}   orgId     组织编号
 * @param  {String}   loginname 登录名
 * @param  {Function} cb        回调函数
 */
VUser.prototype.findByLoginname = function (orgId, loginname, cb) {
  this.query({
    where: 'loginname=\'' + loginname + '\' and org_id=' + orgId + ' and status=0',
    fields: 'id,code,name,loginname,password,sex,head_id,mobile,lastLoginTime,'
      + 'email,motto,create_group,look_all,look_self_bureau,look_self_dep,'
      + 'look_leader,look_under,device_id,not_bind_device,only_app_center,'
      + 'disable_address_book,disable_work_circle,disable_app_center,disable_taskmsg'
  }, cb);
};

/**
 * 查询指定登录名的用户
 * @param  {String}   mobile    手机号
 * @param  {Function} cb        回调函数
 */
VUser.prototype.findByMobile = function (mobile, cb) {
  this.query({
    where: 'mobile=\'' + mobile + '\' and status=0',
    fields: 'id,org_id,code,name,loginname,password,sex,head_id,mobile,'
      + 'lastLoginTime,email,motto,create_group,look_all,look_self_bureau,'
      + 'look_self_dep,look_leader,look_under,device_id,not_bind_device,only_app_center,'
      + 'disable_address_book,disable_work_circle,disable_app_center,disable_taskmsg'
  }, cb);
};

/**
 * 查询当前登录用户相关信息
 * @param {*} req 
 * @param {*} cb 
 */
VUser.prototype.findUser = function (req, cb) {
  var self = this;
  req.session.cache.exec({
    userId: req.session.userId
  }, function (cacheData, args) {
    var obj = {};
    var curUser = cacheData['user'].values[args.userId];

    obj.userId = curUser.id;
    obj.userName = curUser.name;
    var positionUsers = cacheData['position_user'].values;
    for (var key in positionUsers) {
      var positionUser = positionUsers[key];
      if (positionUser.order_number == 1 && positionUser.user_id == obj.userId) {
        obj.depId = positionUser.dep_id;
        var dep = cacheData['dep'].values[obj.depId];
        obj.depName = dep.name;
        if (positionUser.post_id > 0) {
          obj.postId = positionUser.post_id;
          var post = cacheData['post'].values[obj.postId];
          obj.postName = post.name;
        } else {
          obj.postId = '';
          obj.postName = '';
        }
        break;
      }
    }


    obj.roleIds = [];
    obj.roleNames = [];

    for (var i = 0; i < curUser.roles.length; i++) {
      obj.roleIds.push(curUser.roles[i]);
      var role = cacheData['role'].values[curUser.roles[i]];
      obj.roleNames.push(role.name);
    }

    return obj;
  }, function (err, ret) {
    cb(err, ret);
  });
};