var util = require('util');
var Dao = require('Dao');

var User = function (service) {
  Dao.call(this, service, 'system', 'user');
};

util.inherits(User, Dao);

module.exports = User;

/**
 * 查询用户
 * @param {Object} args 查询参数（org_id、dep_id、keyword）
 * @param {Function} cb 回调函数
 */
User.prototype.getPage = function (req, cb) {
  var where = " 1=1 ";
  if (req.session && req.session.orgId) where += " and org_id=" + req.session.orgId;
  if (req.org_id != null) where += " and org_id=" + req.org_id;
  if (req.status != null) where += " and status in (" + req.status + ")";
  //if (req.dep_id != null) where += " and dep_id=" + req.dep_id;
  //if (req.post_id != null) where += " and post_id=" + req.post_id;
  if (req.keyword != null) where += " and (code like '%" + req.keyword + "%' or name like '%" + req.keyword + "%' or loginname like '%" + req.keyword + "%')";

  var order = 'code ASC,id ASC';
  if (req.order) order = req.order;

  this.queryDataPage(req, {
    where: where,
    //fields: 'id,org_id,code,name,loginname,sex,mobile,dep,post,level,status',
    fields: 'id,org_id,code,name,loginname,sex,mobile,status',
    order: order
  }, cb);
};