var util = require('util');
var Dao = require('Dao');

var Role_user = function (service) {
  Dao.call(this, service, 'system', 'role_user');
};

util.inherits(Role_user, Dao);

module.exports = Role_user;

/**
 * 查询所有角色用户
 * @param  {Function} cb 回调函数
 */
Role_user.prototype.findAll = function (cb) {
  this.query({
    fields: 'role_id,user_id',
    where: 'user_id in (select id from tm_user where status=0 and org_id='
      + '(select org_id from sys_role where id=sys_role_user.role_id and sys_flag<>1))',
    order: '(select code from tm_user where id=sys_role_user.user_id) asc'
  }, cb);
};

/**
 * 查询指定组织所有角色用户
 * @param  {Function} cb 回调函数
 */
Role_user.prototype.findByOrgId = function (orgId, cb) {
  this.query({
    fields: 'role_id,user_id',
    where: 'org_id=' + orgId + ' and user_id in (select id from tm_user where status=0 and org_id='
      + '(select org_id from sys_role where id=sys_role_user.role_id and sys_flag<>1))',
    order: '(select code from tm_user where id=sys_role_user.user_id) asc'
  }, cb);
};