var util = require('util');
var Dao = require('Dao');

var Post = function (service) {
  Dao.call(this, service, 'system', 'post');
};

util.inherits(Post, Dao);

module.exports = Post;

/**
 * 查询岗位
 * @param {Object} args 查询参数（org_id、parent_id、status、keyword）
 * @param {Function} cb 回调函数
 */
Post.prototype.getList = function (req, cb) {
  var where = " 1=1 ";
  if (req.session && req.session.orgId) where += " and org_id=" + req.session.orgId;
  if (req.org_id != null) where += " and org_id=" + req.org_id;
  if (req.status != null) where += " and status in (" + req.status + ")";
  if (req.parent_id != null) where += " and parent_id in (" + req.parent_id + ")";
  if (req.keyword != null) where += " and (code like '%" + req.keyword + "%' or name like '%" + req.keyword + "%')";
  var where0 = '';
  if (req.status != null) where0 = " and c_post.status in (" + req.status + ")";
  this.query({
    where: where,
    fields: "id, org_id, code, name, parent_id, status, " +
      "(select count(*) from sys_post c_post where c_post.org_id=sys_post.org_id and c_post.parent_id=sys_post.id " + where0 + ") as child_count",
    order: 'code ASC, id ASC'
  }, cb);
};