var util = require('util');
var Dao = require('Dao');

var Org_app_key = function (service) {
  Dao.call(this, service, 'system', 'org_app_key');
};

util.inherits(Org_app_key, Dao);

module.exports = Org_app_key;

/**
* 是否开启
* @param  {Object}    args         查询参数（org_id、key_code）
* @param  {Function}  cb           回调函数
*/
Org_app_key.prototype.isOpen = function (args, cb) {
  var org_id = null;
  if (args.session && args.session.orgId) org_id = args.session.orgId;
  //if (args.org_id != null) org_id = args.org_id;
  var key_code = "";
  if (args.key_code != null) key_code = args.key_code;
  this.execute("select count(*) as count from sys_org_app_key where org_id=? and key_code=? and key_status=1", [org_id, key_code], function (ret) {
    if (ret == null) cb(false);
    if (ret.length <= 0) cb(false);
    if (ret[0].count <= 0) cb(false);
    else cb(true);
  });
};