var util = require('util');
var Dao = require('Dao');

var Org_app_datapower = function (service) {
  Dao.call(this, service, 'system', 'org_app_datapower');
};

util.inherits(Org_app_datapower, Dao);

module.exports = Org_app_datapower;

/**
* 是否开启
* @param  {Object}    args         查询参数（org_id、key_code、user_id）
* @param  {Function}  cb           回调函数（bool）
*/
Org_app_datapower.prototype.isAll = function (args, cb) {
  var org_id = null;
  if (args.session && args.session.orgId) org_id = args.session.orgId;
  //if (args.org_id != null) org_id = args.org_id;
  var user_id = null;
  if (args.session && args.session.userId) user_id = args.session.userId;
  //if (args.user_id != null) user_id = args.user_id;
  var key_code = "";
  if (args.key_code != null) key_code = args.key_code;
  this.execute(
    "select count(*) as c from org_app_datapower " +
    "where org_id=? and user_id=? and key_code=? and range_type='all'",
    [org_id, user_id, key_code], function (ret) {
      if (ret == null) cb(false);
      if (ret.length <= 0) cb(false);
      if (ret[0].c <= 0) cb(false);
      else cb(true);
    });
};

/**
* 
* @param  {Object}    args         查询参数（org_id、key_code、user_id）
* @param  {Function}  cb           回调函数
*/
Org_app_datapower.prototype.getList = function (args, cb) {
  var self = this;
  var org_id = null;
  if (args.session && args.session.orgId) org_id = args.session.orgId;
  //if (args.org_id != null) org_id = args.org_id;
  var user_id = null;
  if (args.session && args.session.userId) user_id = args.session.userId;
  //if (args.user_id != null) user_id = args.user_id;
  var key_code = "";
  if (args.key_code != null) key_code = args.key_code;

  this.execute(
    "select count(*) as c from sys_org_app_datapower " +
    "where org_id=? and user_id=? and key_code=? and range_type='all'",
    [org_id, user_id, key_code], function (ret) {
      if (ret != null && ret.length > 0 && ret[0].c > 0) {
        self.execute(
          "select id,name,parent_id from vsys_com where org_id=?", [org_id], function (rows) {
            var obj = {};
            obj.id = "0";
            obj.name = args.session.orgName;
            obj.parent_id = "-1";
            rows.unshift(obj);
            cb(rows);
          });
      } else {
        self.execute(
          "select relation_id as id," +
          "(select name from vsys_com where org_id=? and id=sys_org_app_datapower.relation_id) as name,-1 as parent_id from sys_org_app_datapower " +
          "where org_id=? and key_code=? and user_id=? and range_type=?", [org_id, org_id, key_code, user_id, 'com'], function (rows) {
            cb(rows);
          });
      }
    });
};