var util = require('util');
var Dao = require('Dao');

var Org = function (service) {
  Dao.call(this, service, 'system', 'org');
};

util.inherits(Org, Dao);

module.exports = Org;

/**
 * 查询单位
 * @param {Object} args 查询参数（org_id）
 * @param {Function} cb 回调函数
 */
Org.prototype.get = function (req, cb) {
  var where = " 1=1 ";
  if (req.session && req.session.orgId) where += " and id=" + req.session.orgId;
  this.query({
    where: where,
    fields: "id,code,name",
    order: 'code ASC, id ASC'
  }, function (rows) {
    if (rows.length == 0) {
      cb();
    } else {
      cb(rows[0]);
    }
  });
};

/**
 * 修改最后更新时间
 * @param  {Function} cb   回调函数
 */
Org.prototype.setLastUpdate = function (id, cb) {
  var lastUpdate = new Date();
  this.update({ last_update: lastUpdate }, { where: 'id=' + id }, function () {
    cb(lastUpdate);
  });
};