var util = require('util');
var Dao = require('Dao');

var Level = function (service) {
  Dao.call(this, service, 'system', 'level');
};

util.inherits(Level, Dao);

module.exports = Level;

/**
 * 查询级别
 * @param {Object} args 查询参数（org_id、status、keyword）
 * @param {Function} cb 回调函数
 */
Level.prototype.getList = function (req, cb) {
  var where = " 1=1 ";
  if (req.session && req.session.orgId) where += " and org_id=" + req.session.orgId;
  if (req.org_id != null) where += " and org_id=" + req.org_id;
  if (req.status != null) where += " and status in (" + req.status + ")";
  if (req.keyword != null) where += " and (code like '%" + req.keyword + "%' or name like '%" + req.keyword + "%')";

  this.query({
    where: where,
    fields: "id, org_id, code, name, status",
    order: 'code ASC, id ASC'
  }, cb);
};