var util = require('util');
var Dao = require('Dao');

var Dep_user = function (service) {
  Dao.call(this, service, 'system', 'dep_user');
};

util.inherits(Dep_user, Dao);

module.exports = Dep_user;

/**
 * 查询用户部门岗位
 * @param {Object} args 查询参数（org_id、user_id、dep_id）
 * @param {Function} cb 回调函数
 */
Dep_user.prototype.getList = function (req, cb) {
  var where = " 1=1 ";
  if (req.session && req.session.orgId) where += " and org_id=" + req.session.orgId;
  if (req.org_id != null) where += " and org_id=" + req.org_id;
  if (req.user_id != null) where += " and user_id in (" + req.user_id + ")";
  if (req.dep_id != null) where += " and dep_id in (" + req.dep_id + ")";

  this.query({
    where: where,
    fields: "id, org_id, order_number, user_id, dep_id, post_id, level_id",
    order: 'id ASC'
  }, cb);
};