var util = require('util');
var Dao = require('Dao');

var Dep = function (service) {
  Dao.call(this, service, 'system', 'dep');
};

util.inherits(Dep, Dao);

module.exports = Dep;

/**
 * 查询部门
 * @param {Object} args 查询参数（org_id、parent_id、status、keyword）
 * @param {Function} cb 回调函数
 */
Dep.prototype.getList = function (args, cb) {
  var where = " 1=1 ";
  if (args.session && args.session.orgId) where += " and org_id=" + args.session.orgId;
  if (args.org_id != null) where += " and org_id=" + args.org_id;
  if (args.status != null) where += " and status in (" + args.status + ")";
  if (args.parent_id != null) where += " and parent_id in (" + args.parent_id + ")";
  if (args.keyword != null) where += " and (code like '%" + args.keyword + "%' or name like '%" + args.keyword + "%')";
  if (args.company_id != null && args.company_id != "0") where += " and parent_ids like '%," + args.company_id + ",%'";
  var where0 = '';
  if (args.status != null) where0 = " and c_dep.status in (" + args.status + ")";
  this.query({
    where: where,
    fields: "id, org_id, code, name, fullname, parent_id, status, company_sign, external_sign, shortname, createtime, last_modify_time, " +
      "(select count(*) from sys_dep c_dep where c_dep.org_id = sys_dep.org_id and c_dep.parent_id = sys_dep.id " + where0 + ") as child_count, " +
      "(select name from sys_dep d_dep where d_dep.org_id=sys_dep.org_id and d_dep.id = sys_dep.parent_id) as parent_name",
    order: 'code ASC, id ASC'
  }, cb);
};

Dep.prototype.getCompany = function (args, cb) {
  var where = " 1=1 ";
  if (args.session && args.session.orgId) where += " and org_id=" + args.session.orgId;
  if (args.org_id != null) where += " and org_id=" + args.org_id;
  if (args.status != null) where += " and status in (" + args.status + ")";
  if (args.company_id != null && args.company_id != "0") where += ' and id=' + args.company_id;
  this.query({
    where: where,
    fields: "id, org_id, code, name, fullname, parent_id, status, company_sign, external_sign, shortname, createtime, last_modify_time",
    order: 'code ASC, id ASC'
  }, cb);
};