var util = require('util');
var utils = require('utils');
var fs = require('fs');
var path = require('path');
var uuid = require('node-uuid');
var Connection = require('Connection');
var Dao = require('Dao');

var Attach = function (service) {
  Dao.call(this, service, null, null);
};

util.inherits(Attach, Dao);

module.exports = Attach;

/**
 * 复制附件√
 * @param {*} req 
 * @param {*} args 
 * from_app_code from_app_data_id
 * to_app_code to_app_data_id to_code to_name
 * @param {*} cb 
 */
Attach.prototype.copyFile = function (req, args, cb) {
  var self = this;
  //查询原附件
  self.getAttachByApp(req, { "app_code": args.from_app_code, "app_data_id": args.from_app_data_id }, function (from_obj) {
    //创建目录
    self.mkdir(req, { "app_code": args.to_app_code }, function (to_path) {
      var to_obj = {};
      to_obj.app_code = args.to_app_code;
      to_obj.app_data_id = args.to_app_data_id;
      if (args.to_code == null) to_obj.code = uuid.v1().replace(/-/g, '');
      else to_obj.code = args.to_code;
      //工作附件和工作正文
      if (args.to_app_code == 'wf_work_doc' || args.to_app_code == 'wf_work_file') {
        if (args.to_name == null) {
          var i = from_obj.name.lastIndexOf('.');
          to_obj.name = from_obj.name.substr(0,i) + '_' + to_obj.code + '.' + from_obj.name.substr(i+1);
        }
        else { 
          var i = args.to_name.lastIndexOf('.');
          to_obj.name = args.to_name.substr(0,i) + '_' + to_obj.code + '.' + args.to_name.substr(i+1);
        }
      } else {
        if (args.to_name == null) to_obj.name = from_obj.name;
        else to_obj.name = args.to_name;
      }
      to_obj.size = from_obj.size;
      to_obj.type = from_obj.type;
      to_obj.save_path = to_path + to_obj.code + ".file";
      //复制文件
      fs.copyFileSync(path.join(server.attachSavePath, from_obj.save_path), path.join(server.attachSavePath, to_obj.save_path));
      //添加新附件
      self.addAttach(req, to_obj, function (insertId) {
        to_obj.id = insertId;
        cb(to_obj);
      });
    });
  });
};

/**
 * 构造目录
 * @param {*} req 
 * @param {*} args 
 * app_code path_moulds
 * @param {*} cb 
 * relativePath
 */
Attach.prototype.mkdir = function (req, args, cb) {
  //orgCode/app_code/path_moulds
  var relativePath = "";
  var absolutePath = "";
  relativePath = '/' + req.session.orgCode + '/';
  absolutePath = path.join(server.attachSavePath, relativePath);
  if (!fs.existsSync(absolutePath)) fs.mkdirSync(absolutePath);

  relativePath += args.app_code + '/';
  absolutePath = path.join(server.attachSavePath, relativePath);
  if (!fs.existsSync(absolutePath)) fs.mkdirSync(absolutePath);

  if (args.path_moulds != null) {
    var n = new Date();
    for (var i = 0; i < args.path_moulds.length; i++) {
      var path_mould = args.path_moulds[i];
      var d = '';
      switch (path_mould) {
        case 'yyyy':
          d = utils.formatDate(n, 'yyyy');
          break;
        case 'MM':
          d = utils.formatDate(n, 'MM');
          break;
        case 'dd':
          d = utils.formatDate(n, 'dd');
          break;
        case 'yyyyMM':
          d = utils.formatDate(n, 'yyyyMM');
          break;
        case 'yyyyMMdd':
          d = utils.formatDate(n, 'yyyyMMdd');
          break;
        case 'yyyy_MM':
          d = utils.formatDate(n, 'yyyy_MM');
          break;
        case 'yyyy_MM_dd':
          d = utils.formatDate(n, 'yyyy_MM_dd');
          break;
        default:
          d = path_mould;
      }

      relativePath += d + '/';
      absolutePath = path.join(server.attachSavePath, relativePath);
      if (!fs.existsSync(absolutePath)) fs.mkdirSync(absolutePath);
    }
  }
  else {
    relativePath += utils.formatDate(new Date(), 'yyyy_MM') + '/';
    absolutePath = path.join(server.attachSavePath, relativePath);
    if (!fs.existsSync(absolutePath)) fs.mkdirSync(absolutePath);
  }

  cb(relativePath);

};

/**
 * 数据库获取附件
 * @param {*} req 
 * @param {*} args 
 * code
 * @param {*} cb 
 * obj
 */
Attach.prototype.getAttach = function (req, args, cb) {
  var self = this;
  self.execute("select id,code,name,size,type,save_path,app_code,app_data_id from sys_app_attach " +
    "where org_id=? and code=? and (status=0 or status is null)",
    [req.session.orgId, args.file_code], function (list) {
      if (list.length == 0) {
        cb(null);
        return;
      }
      cb(list[0]);
      return;
    });
};

/**
 * 数据库获取附件
 * @param {*} req 
 * @param {*} args 
 * app_code app_data_id
 * @param {*} cb 
 */
Attach.prototype.getAttachByApp = function (req, args, cb) {
  var self = this;
  self.execute("select id,code,name,size,type,save_path,app_code,app_data_id from sys_app_attach " +
    "where org_id=? and app_code=? and app_data_id=? and (status=0 or status is null)",
    [req.session.orgId, args.app_code, args.app_data_id], function (list) {
      if (list.length == 0) {
        cb(null);
        return;
      }
      cb(list[0]);
      return;
    });
};

/**
 * 数据库添加附件（单独事务）
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 */
Attach.prototype.addAttach = function (req, args, cb) {
  var self = this;
  // var connection = new Connection(server.config.Database);
  // connection.open(function (errO) {
  //   if (errO) {
  //     cb(null);
  //     return;
  //   }
  //   connection.execute("insert into sys_app_attach(org_id,code,name,size,type,save_path,app_code,app_data_id,uploader_id,uploader_name,upload_time) " +
  //     "values(?,?,?,?,?,?,?,?,?,?,?)",
  //     [req.session.orgId, args.code, args.name, args.size, args.type, args.save_path, args.app_code, args.app_data_id, req.session.userId, req.session.userName, new Date()],
  //     function (errE, results) {
  //       if (errE) {
  //         cb(null);
  //         return;
  //       }
  //       cb(results.insertId);
  //     })
  // });

  self.execute("insert into sys_app_attach(org_id,code,name,size,type,save_path,app_code,app_data_id,uploader_id,uploader_name,upload_time) " +
    "values(?,?,?,?,?,?,?,?,?,?,?)",
    [req.session.orgId, args.code, args.name, args.size, args.type, args.save_path, args.app_code, args.app_data_id, req.session.userId, req.session.userName, new Date()],
    function (ret) {
      cb(ret.insertId);
    });
};