var util = require('util');
var utils = require('utils');
var Dao = require('Dao');
var OrgDao = require('../dao/org');
var OrgLogDao = require('../dao/org_log');
var RoleDao = require('../dao/role');
var UserDao = require('../dao/user');
var VUserOneDao = require('../dao/vuser_one');
var DepPostDao = require('../dao/dep_user');
var OwnRoleDao = require('../dao/role_user');
var DepUserDao = require('../dao/dep_user');

var UserBll = function (service) {
  Dao.call(this, service, null, null);

  this.userDao = new UserDao(service);
  this.orgDao = new OrgDao(service);
  this.orgLogDao = new OrgLogDao(service);
  this.depUserDao = new DepUserDao(service);
  this.ownRoleDao = new OwnRoleDao(service);
};

util.inherits(UserBll, Dao);

module.exports = UserBll;

/**
 * 验证添加用户
 * @param {*} req 
 * @param {*} args 
 * user(code name loginname sex mobile email tel_short tel_work tel_home tel_other)
 * @param {*} cb 
 * null msg
 */
UserBll.prototype.verify_insert_user = function (req, args, cb) {
  var self = this;
  if (!args.user.code) {
    cb(null, '请提供用户编码！');
    return;
  }
  if (!args.user.name) {
    cb(null, '请提供用户姓名！');
    return;
  }
  if (!args.user.loginname) {
    cb(null, '请提供登录名！');
    return;
  }
  //TODO loginname验证
  if (!args.user.dep_id) {
    cb(null, '请选择用户所在的部门！');
    return;
  }
  if (!utils.isInt(args.user.dep_id)) {
    cb(null, '请提供正确的部门编号！');
    return;
  }
  if (args.user.mobile && !utils.isPhone(args.user.mobile)) {
    cb(null, '请提供正确的手机号！');
    return;
  }
  if (args.user.email && !utils.isEmail(args.user.email)) {
    cb(null, '请提供正确的邮件地址！');
    return;
  }

  self.execute("select count(*) as count from tm_user where org_id=? and loginname=? and status=0", [req.session.orgId, args.user.loginname], function (rows0) {
    if (rows0[0].count > 0) {
      cb(null, '用户名已经存在！');
      return;
    }
    if (req.mobile) {
      self.execute("select count(*) as count from tm_user where org_id=? and mobile=? and status=0", [req.session.orgId, args.user.mobile], function (rows1) {
        if (rows1[0].count > 0) {
          cb(null, '手机号已存在！');
          return;
        }

        server.lcManager.checkUserCount(req, function (code, err) {
          if (code != 0) {
            cb(null, err.message);
            return;
          }
          cb(null);
          return;
        });
      });
    }
    else {
      server.lcManager.checkUserCount(req, function (code, err) {
        if (code != 0) {
          cb(null, err.message);
          return;
        }
        cb(null);
        return;
      });
    }
  });
};

/**
 * 添加用户
 * @param {*} req 
 * @param {*} args 
 * user(code name loginname password sex mobile email tel_short tel_work tel_home tel_other dep_id post_id level_id role_id)
 * org
 * org_setting
 * role_id
 * @param {*} cb 
 * obj(user deppost ownrole)
 */
UserBll.prototype.insert_user = function (req, args, cb) {
  var self = this;
  self.depPostDao = new DepPostDao(self.service);
  self.ownRoleDao = new OwnRoleDao(self.service);
  //添加用户
  var user = {};
  user.org_id = req.session.orgId;
  user.code = args.user.code;
  user.name = args.user.name;
  user.loginname = args.user.loginname;
  user.sex = args.user.sex;
  if (user.sex == null) user.sex = 0;
  user.nickname = args.user.nickname;
  if (user.nickname == null) user.nickname = user.name;
  user.mobile = args.user.mobile;
  user.email = args.user.email;
  user.tel_short = args.user.tel_short;
  user.tel_work = args.user.tel_work;
  user.tel_home = args.user.tel_home;
  user.tel_other = args.user.tel_other;
  user.office_location = args.user.office_location;
  // motto post head_code
  user.password = args.org.default_pwd;
  // user.password = args.user.password;
  // user.theme = args.setting.theme;
  user.status = 0;
  user.web_status = 0;
  user.mobile_status = 0;
  user.pc_status = 0;
  user.creater_id = req.session.userId;
  user.createtime = new Date();
  self.userDao.create(user, function (ret) {
    user.id = ret.insertId;
    //添加用户部门岗位
    var user_deppost = {};
    user_deppost.org_id = req.session.orgId;
    user_deppost.user_id = user.id;
    user_deppost.order_number = 1;
    user_deppost.dep_id = args.user.dep_id;
    if (args.user.post_id) user_deppost.post_id = args.user.post_id;
    else user_deppost.post_id = 0;
    if (args.user.level_id) user_deppost.level_id = args.user.level_id;
    else user_deppost.level_id = 0;
    user_deppost.status = 0;
    user_deppost.creater_id = req.session.userId;
    user_deppost.createtime = new Date();
    self.depPostDao.create(user_deppost, function (retd) {
      user_deppost.id = retd.insertId;
      //添加用户角色
      var user_ownrole = {};
      user_ownrole.org_id = req.session.orgId;
      user_ownrole.user_id = user.id;
      user_ownrole.role_id = args.role_id;
      user_ownrole.is_admin = 0;
      user_ownrole.status = 0;
      user_ownrole.creater_id = req.session.userId;
      user_ownrole.createtime = new Date();
      self.ownRoleDao.create(user_ownrole, function (retr) {
        user_ownrole.id = retr.insertId;
        cb({ "user": user, "deppost": user_deppost, "ownrole": user_ownrole });
        return;
      });
    });
  });
};

/**
 * 验证添加用户
 * @param {*} req 
 * @param {*} args 
 * user(id code name loginname sex mobile email tel_short tel_work tel_home tel_other)
 * @param {*} cb 
 * null msg
 */
UserBll.prototype.verify_update_user = function (req, args, cb) {
  var self = this;
  if (!args.user.id) {
    cb(null, '请提供用户编号！');
    return;
  }
  if (!args.user.code) {
    cb(null, '请提供用户编码！');
    return;
  }
  if (!args.user.name) {
    cb(null, '请提供用户姓名！');
    return;
  }
  if (!args.user.loginname) {
    cb(null, '请提供登录名！');
    return;
  }
  //TODO loginname验证
  if (args.user.mobile && !utils.isPhone(args.user.mobile)) {
    cb(null, '请提供正确的手机号！');
    return;
  }
  if (args.user.email && !utils.isEmail(args.user.email)) {
    cb(null, '请提供正确的邮件地址！');
    return;
  }

  self.execute("select count(*) as count from tm_user where org_id=? and id<>? and loginname=? and status=0",
    [req.session.orgId, args.user.id, args.user.loginname], function (rows0) {
      if (rows0[0].count > 0) {
        cb(null, '用户名已经存在！');
        return;
      }

      if (req.mobile != null && req.mobile != "") {
        self.execute("select count(*) as count from tm_user where org_id=? and id<>? and mobile=? and status=0",
          [req.session.orgId, args.user.id, args.user.mobile], function (rows1) {
            if (rows1[0].count > 0) {
              cb(null, '手机号已存在！');
              return;
            }
            cb(null);
            return;
          });
      }
      else {
        cb(null);
        return;
      }
    });
};

/**
 * 修改用户
 * @param {*} req 
 * @param {*} args
 * user(id code name loginname sex mobile email tel_short tel_work tel_home tel_other) 
 * @param {*} cb 
 * obj(user)
 */
UserBll.prototype.update_user = function (req, args, cb) {
  var self = this;

  //添加用户
  var user = {};
  user.org_id = req.session.orgId;
  user.code = args.user.code;
  user.name = args.user.name;
  user.loginname = args.user.loginname;
  user.sex = args.user.sex;
  if (user.sex == null) user.sex = 0;
  user.nickname = args.user.nickname;
  if (user.nickname == null) user.nickname = user.name;
  user.mobile = args.user.mobile;
  user.email = args.user.email;
  user.office_location = args.user.office_location;
  user.tel_short = args.user.tel_short;
  user.tel_work = args.user.tel_work;
  user.tel_home = args.user.tel_home;
  user.tel_other = args.user.tel_other;
  user.status = 0;
  // user.last_modifier_id = req.session.userId;
  // user.last_modify_time = new Date();
  self.userDao.update(user, {
    where: 'org_id=? and id=?',
    params: [req.session.orgId, args.user.id]
  }, function () {
    user.id = args.user.id;
    cb({ "user": user });
    return;
  });
};

/**
 * 离职用户
 * @param {*} req 
 * @param {*} args 
 * id
 * @param {*} cb 
 * null msg
 */
UserBll.prototype.verify_delete_user = function (req, args, cb) {
  var self = this;
  if (!args.id) {
    cb(null, '请提供用户编号！');
    return;
  }

  cb(null);
  return;
};

/**
 * 复职用户
 * @param {*} req 
 * @param {*} args 
 * id
 * @param {*} cb 
 * null msg
 */
UserBll.prototype.verify_enable_user = function (req, args, cb) {
  var self = this;
  if (!args.id) {
    cb(null, '请提供用户编号！');
    return;
  }

  cb(null);
  return;
};

/**
 * 删除用户
 * @param {*} req 
 * @param {*} args 
 * id
 * @param {*} cb 
 * obj(id) msg
 */
UserBll.prototype.delete_user = function (req, args, cb) {
  var self = this;
  var params = [req.session.orgId];
  var key = '';
  var val = '';
  if (args.id.split(',').length > 0) {
    for (var i = 0; i < args.id.split(',').length; i++) {
      var id = args.id.split(',')[i];
      if (key) key += ',';
      key += '?';
      params.push(id);
    }
  }
  //删除用户
  self.userDao.update({ "status": 2 }, { //"deleter_id": req.session.userId, "delete_time": new Date(),
    where: 'org_id=? and id in (' + key + ')',
    params: params
  }, function () {
    // 部门、角色、管辖、上级
    self.execute('delete from sys_role_user where org_id=? and user_id in (' + key + ')', params, function () {
      self.execute('delete from sys_dep_user where org_id=? and user_id in (' + key + ')', params, function () {
        self.execute('delete from sys_user_subdep where org_id=? and user_id in (' + key + ')', params, function () {
          self.execute('delete from sys_user_superior where org_id=? and user_id in (' + key + ')', params, function () {
            cb({ "id": args.id });
            return;
          });
        });
      });
    });
  });
};

/**
 * 离职用户
 * @param {*} req 
 * @param {*} args 
 * id
 * @param {*} cb 
 * obj(id) msg
 */
UserBll.prototype.disable_user = function (req, args, cb) {
  var self = this;

  //离职用户
  self.userDao.update({ "status": 1 }, { //"deleter_id": req.session.userId, "delete_time": new Date(),
    where: 'org_id=? and id=?',
    params: [req.session.orgId, args.id]
  }, function () {
    // 处理中间表【角色、部门、兼职、管辖、上级】
    self.execute("update sys_role_user set status=1,deleter_id=?,delete_time=? where org_id=? and user_id=?",
      [req.session.userId, new Date(), req.session.orgId, req.session.userId], function () {
        self.execute("update sys_dep_user set status=1,deleter_id=?,delete_time=? where org_id=? and user_id=?",
          [req.session.userId, new Date(), req.session.orgId, req.session.userId], function () {
            self.execute("update sys_user_subdep set status=1,deleter_id=?,delete_time=? where org_id=? and user_id=?",
              [req.session.userId, new Date(), req.session.orgId, req.session.userId], function () {
                self.execute("update sys_user_superior set status=1,deleter_id=?,delete_time=? where org_id=? and user_id=?",
                  [req.session.userId, new Date(), req.session.orgId, req.session.userId], function () {
                    cb({ "id": args.id });
                    return;
                  });
              });
          });
      });
  });
};

/**
 * 复职用户
 * @param {*} req 
 * @param {*} args 
 * id
 * @param {*} cb 
 * obj(id) msg
 */
UserBll.prototype.enable_user = function (req, args, cb) {
  var self = this;

  //离职用户
  self.userDao.update({ "status": 0 }, { //"deleter_id": req.session.userId, "delete_time": new Date(),
    where: 'org_id=? and id=?',
    params: [req.session.orgId, args.id]
  }, function () {
    // 处理角色职员中间表
    self.execute("update sys_role_user set status=0 where org_id=? and user_id=?",
      [req.session.orgId, req.session.userId], function () {
        self.execute("update sys_dep_user set status=0 where org_id=? and user_id=?",
          [req.session.orgId, req.session.userId], function () {
            self.execute("update sys_user_subdep set status=0 where org_id=? and user_id=?",
              [req.session.orgId, req.session.userId], function () {
                self.execute("update sys_user_superior set status=0 where org_id=? and user_id=?",
                  [req.session.orgId, req.session.userId], function () {
                    cb({ "id": args.id });
                    return;
                  });
              });
          });
      });
  });
};

/**
 * 获取用户列表
 * @param {*} req 
 * @param {*} args 
 * com_id dep_id is_all keyword sex mobile status role_id post_id
 * include_deps 包含兼职人员 //include_subdeps 包含分管人员
 * show_deps 显示兼职 
 * show_subdeps 显示分管 show_roles 显示角色 show_supuser 显示上级 show_subuser 显示下属
 * @param {*} cb 
 * list msg
 */
UserBll.prototype.list_user = function (req, args, cb) {
  var self = this;
  var where = " org_id=?";
  var params = [req.session.orgId];
  var fields = "";

  if (args.com_id != null) {
    where += " and com_id=?";
    params.push(args.com_id);
  }

  if (args.dep_id != null) {
    if (args.is_all == null) {
      where += " and (dep_id=?";
      params.push(args.dep_id);
      if (args.include_deps == "Y") {
        where += " or connectvarchar3(',',getnumbers(deps),'') like ?";
        params.push('%,' + args.dep_id + ',%');
      }
      // if (args.include_subdeps == "Y") {
      //   where += " or connectvarchar3(',',getnumbers(subdeps),'') like ?";
      //   params.push('%,' + args.dep_id + ',%');
      // }
      where += ")";
    }
    else {
      where += " and parent_ids like ?";
      params.push('%,' + args.dep_id + ',%');
    }
  }
  else {
    if (args.is_all == null) where += " and dep_id=0";
  }

  if (args.keyword != null) {
    where += " and (name like ? or code like ? or loginname like ?)";
    params.push('%' + args.keyword + '%');
    params.push('%' + args.keyword + '%');
    params.push('%' + args.keyword + '%');
  }
  if (args.sex != null) {
    where += " and sex=?";
    params.push(args.sex);
  }
  if (args.mobile != null) {
    where += " and mobile like ?";
    params.push('%' + args.mobile + '%');
  }
  if (args.status) {
    where += " and status in (";
    for (var i = 0; i < args.status.split(',').length; i++) {
      if (i != 0) where += ',';
      where += '?';
      params.push(args.status.split(',')[i]);
    }
    where += ")";
  } else {
    where += " and status in (0)";
  }

  if (args.role_id) {
    where += ' and id in (select user_id from sys_role_user where org_id=? and role_id=? and status=0)';
    params.push(req.session.orgId);
    params.push(args.role_id);
  }

  if (args.post_id) {
    where += ' and post_id=?';
    params.push(args.post_id);
  }

  if (args.show_deps != "N") fields += ",getnumbers(deps) as dep_ids,getnames(deps) as dep_names";
  if (args.show_subdeps == "Y") fields += ",fsys_getsubdepids(org_id,id) as subdep_ids";
  if (args.show_roles == "Y") fields += ",fsys_getroleids(org_id,id) as role_ids";
  if (args.show_supuser == "Y") fields += ",fsys_getsupuserids(org_id,id) as supuser_ids";
  if (args.show_subuser == "Y") fields += ",fsys_getsubuserids(org_id,id) as subuser_ids";

  self.execute("select id,org_id,code,name,loginname,status,mobile,email,sex,nickname,head_code," +
    "dep_id,dep_name,dep_code,parent_id,parent_ids,com_id,com_name,com_code," +
    "post_id,post_name,post_code,level_id,level_name,level_code" + fields +
    " from vtm_user_one where " + where + " order by code ASC, id ASC", params, function (rows) {
      cb(rows);
      return;
    });
};

/**
 * 获取用户列表
 * @param {*} req 
 * @param {*} args 
 * com_id dep_id is_all keyword sex mobile status
 * include_deps 包含兼职人员 //include_subdeps 包含分管人员
 * show_deps 显示兼职 
 * show_subdeps 显示分管 show_roles 显示角色 show_supuser 显示上级 show_subuser 显示下属
 * @param {*} cb 
 * page msg
 */
UserBll.prototype.page_user = function (req, args, cb) {
  var self = this;
  self.vUserOneDao = new VUserOneDao(self.service);
  var where = " org_id=?";
  var params = [req.session.orgId];
  var fields = "";

  if (args.com_id) {
    where += " and com_id=?";
    params.push(args.com_id);
  }

  if (args.dep_id != null) {
    if (!args.is_all) {
      where += " and (dep_id=?";
      params.push(args.dep_id);
      if (args.include_deps == "Y") {
        where += " or connectvarchar3(',',getnumbers(deps),'') like ?";
        params.push('%,' + args.dep_id + ',%');
      }
      // if (args.include_subdeps == "Y") {
      //   where += " or connectvarchar3(',',getnumbers(subdeps),'') like ?";
      //   params.push('%,' + args.dep_id + ',%');
      // }
      where += ")";
    }
    else {
      where += " and parent_ids like ?";
      params.push('%,' + args.dep_id + ',%');
    }
  }
  else {
    if (args.is_all == null) where += " and dep_id=0";
  }

  if (args.keyword) {
    where += " and (name like ? or code like ? or loginname like ? or mobile like ? or tel_short like ?)";
    params.push('%' + args.keyword + '%');
    params.push('%' + args.keyword + '%');
    params.push('%' + args.keyword + '%');
    params.push('%' + args.keyword + '%');
    params.push('%' + args.keyword + '%');
  }
  if (args.sex != null) {
    where += " and sex=?";
    params.push(args.sex);
  }
  if (args.mobile != null) {
    where += " and mobile like ?";
    params.push('%' + args.mobile + '%');
  }
  if (args.status != null) {
    where += " and status in (";
    for (var i = 0; i < args.status.split(',').length; i++) {
      if (i != 0) where += ',';
      where += '?';
      params.push(args.status.split(',')[i]);
    }
    where += ")";
  } else {
    where += " and status in (0)";
  }

  if (args.show_deps != "N") fields += ",getnumbers(deps) as dep_ids,getnames(deps) as dep_names";
  if (args.show_subdeps == "Y") fields += ",fsys_getsubdepids(org_id,id) as subdep_ids";
  if (args.show_roles == "Y") fields += ",fsys_getroleids(org_id,id) as role_ids";
  if (args.show_supuser == "Y") fields += ",fsys_getsupuserids(org_id,id) as supuser_ids";
  if (args.show_subuser == "Y") fields += ",fsys_getsubuserids(org_id,id) as subuser_ids";

  self.vUserOneDao.queryDataPage(req, {
    fields: "id,org_id,code,name,loginname,status,mobile,email,sex,nickname,head_code," +
      "dep_id,dep_name,dep_code,parent_id,parent_ids,com_id," +
      "post_id,post_name,post_code,level_id,level_name,level_code,tel_short,tel_work,office_location,parent_name,com_name" +
      fields,
    where: where,
    params: params,
    order: "code ASC, id ASC"
  }, function (page) {
    cb(page);
    return;
  });
};

/**
 * 获取职员信息
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 * @returns 
 */
UserBll.prototype.get_user = function (req, args, cb) {
  var self = this;
  if (!args.id) {
    cb(null, '请提供职员编号！');
    return;
  }

  var where = " org_id=? and id=? and status in (0, 1)";
  var params = [req.session.orgId, args.id];
  self.execute("select id,org_id,code,name,loginname,password,sex,mobile,email,tel_short,tel_work,tel_home,tel_other,head_id,theme,nickname " +
    "from vsys_user where " + where, params, function (rows) {
      if (rows.length <= 0) {
        cb(null, "请提供正确的角色编号！");
        return;
      }
      cb(rows[0]);
    });
};

UserBll.prototype.verify_import_bll = function (req, args, cb) {
};

UserBll.prototype.import_bll = function (req, args, cb) {
};

/**
 * 验证删除用户部门
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 */
UserBll.prototype.verify_delete_dep_user = function (req, args, cb) {
  var self = this;
  if (!args.id) {
    cb(null, '请提供编号！');
    return;
  }

  cb(null);
  return;
};

/**
 * 删除用户部门
 * @param {*} req 
 * @param {*} args 
 * id
 * @param {*} cb 
 * obj(id) msg
 */
UserBll.prototype.delete_dep_user = function (req, args, cb) {
  var self = this;
  var params = [req.session.orgId];
  var key = '';
  if (args.id.split(',').length > 0) {
    for (var i = 0; i < args.id.split(',').length; i++) {
      var id = args.id.split(',')[i];
      if (key) key += ',';
      key += '?';
      params.push(id);
      console.log(id);
    }
  }

  self.depUserDao.delete({ where: 'org_id=? and id in (' + key + ')', params: params }, function () {
    cb(null);
    return;
  });
};

/**
 * 查询用户部门
 * @param {*} req 
 * @param {*} args 
 * id
 * @param {*} cb 
 * obj(id) msg
 */
UserBll.prototype.get_dep_user = function (req, args, cb) {
  var self = this;
  var where = " org_id=? and id=?";
  var params = [req.session.orgId, args.id];
  self.execute("select dep_id,user_id from sys_dep_user where " + where, params, function (rows) {
    if (rows.length <= 0) {
      cb(null, "请提供正确的编号！");
      return;
    }
    cb(rows[0]);
  });
};

/**
 * 查询用户部门
 * @param {*} req 
 * @param {*} args 
 * id、user_id、isAll
 * @param {*} cb 
 * obj(id) msg
 */
UserBll.prototype.getList_dep_user = function (req, args, cb) {
  var self = this;
  var params = [req.session.orgId];
  var where = '';
  if (args.id) {
    var key = '';
    if (args.id.split(',').length > 0) {
      for (var i = 0; i < args.id.split(',').length; i++) {
        var id = args.id.split(',')[i];
        if (key) key += ',';
        key += '?';
        params.push(id);
      }
    }
    where += " and id in (" + key + ")";
  }
  if (args.user_id) {
    where += ' and user_id=?';
    params.push(args.user_id);
  }
  if (!args.isAll) {
    where += ' and status=0';
  }

  self.execute("select id,org_id,order_number,user_id,dep_id,post_id,level_id from sys_dep_user where org_id=?" + where, params, function (rows) {
    if (rows.length <= 0) {
      cb(null, "请提供正确的编号！");
      return;
    }
    cb(rows);
  });
};

/**
 * 添加用户部门验证
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 */
UserBll.prototype.verify_add_dep_user = function (req, args, cb) {
  var self = this;
  if (!args.depUser.user_id) {
    cb(null, '请提供用户编号！');
    return;
  }
  if (!args.depUser.dep_id && !args.depUser.post_id && !args.depUser.level_id) {
    cb(null, '请提供部门、岗位、级别中的一项！');
    return;
  }

  // 已存在的直接跳过
  self.execute("select id from sys_dep_user where org_id=? and user_id=? and dep_id=? and post_id=? and level_id=?",
    [req.session.orgId, args.depUser.user_id, args.depUser.dep_id, args.depUser.post_id, args.depUser.level_id], function (rows) {
      if (rows.length > 0) {
        cb(null, '已存在对应数据，不能重复添加！');
        return;
      }
      cb(null);
      return;
    });
};

/**
 * 添加用户部门
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 */
UserBll.prototype.insert_dep_user = function (req, args, cb) {
  var self = this;
};

/**
 * 验证删除用户角色
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 */
UserBll.prototype.verify_delete_role_user = function (req, args, cb) {
  var self = this;
  if (!args.user_id) {
    cb(null, '请提供职员编号！');
    return;
  }
  if (!args.role_ids) {
    cb(null, '请提供角色编号！');
    return;
  }

  cb(null);
  return;
};

/**
 * 查询用户角色
 * @param {*} req 
 * @param {*} args 
 * role_ids、isAll、user_id
 * @param {*} cb 
 */
UserBll.prototype.getList_role_user = function (req, args, cb) {
  var self = this;
  var where = '';
  var params = [req.session.orgId];
  if (args.role_ids) {
    var key = '';
    if (args.role_ids.split(',').length > 0) {
      for (var i = 0; i < args.role_ids.split(',').length; i++) {
        var id = args.role_ids.split(',')[i];
        if (key) key += ',';
        key += '?';
        params.push(id);
      }
    }
    where += " and role_id in (" + key + ")";
  }

  if (!args.isAll) {
    where += ' and status=0';
  }

  if (args.user_id) {
    where += ' and user_id=?';
    params.push(args.user_id);
  }
  self.execute("select id,org_id,user_id,role_id,is_admin from sys_role_user where org_id=?" + where, params, function (rows) {
    if (rows.length <= 0) {
      cb(null, "请提供正确的编号！");
      return;
    }
    cb(rows);
  });
};

/**
 * 查询管辖
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 */
UserBll.prototype.getList_sub_user = function (req, args, cb) {
  var self = this;
  var where = '';
  var params = [req.session.orgId];

  if (!args.isAll) {
    where += ' and status=0';
  }

  if (args.user_id) {
    where += ' and user_id=?';
    params.push(args.user_id);
  }
  self.execute("select id,org_id,order_number,user_id,dep_id,layer_id from sys_user_subdep where org_id=?" + where, params, function (rows) {
    // if (rows.length <= 0) {
    //   cb(null, "请提供正确的编号！");
    //   return;
    // }
    cb(rows);
  });
};

/**
 * 查询上级
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 */
UserBll.prototype.getList_sup_user = function (req, args, cb) {
  var self = this;
  var where = '';
  var params = [req.session.orgId];
  if (!args.isAll) {
    where += ' and status=0';
  }

  if (args.user_id) {
    where += ' and user_id=?';
    params.push(args.user_id);
  }
  self.execute("select id,org_id,user_id,leader_id from sys_user_superior where org_id=?" + where, params, function (rows) {
    // if (rows.length <= 0) {
    //   cb(null, "请提供正确的编号！");
    //   return;
    // }
    cb(rows);
  });
};

/**
 * 删除用户角色
 * @param {*} req 
 * @param {*} args 
 * id
 * @param {*} cb 
 * obj(id) msg
 */
UserBll.prototype.delete_role_user = function (req, args, cb) {
  var self = this;
  var params = [req.session.orgId, args.user_id];
  var key = '';
  if (args.role_ids.split(',').length > 0) {
    for (var i = 0; i < args.role_ids.split(',').length; i++) {
      var id = args.role_ids.split(',')[i];
      if (key) key += ',';
      key += '?';
      params.push(id);
    }
  }

  self.ownRoleDao.delete({
    where: 'org_id=? and user_id=? and status=0 and role_id in (' + key + ')',
    params: params
  }, function () {
    cb({ "id": args.id });
    return;
  });
};





