var util = require('util');
var Dao = require('Dao');
var SupuserDao = require('../dao/user_superior');

var SupserBll = function (service) {
    Dao.call(this, service, null, null);

    this.supuserDao = new SupuserDao(service);
};

util.inherits(SupserBll, Dao);

module.exports = SupserBll;

/**
 * 获取上级列表
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 */
SupserBll.prototype.listv_supuser = function (req, args, cb) {
    var self = this;
    console.log(args.user_id + 'user_id');
    var where = " org_id=? and user_id=?";
    var params = [req.session.orgId, args.user_id];
    self.execute("select id,org_id,user_id,leader_id," +
        "creater_id,createtime,leader_name,leader_code,leader_sex,leader_mobile " +
        "from vsys_user_superior where " + where + " order by id ASC", params, function (rows) {
            cb(rows);
        });
};

/**
 * 添加验证
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 */
SupserBll.prototype.verify_insert_supuser = function (req, args, cb) {
    if (!args.supuser.leader_id) {
        cb(null, '上级编号不能为空！');
        return;
    }
    if (!args.supuser.user_id) {
        cb(null, '职员编号不能为空！');
        return;
    }
    cb(null);
    return;
};

/**
 * 查询上级
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 */
SupserBll.prototype.query_supuser = function (req, args, cb) {
    var self = this;
    var where = "org_id=? and user_id=? and leader_id=?";
    var params = [req.session.orgId, args.supuser.user_id, args.supuser.leader_id];
    self.execute('select id from sys_user_superior where ' + where, params, function (rows) {
        cb(rows);
    })
};

/**
 * 添加上级
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 */
SupserBll.prototype.insert_supuser = function (req, args, cb) {
    var self = this;
    var supuser = {};
    supuser.org_id = req.session.orgId;
    supuser.user_id = args.supuser.user_id;
    supuser.leader_id = args.supuser.leader_id;
    supuser.status = 0;
    supuser.creater_id = req.session.userId;
    supuser.createtime = new Date();

    self.supuserDao.create(supuser, function (ret) {
        supuser.id = ret.insertId;
        cb({ "supuser": supuser });
        return;
    });
};

/**
 * 删除验证
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 */
SupserBll.prototype.verify_delete_supuser = function (req, args, cb) {
    if (!args.id) {
        cb(null, '编号不能为空！');
        return;
    }
    cb(null);
    return;
};

/**
 * 删除上级
 * @param {]} req 
 * @param {*} args 
 * @param {*} cb 
 */
SupserBll.prototype.delete_supuser = function (req, args, cb) {
    var self = this;
    var params = [req.session.orgId];
    var key = '';
    if (args.id.split(',').length > 0) {
        for (var i = 0; i < args.id.split(',').length; i++) {
            var id = args.id.split(',')[i];
            if (key) key += ',';
            key += '?';
            params.push(id);
            console.log(id);
        }
    }
    self.supuserDao.delete({ where: 'org_id=? and id in (' + key + ')', params: params }, function () {
        cb(null);
        return;
    });
};




