var util = require('util');
var utils = require('utils');
var Dao = require('Dao');
var RoleDao = require('../dao/role');

var RoleBll = function (service) {
  Dao.call(this, service, null, null);

  this.roleDao = new RoleDao(service);
};

util.inherits(RoleBll, Dao);

module.exports = RoleBll;

/**
 * 获取角色列表
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 */
RoleBll.prototype.list_role = function (req, args, cb) {
  var self = this;
  var where = " org_id=? and status in (0,1)";
  var params = [req.session.orgId];

  if (args.keyword != null) {
    where += " and (name like ? or code like ?)";
    params.push('%' + args.keyword + '%');
    params.push('%' + args.keyword + '%');
  }
  self.execute("select id,org_id,code,name,status," +
    "creater_id,createtime,description,last_modifier_id,last_modify_time " +
    "from sys_role   where " + where + " order by code ASC, id ASC", params, function (rows) {
      cb(rows);
    });
};

/**
 * 添加验证
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 */
RoleBll.prototype.verify_insert_role = function (req, args, cb) {
  var self = this;
  if (!args.id) {
    cb('请提供角色编号！');
    return;
  }

  self.roleDao.execute("select count(*) as count from sys_role_user where org_id=? and role_id=? and status=0", [req.session.orgId, args.id], function (rows) {
    if (rows[0].count > 0) {
      cb(null, '角色内还有用户，目前不能删除！');
      return;
    }
    cb(null);
  });
};

/**
 * 添加角色
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 */
RoleBll.prototype.insert_role = function (req, args, cb) {
  var self = this;
  var role = {};
  role.org_id = req.session.orgId;
  role.code = args.role.code;
  role.name = args.role.name;
  role.description = args.role.description;
  if (args.role.type_id)
    role.type_id = args.role.type_id;
  else
    role.type_id = null;
  role.status = 0;
  role.creater_id = req.session.userId;
  role.createtime = new Date();
  role.last_modifier_id = req.session.userId;
  role.last_modify_time = new Date();

  //添加角色
  self.roleDao.create(role, function (ret) {
    role.id = ret.insertId;

    cb({ "role": role });
    return;
  });
};

/**
 * 获取角色
 * @param {*} req 
 * @param {*} args 
 * id
 * @param {*} cb 
 * role msg
 */
RoleBll.prototype.get_role = function (req, args, cb) {
  var self = this;
  if (!args.id) {
    cb(null, '请提供角色编号！');
    return;
  }

  var where = " org_id=? and id=? and status in (0)";
  var params = [req.session.orgId, args.id];
  self.execute("select id,org_id,code,name from sys_role where " + where, params, function (rows) {
    if (rows.length <= 0) {
      cb(null, "请提供正确的角色编号！");
      return;
    }
    cb(rows[0]);
    return;
  });
};

/**
 * 验证修改角色
 * @param {*} req 
 * @param {*} args 
 * role(id code name description)
 * o_role(id code name)
 * @param {*} cb 
 * null msg
 */
RoleBll.prototype.verify_update_role = function (req, args, cb) {
  var self = this;
  if (!args.role.id) {
    cb(null, '请提供角色编号！');
    return;
  }
  if (!args.role.code) {
    cb(null, '请提供角色代码！');
    return;
  }
  if (!args.role.name) {
    cb(null, '请提供角色名称！');
    return;
  }

  cb(null);
  return;
};

/**
 * 修改角色
 * @param {*} req 
 * @param {*} args 
 * role(id code name description)
 * o_role(id code name)
 * @param {*} cb 
 * obj(role)
 */
RoleBll.prototype.update_role = function (req, args, cb) {
  var self = this;
  var role = {};
  role.org_id = req.session.orgId;
  role.code = args.role.code;
  role.name = args.role.name;
  if (args.role.type_id) role.type_id = args.role.type_id;
  role.description = args.role.description;
  role.last_modifier_id = req.session.userId;
  role.last_modify_time = new Date();

  //修改角色
  self.roleDao.update(role, {
    where: 'org_id=? and id=?',
    params: [req.session.orgId, args.role.id]
  }, function () {
    role.id = args.role.id;
    cb({ "role": role });
    return;
  });
};

/**
 * 删除角色
 * @param {*} req 
 * @param {*} args 
 * id
 * @param {*} cb 
 * null msg
 */
RoleBll.prototype.verify_delete_role = function (req, args, cb) {
  var self = this;
  if (!args.id) {
    cb(null, '请提供角色编号！');
    return;
  }

  self.roleDao.execute("select count(*) as count from sys_role_user where org_id=? and role_id=? and status=0", [req.session.orgId, args.id], function (rows) {
    if (rows[0].count > 0) {
      cb(null, '角色内还有用户，目前不能删除！');
      return;
    }
    cb(null);
  });
};


/**
 * 启用角色
 * @param {*} req 
 * @param {*} args 
 * id
 * @param {*} cb 
 * null msg
 */
RoleBll.prototype.verify_enable_role = function (req, args, cb) {
  var self = this;
  if (!args.id) {
    cb(null, '请提供角色编号！');
    return;
  }

  cb(null);
};

/**
 * 停用角色
 * @param {*} req 
 * @param {*} args 
 * id
 * @param {*} cb 
 * null msg
 */
RoleBll.prototype.verify_disable_role = function (req, args, cb) {
  var self = this;
  if (!args.id) {
    cb(null, '请提供角色编号！');
    return;
  }
  cb(null);

  // self.roleDao.execute("select count(*) as count from sys_role_user where org_id=? and role_id=? and status=0", [req.session.orgId, args.id], function (rows) {
  //   if (rows[0].count > 0) {
  //     cb(null, '角色内还有用户，目前不能停用！');
  //     return;
  //   }
  //   cb(null);
  // });
};

/**
 * 删除角色
 * @param {*} req 
 * @param {*} args 
 * id
 * @param {*} cb 
 * obj(id)
 */
RoleBll.prototype.delete_role = function (req, args, cb) {
  var self = this;

  //删除角色
  self.roleDao.update({ "deleter_id": req.session.userId, "delete_time": new Date(), "status": 2 }, {
    where: 'org_id=? and id=?',
    params: [req.session.orgId, args.id]
  }, function () {
    // 删除角色对应人员
    var params = [req.session.orgId, args.id];
    self.execute("delete from sys_role_user where org_id=? and role_id=?", params, function () {
      cb({ "id": args.id });
    });
  });
};

/**
 * 停用角色
 * @param {*} req 
 * @param {*} args 
 * id
 * @param {*} cb 
 * obj(id)
 */
RoleBll.prototype.disable_role = function (req, args, cb) {
  var self = this;
  //停用角色
  self.roleDao.update({ "last_modifier_id": req.session.userId, "last_modify_time": new Date(), "status": 1 }, {
    where: 'org_id=? and id=?',
    params: [req.session.orgId, args.id]
  }, function () {
    // 处理与该角色对应的用户
    self.execute('update sys_role_user set status=1,deleter_id=?,delete_time=? where org_id=? and role_id=? and status=0',
      [req.session.userId, new Date(), req.session.orgId, args.id],
      function () {
        cb({ "id": args.id });
      });
  });
};

/**
 * 启用角色
 * @param {*} req 
 * @param {*} args 
 * id
 * @param {*} cb 
 * obj(id)
 */
RoleBll.prototype.enable_role = function (req, args, cb) {
  var self = this;
  self.roleDao.update({ "last_modifier_id": req.session.userId, "last_modify_time": new Date(), "status": 0 }, {
    where: 'org_id=? and id=?',
    params: [req.session.orgId, args.id]
  }, function () {
    cb({ "id": args.id });
  });
};

/**
 * 启用角色职员
 * @param {*} req 
 * @param {*} args 
 * id
 * @param {*} cb 
 * obj(id)
 */
RoleBll.prototype.enable_role_user = function (req, args, cb) {
  var self = this;
  // 同时恢复已删除的职员对应、只处理用户状态是正常的
  self.execute('select ru.* from sys_role_user as ru join tm_user as u on ru.org_id=u.org_id and ru.user_id=u.id where ru.org_id=? and ru.role_id=? and ru.status=1 and u.status=0',
    [req.session.orgId, args.id], function (rows) {
      var params = [req.session.orgId];
      var key = '';
      for (var i = 0; i < rows.length; i++) {
        if (key) key += ',';
        key += '?';
        params.push(rows[i].id);
      }
      self.execute('update sys_role_user set status=0 where org_id=? and id in (' + key + ')', params, function () {
        cb(rows);
      });
    });
};

/**
 * 获取角色
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 */
RoleBll.prototype.getv_role = function (req, args, cb) {
  var self = this;
  if (!args.id) {
    cb(null, '请提供角色编号！');
    return;
  }

  var where = " org_id=? and id=? and status in (0, 1)";
  var params = [req.session.orgId, args.id];
  self.execute("select id,org_id,code,name,status,type_id," +
    "creater_id,createtime,description,last_modifier_id,last_modify_time " +
    "from vsys_role where " + where, params, function (rows) {
      if (rows.length <= 0) {
        cb(null, "请提供正确的角色编号！");
        return;
      }
      cb(rows[0]);
    });
};

/**
 * 获取系统角色
 * @param {*} req 
 * @param {*} args 
 * sys_flag 
 * @param {*} cb 
 * role(id,org_id,type_id,code,name,sys_flag) msg
 */
RoleBll.prototype.get_sys = function (req, args, cb) {
  var self = this;
  var where = " org_id=? and status=0";
  var params = [req.session.orgId];
  //sys_flag(0系统管理员 1所有人)
  if (args.sys_flag != null) {
    where += " and sys_flag=?";
    params.push(args.sys_flag);
  }
  self.roleDao.query({
    fields: "id,org_id,type_id,code,name,sys_flag",
    where: where,
    params: params,
    order: 'id ASC'
  }, function (rows) {
    if (rows.length <= 0) {
      cb(null, "该角色不存在！");
      return;
    }
    cb(rows[0]);
    return;
  });
};

/**
 * 获取角色代码
 * @param {*} req 
 * @param {*} args 
 * parent_id
 * @param {*} cb 
 * info msg
 */
RoleBll.prototype.getCode_role = function (req, args, cb) {
  var self = this;

  var info = {};
  self.execute("select count(*) as child_count from sys_role where org_id=? ", [req.session.orgId], function (rows) {
    info.code = (rows[0].child_count + 1) + "";
    for (var i = info.code.length; i < 2; i++) {
      info.code = "0" + info.code;
    }

    cb(info);
    return;
  });
};

/**
 * 验证删除角色用户
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 */
RoleBll.prototype.verify_delete_role_user = function (req, args, cb) {
  var self = this;

  if (!args.user_ids) {
    cb(null, '请提供职员编号！');
    return;
  }
  if (!args.role_id) {
    cb(null, '请提供角色编号！');
    return;
  }

  if (!utils.isInt(args.role_id)) {
    cb(null, '请提供正确的角色编号！');
    return;
  }
  var userIds = utils.strToIntArray(args.user_ids);
  if (userIds.length == 0) {
    cb(null, '请提供用户编号！');
    return;
  }

  cb(null);
  return;
};

/**
 * 查询角色用户
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 */
RoleBll.prototype.getList_role_user = function (req, args, cb) {
  var self = this;
  var params = [req.session.orgId, args.role_id];
  var key = '';
  if (args.user_ids.split(',').length > 0) {
    for (var i = 0; i < args.user_ids.split(',').length; i++) {
      var id = args.user_ids.split(',')[i];
      if (key) key += ',';
      key += '?';
      params.push(id);
    }
  }
  self.execute("select role_id,user_id from sys_role_user where org_id=? and role_id=? and status=0 and user_id in (" + key + ")", params, function (rows) {
    if (rows.length <= 0) {
      cb(null, "请提供正确的编号！");
      return;
    }
    cb(rows);
  });
};

/**
 * 删除角色用户
 * @param {*} req 
 * @param {*} args 
 * id
 * @param {*} cb 
 * obj(id) msg
 */
RoleBll.prototype.delete_role_user = function (req, args, cb) {
  var self = this;
  var params = [req.session.orgId, args.role_id];
  var key = '';
  if (args.user_ids.split(',').length > 0) {
    for (var i = 0; i < args.user_ids.split(',').length; i++) {
      var id = args.user_ids.split(',')[i];
      if (key) key += ',';
      key += '?';
      params.push(id);
    }
  }

  self.execute('delete from sys_role_user where org_id=? and role_id=? and user_id in (' + key + ')', params, function () {
    cb(null);
  });
};
