var util = require('util');
var Dao = require('Dao');
var PostDao = require('../dao/post');

var PostBll = function (service) {
  Dao.call(this, service, null, null);

  this.postDao = new PostDao(service);
};

util.inherits(PostBll, Dao);

module.exports = PostBll;

/**
 * 验证添加岗位
 * @param {*} req 
 * @param {*} args 
 * post(code name parent_id description)
 * @param {*} cb 
 * null msg
 */
PostBll.prototype.verify_insert_post = function (req, args, cb) {
  var self = this;
  if (!args.post.code) {
    cb(null, '请提供岗位代码！');
    return;
  }
  if (!args.post.name) {
    cb(null, '请提供岗位名称！');
    return;
  }
  //if (!args.post.parent_id) args.post.parent_id = 0;

  cb(null);
  return;

  // //验证岗位
  // self.execute("select count(*) as count from sys_post where org_id=? and parent_id=? and name=? and status=0", [req.session.orgId, args.parent_id, args.name], function (rows) {
  //   if (rows[0].count > 0) {
  //     cb('该岗位已经存在！');
  //     return;
  //   }
  //   cb(null);
  //   return;
  // });
};

/**
 * 添加岗位
 * @param {*} req 
 * @param {*} args 
 * post(code name parent_id description)
 * @param {*} cb 
 * obj(post)
 */
PostBll.prototype.insert_post = function (req, args, cb) {
  var self = this;
  var post = {};
  post.org_id = req.session.orgId;
  post.code = args.post.code;
  post.name = args.post.name;
  post.parent_id = args.post.parent_id;
  if (!post.parent_id) post.parent_id = 0;
  post.description = args.post.description;
  post.status = 0;
  post.creater_id = req.session.userId;
  post.createtime = new Date();
  post.last_modifier_id = req.session.userId;
  post.last_modify_time = new Date();

  //添加岗位
  self.postDao.create(post, function (ret) {
    post.id = ret.insertId;
    //获取路径
    self.postDao.execute('select fsys_post_getparentids(' + post.org_id + ',' + post.id + ') as parent_ids', null, function (rows) {
      post.parent_ids = rows[0].parent_ids;
      //修改路径
      self.postDao.update({ 'parent_ids': post.parent_ids }, {
        where: 'org_id=? and id=?',
        params: [post.org_id, post.id]
      }, function () {
        cb({ "post": post });
        return;
      });
    });

    // if (post.parent_id != 0) {
    //   //获取路径
    //   self.postDao.execute('select fsys_post_getcomid(' + post.org_id + ',' + post.id + ') as company_id, fsys_post_getparentids(' + post.org_id + ',' + post.id + ') as parent_ids', null, function (rows) {
    //     post.company_id = rows[0].company_id;
    //     post.parent_ids = rows[0].parent_ids;
    //     //修改路径
    //     self.postDao.update({ 'company_id': post.company_id, 'parent_ids': post.parent_ids }, {
    //       where: 'org_id=? and id=?',
    //       params: [post.org_id, post.id]
    //     }, function () {
    //       cb({ "post": post });
    //       return;
    //     });
    //   });
    // }
    // else {
    //   post.parent_ids = "," + post.id + ",";
    //   if (post.company_sign == 0) post.company_id = 0;
    //   else post.company_id = post.id;
    //   //修改路径
    //   self.postDao.update({ 'company_id': post.company_id, 'parent_ids': post.parent_ids }, {
    //     where: 'org_id=? and id=?',
    //     params: [post.org_id, post.id]
    //   }, function () {
    //     cb({ "post": post });
    //     return;
    //   });
    // }
  });
};

/**
 * 获取岗位
 * @param {*} req 
 * @param {*} args 
 * id
 * @param {*} cb 
 * post msg
 */
PostBll.prototype.get_post = function (req, args, cb) {
  var self = this;
  if (!args.id) {
    cb(null, '请提供岗位编号！');
    return;
  }

  var where = " org_id=? and id=? and status in (0)";
  var params = [req.session.orgId, args.id];
  self.execute("select id,org_id,code,name,parent_id from sys_post where " + where, params, function (rows) {
    if (rows.length <= 0) {
      cb(null, "请提供正确的岗位编号！");
      return;
    }
    cb(rows[0]);
    return;
  });
};

/**
 * 验证修改岗位
 * @param {*} req 
 * @param {*} args 
 * post(id code name parent_id description)
 * o_post(id code name parent_id)
 * @param {*} cb 
 * null msg
 */
PostBll.prototype.verify_update_post = function (req, args, cb) {
  var self = this;
  if (!args.post.id) {
    cb(null, '请提供岗位编号！');
    return;
  }
  if (!args.post.code) {
    cb(null, '请提供岗位代码！');
    return;
  }
  if (!args.post.name) {
    cb(null, '请提供岗位名称！');
    return;
  }

  //验证循环
  if (args.post.parent_id != null && args.post.parent_id != 0 && args.post.parent_id != args.o_post.parent_id) {
    self.postDao.execute("select count(*) as count from sys_post where org_id=? and id=? and parent_ids like ? and status=0", [req.session.orgId, args.post.parent_id, '%,' + args.post.id + ',%'], function (rs) {
      if (rs[0].count > 0) {
        cb(null, '上级岗位不能是本岗位的下级！');
        return;
      }
    });
  }

  cb(null);
  return;
};

/**
 * 修改岗位
 * @param {*} req 
 * @param {*} args 
 * post(id code name parent_id description)
 * o_post(id code name parent_id)
 * @param {*} cb 
 * obj(post)
 */
PostBll.prototype.update_post = function (req, args, cb) {
  var self = this;
  var post = {};
  post.org_id = req.session.orgId;
  post.code = args.post.code;
  post.name = args.post.name;
  post.parent_id = args.post.parent_id;
  if (!post.parent_id) post.parent_id = 0;
  post.description = args.post.description;
  post.last_modifier_id = req.session.userId;
  post.last_modify_time = new Date();

  //修改岗位
  self.postDao.update(post, {
    where: 'org_id=? and id=?',
    params: [req.session.orgId, args.post.id]
  }, function () {
    post.id = args.post.id;
    if (args.o_post.parent_id != post.parent_id) {
      //获取路径
      self.postDao.execute('select fsys_post_getparentids(' + post.org_id + ',' + post.id + ') as parent_ids', null, function (rows) {
        post.parent_ids = rows[0].parent_ids;
        //修改路径
        self.postDao.update({ 'parent_ids': post.parent_ids }, {
          where: 'org_id=? and id=?',
          params: [post.org_id, post.id]
        }, function () {
          //修改子岗位路径
          self.postDao.execute("update sys_post set parent_ids=fsys_post_getparentids(org_id,id) " +
            "where org_id=? and id<>? and parent_ids like connectvarchar3('%,',?,',%') and status=0",
            [post.org_id, post.id, post.id], function () {
              cb({ "post": post });
              return;
            });
        });
      });
    }
    else {
      cb({ "post": post });
      return;
    }
  });
};

/**
 * 删除岗位
 * @param {*} req 
 * @param {*} args 
 * id
 * @param {*} cb 
 * null msg
 */
PostBll.prototype.verify_delete_post = function (req, args, cb) {
  var self = this;
  if (!args.id) {
    cb(null, '请提供岗位编号！');
    return;
  }

  self.postDao.execute("select count(*) as count from sys_post where org_id=? and parent_id=? and status=0", [req.session.orgId, args.id], function (rows) {
    if (rows[0].count > 0) {
      cb(null, '岗位内还有子岗位，目前不能删除！');
      return;
    }
    self.postDao.execute("select count(*) as count from sys_dep_user where org_id=? and post_id=? and status=0", [req.session.orgId, args.id], function (rows) {
      if (rows[0].count > 0) {
        cb(null, '岗位内还有用户，目前不能删除！');
        return;
      }
      cb(null);
      return;
    });
  });
};

/**
 * 删除岗位
 * @param {*} req 
 * @param {*} args 
 * id
 * @param {*} cb 
 * obj(id)
 */
PostBll.prototype.delete_post = function (req, args, cb) {
  var self = this;

  //删除岗位
  self.postDao.update({ "deleter_id": req.session.userId, "delete_time": new Date(), "status": 1 }, {
    where: 'org_id=? and id=?',
    params: [req.session.orgId, args.id]
  }, function () {
    cb({ "id": args.id });
  });
};

/**
 * 岗位列表
 * @param {*} req 
 * @param {*} args 
 * parent_id keyword within_id without_id is_all
 * @param {*} cb 
 * list msg
 */
PostBll.prototype.list_post = function (req, args, cb) {
  var self = this;
  var where = " org_id=? and status in (0)";
  var params = [req.session.orgId];
  if (!args.keyword) {
    if (args.parent_id != null) {
      where += " and parent_id=?";
      params.push(args.parent_id);
    }
    else {
      if (args.is_all == null) where += " and parent_id=0";
    }
  }

  if (args.keyword != null) {
    where += " and (name like ? or code like ?)";
    params.push('%' + args.keyword + '%');
    params.push('%' + args.keyword + '%');
  }
  if (args.within_id != null) {
    where += " and parent_ids like ?";
    params.push('%,' + args.within_id + ',%');
  }
  if (args.without_id != null) {
    where += " and parent_ids not like ?";
    params.push('%,' + args.without_id + ',%');
  }

  self.execute("select id,org_id,code,name,parent_id,parent_name,status," +
    "creater_id,createtime,last_modifier_id,last_modify_time," +
    "(select count(*) from sys_post s where s.org_id=vsys_post.org_id and s.parent_id=vsys_post.id and s.status in (0)) as child_count " +
    "from vsys_post where " + where + " order by code ASC, id ASC", params, function (rows) {
      cb(rows);
    });
};

/**
 * 获取岗位
 * @param {*} req 
 * @param {*} args 
 * id
 * @param {*} cb 
 * post
 */
PostBll.prototype.getv_post = function (req, args, cb) {
  var self = this;
  if (!args.id) {
    cb(null, '请提供岗位编号！');
    return;
  }

  var where = " org_id=? and id=? and status in (0)";
  var params = [req.session.orgId, args.id];
  self.execute("select id,org_id,code,name,parent_id,parent_name,status," +
    "creater_id,createtime,last_modifier_id,last_modify_time " +
    "from vsys_post where " + where, params, function (rows) {
      if (rows.length <= 0) {
        cb(null, "请提供正确的岗位编号！");
        return;
      }
      cb(rows[0]);
      return;
    });
};

/**
 * 获取岗位代码
 * @param {*} req 
 * @param {*} args 
 * parent_id
 * @param {*} cb 
 * info msg
 */
PostBll.prototype.getCode_post = function (req, args, cb) {
  var self = this;
  if (args.parent_id == null) {
    cb(null, '请提供上级岗位编号！');
    return;
  }

  var info = {};
  self.execute("select count(*) as child_count from sys_post where org_id=? and parent_id=?", [req.session.orgId, args.parent_id], function (rows) {
    if (rows.length <= 0) {
      cb(null, '请提供正确的上级岗位编号！');
      return;
    }

    info.code = (rows[0].child_count + 1) + "";
    for (var i = info.code.length; i < 2; i++) {
      info.code = "0" + info.code;
    }

    cb(info);
    return;
  });
};

/**
 * 删除岗位职员
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 */
PostBll.prototype.delete_post_user = function (req, args, cb) {
  var self = this;
  self.execute("update sys_dep_user set post_id=0 where org_id=? and post_id=?", [req.session.orgId, args.id], function () {
    cb(null);
    return;
  });
};

/**
 * 获取职员岗位对应列表
 * @param {*} req 
 * id 岗位编号
 * @param {*} args 
 * @param {*} cb 
 */
PostBll.prototype.list_post_user = function (req, args, cb) {
  var self = this;
  self.execute("select id,org_id,order_number,user_id,dep_id,post_id,level_id from sys_dep_user where org_id=? and post_id=?", [req.session.orgId, args.id], function (rows) {
    cb(rows);
    return;
  });
};
