var util = require('util');
var Dao = require('Dao');
var OrgDao = require('../dao/org');
var OrgLogDao = require('../dao/org_log');
var OrgSettingDao = require('../dao/sys_setting');

var OrgBll = function (service) {
  Dao.call(this, service, null, null);

  this.orgDao = new OrgDao(service);
  this.orgLogDao = new OrgLogDao(service);
  this.orgSettingDao = new OrgSettingDao(service);
};

util.inherits(OrgBll, Dao);

module.exports = OrgBll;

/**
 * 写组织机构日志
 * @param {*} req 
 * @param {*} args 
 * operate_type operate_content
 * @param {*} cb 
 * null msg
 */
OrgBll.prototype.write_log = function (req, args, cb) {
  var self = this;
  //最后修改日期
  self.orgDao.setLastUpdate(req.session.orgId, function () {
    var orglog = {};
    orglog.org_id = req.session.orgId;
    orglog.user_id = req.session.userId;
    orglog.operate_type = args.operate_type;
    orglog.operate_time = new Date();
    orglog.operate_content = args.operate_content;
    //写入组织机构日志
    self.orgLogDao.create(orglog, function (ret, err) {
      cb(null, err);
      return;
    });
  });
};

/**
 * 获取
 * @param {*} req 
 * @param {*} cb 
 * org msg
 */
OrgBll.prototype.get = function (req, args, cb) {
  var self = this;
  var where = "id=? and status=0";
  var params = [req.session.orgId];
  self.orgDao.query({
    fields: "id,code,name,default_pwd",
    where: where,
    params: params,
    order: 'id ASC'
  }, function (rows) {
    if (rows.length <= 0) {
      cb(null, "该组织不存在！");
      return;
    }
    cb(rows[0]);
    return;
  });
};

/**
 * 获取系统设置
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 * org_setting(org_id,json,web_json,mobile_json,pc_json,safe_json,msg_json,address_json) msg
 */
OrgBll.prototype.get_setting = function (req, args, cb) {
  var self = this;
  var where = " org_id=? ";
  var params = [req.session.orgId];
  self.orgSettingDao.query({
    fields: "org_id,json,web_json,mobile_json,pc_json,safe_json,msg_json,address_json",
    where: where,
    params: params,
    order: 'id ASC'
  }, function (rows) {
    var org_setting = {};
    if (rows.length > 0) {
      org_setting = rows[0];
    }
    if (org_setting.json == null) org_setting.json = '{"theme_key":"c","theme_color":"#4e89f8","nav_theme":"main","left_theme":"black","display_app":"1","nav_setting":"0"}';
    if (org_setting.web_json == null) org_setting.web_json = '{}';
    if (org_setting.mobile_json == null) org_setting.mobile_json = '{}';
    if (org_setting.pc_json == null) org_setting.pc_json = '{}';
    if (org_setting.safe_json == null) org_setting.safe_json = '{"safe_level":"3"}';
    if (org_setting.msg_json == null) org_setting.msg_json = '{}';
    if (org_setting.address_json == null) org_setting.address_json = '{}';

    cb(org_setting);
    return;
  });
};