var util = require('util');
var Dao = require('Dao');
var AppDao = require('../dao/org_app');
var MsgDao = require('../dao/sys_msg');
var ReceiveDao = require('../dao/sys_msg_receive');
var SettingDao = require('../dao/sys_setting');
var WsDao = require('../dao/sys_msg_ws');


/**
 * 发送消息统一方法
 * @param {*} service 
 */
var MsgBll = function (service) {
    Dao.call(this, service, null, null);
    this.appDao = new AppDao(service);
    this.msgDao = new MsgDao(service);
    this.receiveDao = new ReceiveDao(service);
    this.settingDao = new SettingDao(service);
    this.WsDao = new WsDao(this);
    this.msg_setting = null;
};

util.inherits(MsgBll, Dao);

module.exports = MsgBll;

/**
 * 发送消息
 * @param {*} req 
 * @param {*} args 
 * sendType     发送类型，字符串，可不传，默认为all（给所有类型都发）【all,mobile,websocket,sms,mail,wechat】
 * type         消息类型，字符串
 * title        消息提醒标题，字符串
 * summary      消息提醒摘要，字符串
 * toSelf       是否给自己其他客户端发送，布尔型，可不传，默认为false
 * receivers    接收人编号数组，数组
 * data         收到消息后用于拼接打开详细页url参数，对象
 * saveData     是否生成表数据，布尔型，默认为true
 * nosavedb     websocket是否存表 默认true为不存表默认false
 * appDataId    当前信息的编号
 * sendtime     发送时间
 * mold         打开详情页面方式,默认为page【page 跳页, popup 弹窗】
 * @param {*} cb 
 */
MsgBll.prototype.sendMsg = function (req, args, cb) {
    var self = this;
    if (!args.type) {
        this.onLogicError(1, '请提供消息类型！');
        return;
    }
	args.mold = args.mold || "page";

    // 获取设置信息判断有哪些客户端可以发送
    self.settingDao.query({ fields: 'msg_json', where: 'org_id=?', params: [req.session.orgId] }, function (rows) {
        if (rows.length === 0 || !rows[0].msg_json || rows[0].msg_json == '{}') {
            if (cb) {
                cb();
                return;
            }
            self.end(res);
            return;
        }

        self.msg_setting = JSON.parse(rows[0].msg_json);

        if (args.title == '待办工作') {
            args.title = '工作消息';
        }

        if (!args.sendType) args.sendType = 'all';
        if (!args.toSelf) args.toSelf = false;

        var params = [req.session.orgId];
        if (args.type == 'app_read') {
            params.push(args.appType.replace('app_', ''));
        } else if (args.type.indexOf('recall_') != -1) {
            params.push(args.type.replace('recall_', ''));
        } else {
            params.push(args.type.replace('app_', ''));
        }

        // 过滤接收人，去除重复
        var list = [];
        if (args.receivers && args.receivers.length > 0) {
            for (var i = 0; i < args.receivers.length; i++) {
                if (list.indexOf(args.receivers[i]) == -1 && args.receivers[i] && args.receivers[i] != 'null' && args.receivers[i] != 'undefined') {
                    list.push(args.receivers[i]);
                }
            }
        }
        args.receivers = list;

        // 找到对应应用的相关信息
        self.appDao.query({
            fields: 'sys_org_app.code,sys_org_app.id',
            where: "sys_org_app.org_id=? and k.key_code=? and ifisnull(key_status, '')=''",
            join: 'sys_app_key as k on k.app_code=sys_org_app.code',
            params: params
        }, function (rows) {
            if (rows.length > 0) {
                req.appCode = rows[0].code;
                req.appId = rows[0].id;
            }

            // 如果是已读消息，查找上一条的消息编号
            if (args.type.indexOf('recall') != -1 && args.appDataId && args.type) {
                self.msgDao.query({
                    fields: 'id',
                    where: "org_id=? and app_data_id=? and type=?",
                    params: [req.session.orgId, args.appDataId, args.type.replace('recall_', 'app_')]
                }, function (rows) {
                    if (rows.length > 0) {
                        args.oldMsgId = rows[0].id;
                    }
                    // 发送移动端与pc端
                    self.sendMobileMsg(req, args, cb);
                });
            } else {
                // 发送移动端与pc端
                self.sendMobileMsg(req, args, cb);
            }
        })
    });
};

/**
 * 移动端和pc端消息推送
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 * @returns 
 */
MsgBll.prototype.sendMobileMsg = function (req, args, cb) {
    var self = this;
    if ((args.sendType.indexOf('mobile') == -1 && args.sendType.indexOf('all') == -1) || !self.msg_setting.mobile) {
        self.sendWebsocketMsg(req, args, cb);
        return;
    }
    var self = this;
    if (server && server.mpClient) {
        // 启动了消息服务器
        var msg = {
            type: args.type,
            title: args.title,
            summary: args.summary,
            toSelf: args.toSelf,
            receivers: args.receivers,
            data: args.data
        };
        if (req.appCode) {
            msg.appCode = req.appCode;
        }
        if (args.appDataId) {
            msg.appDataId = args.appDataId;
        }
        if (args.appType) {
            msg.appType = args.appType;
        }
        if (req.appId) {
            msg.appId = req.appId;
        }
        if (args.oldMsgId) {
            msg.oldMsgId = args.oldMsgId;
        }
        if (args.nosavedb) {
            msg.nosavedb = true;
        }
        if(args.sendtime){
            msg.sendtime = args.sendtime;
        }
		if(args.mold){
		    msg.mold = args.mold;
		}
        server.messageManager.sendMsg(req, msg, function (code, ret) {
            if (code != 0) {
                cb(ret);
                return;
            }
            self.sendWebsocketMsg(req, args, cb);
        });
    } else {
        self.sendWebsocketMsg(req, args, cb);
    }
};

/**
 * websocket消息推送
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 * @returns 
 */
MsgBll.prototype.sendWebsocketMsg = function (req, args, cb) {
    var self = this;
    if ((args.sendType.indexOf('websocket') == -1 && args.sendType.indexOf('all') == -1) || !self.msg_setting.websocket) {
        self.sendMailMsg(req, args, cb);
        return;
    }
    var self = this;
    if (server && server.webSocketServer) {
        // 启动了websocket服务器
        var msg = {
            type: args.type,
            title: args.title,
            summary: args.summary,
            toSelf: args.toSelf,
            receivers: args.receivers,
            receiverCType: 'web',
            data: args.data
        };
        if (req.appCode) {
            msg.appCode = req.appCode;
        }
        if (args.appDataId) {
            msg.appDataId = args.appDataId;
        }
        if (args.appType) {
            msg.appType = args.appType;
        }
        if (req.appId) {
            msg.appId = req.appId;
        }
        if (args.data_id) {
            msg.data_id = args.data_id;
        }
        if (args.oldMsgId) {
            msg.oldMsgId = args.oldMsgId;
        }
        if (!args.nosavedb) {
            msg.nosavedb = false;
        } else {
            msg.nosavedb = true;
        }
        if(args.sendtime){
            msg.sendtime = args.sendtime;
        }
		if(args.mold){
		    msg.mold = args.mold;
		}
        server.messageManager.sendWebMsg(req, msg, function (code, ret) {
            if (code != 0) {
                if (cb) {
                    cb();
                } else {
                    self.end(res);
                }
                return;
            }
            // 验证是不是发的已读消息，如果是已读消息验证是否已修改表，如果未修改则直接修改，如果已修改则直接忽略
            self.sendMailMsg(req, args, cb);
        });
    } else {
        self.sendMailMsg(req, args, cb);
    }
};

/**
 * 邮件消息推送
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 * @returns 
 */
MsgBll.prototype.sendMailMsg = function (req, args, cb) {
    var self = this;
    if ((args.sendType.indexOf('mail') == -1 && args.sendType.indexOf('all') == -1) || !self.msg_setting.mail) {
        self.sendSmsMsg(req, args, cb);
        return;
    }

    self.sendSmsMsg(req, args, cb);
};

/**
 * 短信消息推送
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 * @returns 
 */
MsgBll.prototype.sendSmsMsg = function (req, args, cb) {
    var self = this;
    if ((args.sendType.indexOf('sms') == -1 && args.sendType.indexOf('all') == -1) || !self.msg_setting.sms) {
        self.sendWechatMsg(req, args, cb);
        return;
    }

    self.sendWechatMsg(req, args, cb);
};

/**
 * 微信消息推送
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 * @returns 
 */
MsgBll.prototype.sendWechatMsg = function (req, args, cb) {
    var self = this;
    if ((args.sendType.indexOf('wechat') == -1 && args.sendType.indexOf('all') == -1) || !self.msg_setting.wechat) {
        cb();
        return;
    }

    cb();
};

/**
 * 已读消息
 * @param {*} req 
 * @param {*} args 
 * type         消息类型
 * sendType     发送类型，字符串，可不传，默认为all（给所有类型都发）【all,mobile,websocket,sms,mail,wechat】
 * appDataId    信息编号
 * @param {*} cb 
 */
MsgBll.prototype.sendReadMsg = function (req, args, cb) {
    var self = this;
    // 查找消息判断是否为已读，如果是已读不在给websocket发送消息，手机正常发送
    // appDataId,appCode,appType

    var msg = {
        type: 'app_read',
        title: '已读消息',
        summary: '',
        receivers: [req.session.userId],
        appDataId: args.appDataId,
        appType: args.type,
        toSelf: true,
        sendType: 'mobile,websocket',
        nosavedb: true
    };

    self.sendMsg(req, msg, cb);
};

/**
 * websocket消息推送
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 * @returns 
 */
MsgBll.prototype.sendWebsocketImport = function (req, args, cb) {
    var self = this;
    if (server && server.webSocketServer) {
        // 启动了websocket服务器
        var msg = {
            // nosavedb: true,
            percentage: args.percentage,
            receivers: [req.session.userId]
        };
        server.messageManager.sendWebMsg(req, msg, function (code, ret) {
            if (code != 0) {
                if (cb) cb();// 报错也不考虑，直接执行下一个
                return;
            }
            if (cb) cb();
        });
    } else {
        if (cb) cb();
    }
};
