var util = require('util');
var Dao = require('Dao');
var LevelDao = require('../dao/level');

var LevelBll = function (service) {
  Dao.call(this, service, null, null);

  this.levelDao = new LevelDao(service);
};

util.inherits(LevelBll, Dao);

module.exports = LevelBll;

/**
 * 验证添加级别
 * @param {*} req 
 * @param {*} args 
 * level(code name description)
 * @param {*} cb 
 * null msg
 */
LevelBll.prototype.verify_insert_level = function (req, args, cb) {
  var self = this;
  if (!args.level.code) {
    cb(null, '请提供级别代码！');
    return;
  }
  if (!args.level.name) {
    cb(null, '请提供级别名称！');
    return;
  }

  cb(null);
  return;
};

/**
 * 添加级别
 * @param {*} req 
 * @param {*} args 
 * level(code name description)
 * @param {*} cb 
 * obj(level)
 */
LevelBll.prototype.insert_level = function (req, args, cb) {
  var self = this;
  var level = {};
  level.org_id = req.session.orgId;
  level.code = args.level.code;
  level.name = args.level.name;
  level.description = args.level.description;
  level.status = 0;
  level.creater_id = req.session.userId;
  level.createtime = new Date();
  level.last_modifier_id = req.session.userId;
  level.last_modify_time = new Date();

  //添加级别
  self.levelDao.create(level, function (ret) {
    level.id = ret.insertId;

    cb({ "level": level });
    return;
  });
};

/**
 * 获取级别
 * @param {*} req 
 * @param {*} args 
 * id
 * @param {*} cb 
 * level msg
 */
LevelBll.prototype.get_level = function (req, args, cb) {
  var self = this;
  if (!args.id) {
    cb(null, '请提供级别编号！');
    return;
  }

  var where = " org_id=? and id=? and status in (0)";
  var params = [req.session.orgId, args.id];
  self.execute("select id,org_id,code,name from sys_level where " + where, params, function (rows) {
    if (rows.length <= 0) {
      cb(null, "请提供正确的级别编号！");
      return;
    }
    cb(rows[0]);
    return;
  });
};

/**
 * 验证修改级别
 * @param {*} req 
 * @param {*} args 
 * level(id code name description)
 * o_level(id code name)
 * @param {*} cb 
 * null msg
 */
LevelBll.prototype.verify_update_level = function (req, args, cb) {
  var self = this;
  if (!args.level.id) {
    cb(null, '请提供级别编号！');
    return;
  }
  if (!args.level.code) {
    cb(null, '请提供级别代码！');
    return;
  }
  if (!args.level.name) {
    cb(null, '请提供级别名称！');
    return;
  }

  cb(null);
  return;
};

/**
 * 修改级别
 * @param {*} req 
 * @param {*} args 
 * level(id code name description)
 * o_level(id code name)
 * @param {*} cb 
 * obj(level)
 */
LevelBll.prototype.update_level = function (req, args, cb) {
  var self = this;
  var level = {};
  level.org_id = req.session.orgId;
  level.code = args.level.code;
  level.name = args.level.name;
  level.description = args.level.description;
  level.last_modifier_id = req.session.userId;
  level.last_modify_time = new Date();

  //修改级别
  self.levelDao.update(level, {
    where: 'org_id=? and id=?',
    params: [req.session.orgId, args.level.id]
  }, function () {
    level.id = args.level.id;
    cb({ "level": level });
    return;
  });
};

/**
 * 删除级别
 * @param {*} req 
 * @param {*} args 
 * id
 * @param {*} cb 
 * null msg
 */
LevelBll.prototype.verify_delete_level = function (req, args, cb) {
  var self = this;
  if (!args.id) {
    cb('请提供级别编号！');
    return;
  }

  self.levelDao.execute("select count(*) as count from sys_dep_user where org_id=? and level_id=? and status=0", [req.session.orgId, args.id], function (rows) {
    if (rows[0].count > 0) {
      cb(null, '级别内还有用户，目前不能删除！');
      return;
    }
    cb(null);
  });
};

/**
 * 删除级别
 * @param {*} req 
 * @param {*} args 
 * id
 * @param {*} cb 
 * obj(id)
 */
LevelBll.prototype.delete_level = function (req, args, cb) {
  var self = this;

  //删除级别
  self.levelDao.update({ "deleter_id": req.session.userId, "delete_time": new Date(), "status": 1 }, {
    where: 'org_id=? and id=?',
    params: [req.session.orgId, args.id]
  }, function () {
    cb({ "id": args.id });
  });
};

/**
 * 级别列表
 * @param {*} req 
 * @param {*} args 
 * keyword
 * @param {*} cb 
 * list
 */
LevelBll.prototype.list_level = function (req, args, cb) {
  var self = this;
  var where = " org_id=? and status in (0)";
  var params = [req.session.orgId];
    
  if (args.keyword != null) {
    where += " and (name like ? or code like ?)";
    params.push('%' + args.keyword + '%');
    params.push('%' + args.keyword + '%');
  }

  self.execute("select id,org_id,code,name,status," +
    "creater_id,createtime,last_modifier_id,last_modify_time " +
    "from sys_level where " + where + " order by code ASC, id ASC", params, function (rows) {
      cb(rows);
    });
};

/**
 * 获取级别
 * @param {*} req 
 * @param {*} args 
 * id
 * @param {*} cb 
 * level
 */
LevelBll.prototype.getv_level = function (req, args, cb) {
  var self = this;
  if (!args.id) {
    cb(null, '请提供级别编号！');
    return;
  }

  var where = " org_id=? and id=? and status in (0)";
  var params = [req.session.orgId, args.id];
  self.execute("select id,org_id,code,name,status," +
    "creater_id,createtime,last_modifier_id,last_modify_time " +
    "from sys_level where " + where, params, function (rows) {
      if (rows.length <= 0) {
        cb(null, "请提供正确的级别编号！");
        return;
      }
      cb(rows[0]);
    });
};

/**
 * 获取级别代码
 * @param {*} req 
 * @param {*} args 
 * parent_id
 * @param {*} cb 
 * info msg
 */
LevelBll.prototype.getCode_level = function (req, args, cb) {
  var self = this;

  var info = {};
  self.execute("select count(*) as child_count from sys_level where org_id=? ", [req.session.orgId], function (rows) {
    info.code = (rows[0].child_count + 1) + "";
    for (var i = info.code.length; i < 2; i++) {
      info.code = "0" + info.code;
    } 

    cb(info);
    return;
  });
};