var util = require('util');
var Dao = require('Dao');
var LayerDao = require('../dao/layer');

var LayerBll = function (service) {
  Dao.call(this, service, null, null);

  this.layerDao = new LayerDao(service);
};

util.inherits(LayerBll, Dao);

module.exports = LayerBll;

/**
 * 验证添加层级
 * @param {*} req 
 * @param {*} args 
 * layer(code name description)
 * @param {*} cb 
 * null msg
 */
LayerBll.prototype.verify_insert_layer = function (req, args, cb) {
  var self = this;
  if (!args.layer.code) {
    cb(null, '请提供层级代码！');
    return;
  }
  if (!args.layer.name) {
    cb(null, '请提供层级名称！');
    return;
  }

  cb(null);
  return;
};

/**
 * 添加层级
 * @param {*} req 
 * @param {*} args 
 * layer(code name description)
 * @param {*} cb 
 * obj(layer)
 */
LayerBll.prototype.insert_layer = function (req, args, cb) {
  var self = this;
  var layer = {};
  layer.org_id = req.session.orgId;
  layer.code = args.layer.code;
  layer.name = args.layer.name;
  layer.description = args.layer.description;
  layer.status = 0;
  layer.creater_id = req.session.userId;
  layer.createtime = new Date();
  layer.last_modifier_id = req.session.userId;
  layer.last_modify_time = new Date();

  //添加层级
  self.layerDao.create(layer, function (ret) {
    layer.id = ret.insertId;

    cb({ "layer": layer });
    return;
  });
};

/**
 * 获取层级
 * @param {*} req 
 * @param {*} args 
 * id
 * @param {*} cb 
 * layer msg
 */
LayerBll.prototype.get_layer = function (req, args, cb) {
  var self = this;
  if (!args.id) {
    cb(null, '请提供层级编号！');
    return;
  }

  var where = " org_id=? and id=? and status in (0)";
  var params = [req.session.orgId, args.id];
  self.execute("select id,org_id,code,name from sys_layer where " + where, params, function (rows) {
    if (rows.length <= 0) {
      cb(null, "请提供正确的层级编号！");
      return;
    }
    cb(rows[0]);
    return;
  });
};

/**
 * 验证修改层级
 * @param {*} req 
 * @param {*} args 
 * layer(id code name description)
 * o_layer(id code name)
 * @param {*} cb 
 * null msg
 */
LayerBll.prototype.verify_update_layer = function (req, args, cb) {
  var self = this;
  if (!args.layer.id) {
    cb(null, '请提供层级编号！');
    return;
  }
  if (!args.layer.code) {
    cb(null, '请提供层级代码！');
    return;
  }
  if (!args.layer.name) {
    cb(null, '请提供层级名称！');
    return;
  }

  cb(null);
  return;
};

/**
 * 修改层级
 * @param {*} req 
 * @param {*} args 
 * layer(id code name description)
 * o_layer(id code name)
 * @param {*} cb 
 * obj(layer)
 */
LayerBll.prototype.update_layer = function (req, args, cb) {
  var self = this;
  var layer = {};
  layer.org_id = req.session.orgId;
  layer.code = args.layer.code;
  layer.name = args.layer.name;
  layer.description = args.layer.description;
  layer.last_modifier_id = req.session.userId;
  layer.last_modify_time = new Date();

  //修改层级
  self.layerDao.update(layer, {
    where: 'org_id=? and id=?',
    params: [req.session.orgId, args.layer.id]
  }, function () {
    layer.id = args.layer.id;
    cb({ "layer": layer });
    return;
  });
};

/**
 * 删除层级
 * @param {*} req 
 * @param {*} args 
 * id
 * @param {*} cb 
 * null msg
 */
LayerBll.prototype.verify_delete_layer = function (req, args, cb) {
  var self = this;
  if (!args.id) {
    cb('请提供层级编号！');
    return;
  }

  self.layerDao.execute("select count(*) as count from sys_user_subdep where org_id=? and layer_id=? and status=0", [req.session.orgId, args.id], function (rows) {
    if (rows[0].count > 0) {
      cb(null, '层级内还有用户，目前不能删除！');
      return;
    }
    cb(null);
  });
};

/**
 * 删除层级
 * @param {*} req 
 * @param {*} args 
 * id
 * @param {*} cb 
 * obj(id)
 */
LayerBll.prototype.delete_layer = function (req, args, cb) {
  var self = this;

  //删除层级
  self.layerDao.update({ "deleter_id": req.session.userId, "delete_time": new Date(), "status": 1 }, {
    where: 'org_id=? and id=?',
    params: [req.session.orgId, args.id]
  }, function () {
    cb({ "id": args.id });
  });
};

/**
 * 层级列表
 * @param {*} req 
 * @param {*} args 
 * keyword
 * @param {*} cb 
 * list
 */
LayerBll.prototype.list_layer = function (req, args, cb) {
  var self = this;
  var where = " org_id=? and status in (0)";
  var params = [req.session.orgId];
    
  if (args.keyword != null) {
    where += " and (name like ? or code like ?)";
    params.push('%' + args.keyword + '%');
    params.push('%' + args.keyword + '%');
  }

  self.execute("select id,org_id,code,name,status," +
    "creater_id,createtime,last_modifier_id,last_modify_time " +
    "from sys_layer where " + where + " order by code ASC, id ASC", params, function (rows) {
      cb(rows);
    });
};

/**
 * 获取层级
 * @param {*} req 
 * @param {*} args 
 * id
 * @param {*} cb 
 * layer
 */
LayerBll.prototype.getv_layer = function (req, args, cb) {
  var self = this;
  if (!args.id) {
    cb(null, '请提供层级编号！');
    return;
  }

  var where = " org_id=? and id=? and status in (0)";
  var params = [req.session.orgId, args.id];
  self.execute("select id,org_id,code,name,status," +
    "creater_id,createtime,last_modifier_id,last_modify_time " +
    "from sys_layer where " + where, params, function (rows) {
      if (rows.length <= 0) {
        cb(null, "请提供正确的层级编号！");
        return;
      }
      cb(rows[0]);
    });
};

/**
 * 获取层级代码
 * @param {*} req 
 * @param {*} args 
 * parent_id
 * @param {*} cb 
 * info msg
 */
LayerBll.prototype.getCode_layer = function (req, args, cb) {
  var self = this;

  var info = {};
  self.execute("select count(*) as child_count from sys_layer where org_id=? ", [req.session.orgId], function (rows) {
    info.code = (rows[0].child_count + 1) + "";
    for (var i = info.code.length; i < 2; i++) {
      info.code = "0" + info.code;
    } 

    cb(info);
    return;
  });
};