/****************************************************
* 编码规则逻辑
*
* @author smz
* @version (2021-09)
***************************************************/
var util = require('util');
var utils = require('utils');
var Dao = require('Dao');
var ERDao = require('../dao/sys_encodingrule');
var ERItemDao = require('../dao/sys_encodingrule_item');

var ERBll = function (service) {
  Dao.call(this, service, null, null);

  // this.erDao = new ERDao(service);
  // this.erItemDao = new ERItemDao(service);
};

util.inherits(ERBll, Dao);

module.exports = ERBll;

/**
 * 获取编码规则（使用）
 * @param {*} req 
 * @param {*} args 
 * pk_type pk_code fk_type fk_code update_mode
 * @param {*} cb 
 * en
 */
ERBll.prototype.get = function (req, args, cb) {
  var self = this;

  if (args.pk_type == null) args.pk_type = "";
  if (args.pk_code == null) args.pk_code = "";
  if (args.date == null) args.date = new Date().format("yyyy-MM-dd");
  if (args.fk_type == null) args.fk_type = "";
  if (args.fk_code == null) args.fk_code = "";
  if (args.update_mode == null) args.update_mode = "R";

  //p_org_id p_pk_type p_pk_code p_date p_user_id p_fk_type p_fk_code p_update_mode
  self.execute("select fsys_encodingrule_get('" + req.session.orgId + "'," +
    "'" + args.pk_type + "','" + args.pk_code + "','" + args.date + "'," +
    req.session.userId + ",'" + args.fk_type + "','" + args.fk_code + "'," +
    "'" + args.update_mode + "') as en", null, function (data) {
      cb(data[0].en);
    });
};

/**
 * 列表编码规则
 * @param {*} req 
 * @param {*} args 
 * keyword
 * @param {*} cb 
 * dataPage
 */
ERBll.prototype.list_er = function (req, args, cb) {
  var self = this;
  if (self.erDao == null) self.erDao = new ERDao(self.service);

  var where = " org_id=? ";
  var params = [req.session.orgId];
  if (args.keyword) {
    where += " and (pk_type like ? or pk_code like ?)";
    params.push("%" + args.keyword + "%");
    params.push("%" + args.keyword + "%");
  }
  self.erDao.queryDataPage(req, {
    fields: 'id,org_id,pk_type,pk_code,clear_mode,update_mode,sn_type',
    where: where,
    params: params
  }, cb);
};

/**
 * 删除编码规则
 * @param {*} req 
 * @param {*} args 
 * id
 * @param {*} cb 
 * obj{id}
 */
ERBll.prototype.delete_er = function (req, args, cb) {
  var self = this;
  if (self.erDao == null) self.erDao = new self.ERDao(self.service);

  self.execute("delete from sys_encodingrule where org_id=? and id=?",
    [req.session.orgId, args.id], function () {
      cb({ "id": args.id });
    });
};

/**
 * 获取编码规则
 * @param {*} req 
 * @param {*} args 
 * pk_type pk_code
 * @param {*} cb 
 * er{id org_id pk_type pk_code clear_mode update_mode sn_type}
 */
ERBll.prototype.get_er = function (req, args, cb) {
  var self = this;

  var where = " org_id=? and pk_type=? and pk_code=?";
  var params = [req.session.orgId, args.pk_type, args.pk_code];
  self.execute("select id,org_id,pk_type,pk_code,clear_mode,update_mode,sn_type from sys_encodingrule where " + where, params, function (rows) {
    if (rows.length <= 0) {
      cb(null, "请提供正确的编码规则！");
      return;
    }
    cb(rows[0]);
    return;
  });
};

/**
 * 验证编码规则
 * @param {*} req 
 * @param {*} args 
 * pk_type pk_code
 * @param {*} cb 
 * @returns 
 */
ERBll.prototype.verify_er = function (req, args, cb) {
  var self = this;
  if (!args.pk_type) {
    cb(null, '请提供名称！');
    return;
  }
  if (!args.pk_code) {
    cb(null, '请提供名称！');
    return;
  }

  cb(null);
  return;
};

/**
 * 修改编码规则
 * @param {*} req 
 * @param {*} args 
 * er{id pk_type pk_code clear_mode update_mode sn_type}
 * @param {*} cb 
 * er{id pk_type pk_code clear_mode update_mode sn_type}
 */
ERBll.prototype.update_er = function (req, args, cb) {
  var self = this;
  if (self.erDao == null) self.erDao = new ERDao(self.service);

  var obj = {};
  obj.org_id = req.session.orgId;
  obj.pk_type = args.er.pk_type;
  obj.pk_code = args.er.pk_code;
  obj.clear_mode = args.er.clear_mode;
  obj.update_mode = args.er.update_mode;
  obj.sn_type = args.er.sn_type;
  if (!obj.clear_mode) obj.clear_mode = "N";
  if (!obj.update_mode) obj.update_mode = "R";
  if (!obj.sn_type) obj.sn_type = "O";
  self.erDao.update(obj, {
    where: 'org_id=? and id=?',
    params: [req.session.orgId, args.er.id]
  }, function () {
    obj.id = args.er.id;
    cb({ "er": obj });
  });
};

/**
 * 添加编码规则
 * @param {*} req 
 * @param {*} args 
 * er{pk_type pk_code clear_mode update_mode sn_type}
 * @param {*} cb 
 * er{id pk_type pk_code clear_mode update_mode sn_type}
 */
ERBll.prototype.insert_er = function (req, args, cb) {
  var self = this;
  if (self.erDao == null) self.erDao = new ERDao(self.service);

  var obj = {};
  obj.org_id = req.session.orgId;
  obj.pk_type = args.er.pk_type;
  obj.pk_code = args.er.pk_code;
  obj.clear_mode = args.er.clear_mode;
  obj.update_mode = args.er.update_mode;
  obj.sn_type = args.er.sn_type;
  if (!obj.clear_mode) obj.clear_mode = "N";
  if (!obj.update_mode) obj.update_mode = "R";
  if (!obj.sn_type) obj.sn_type = "O";
  self.erDao.create(obj, function (ret) {
    obj.id = ret.insertId;
    cb({ "er": obj });
  });
};

/**
 * 删除编码规则明细
 * @param {*} req 
 * @param {*} args 
 * er{id}
 * @param {*} cb 
 */
ERBll.prototype.delete_er_item = function (req, args, cb) {
  var self = this;

  self.execute("delete from sys_encodingrule_item where org_id=? and encodingrule_id=?",
    [req.session.orgId, args.er.id], function () {
      cb();
    });
};

/**
 * 添加编码规则明细
 * @param {*} req 
 * @param {*} args 
 * er{id} items
 * @param {*} cb 
 */
ERBll.prototype.insert_er_item = function (req, args, cb) {
  if (!args.items) {
    cb();
    return;
  }
  var self = this;
  if (self.erItemDao == null) self.erItemDao = new ERItemDao(self.service);

  self.items = args.items;
  self.index_items = 0;
  self.set_er_item(req, { "er": args.er }, function () {
    cb();
  });
};

/**
 * 设置编码规则明细（内）
 * @param {*} req 
 * @param {*} args 
 * er{id}
 * self.items self.index_items
 * @param {*} cb 
 * @returns 
 */
ERBll.prototype.set_er_item = function (req, args, cb) {
  var self = this;
  if (self.items.length == self.index_items) {
    cb();
    return;
  }
  else {
    var itemObject = self.items[self.index_items];
    var obj = {};
    obj.org_id = req.session.orgId;
    obj.encodingrule_id = args.er.id;
    obj.order_number = self.index_items + 1;
    obj.encoding_type = itemObject.encoding_type;
    if (itemObject.encoding_type == "NO") obj.encoding_content = itemObject.encoding_content;
    else if (itemObject.encoding_type == "SN") obj.encoding_count = itemObject.encoding_count;
    self.erItemDao.create(obj, function (ret) {
      self.index_items++;
      self.set_er_item(req, args, cb);
    });
  }
};

/**
 * 获取编码规则明细
 * @param {*} req 
 * @param {*} args 
 * er{id}
 * @param {*} cb 
 * items[]
 */
ERBll.prototype.get_er_item = function (req, args, cb) {
  var self = this;

  var where = " org_id=? and encodingrule_id=?";
  var params = [req.session.orgId, args.er.id];
  self.execute("select id,org_id,encodingrule_id,order_number,encoding_type,encoding_count,encoding_content from sys_encodingrule_item " +
    "where " + where + " order by order_number ", params, cb);
};
