var util = require('util');
var Dao = require('Dao');
var DepDao = require('../dao/dep');

var DepBll = function (service) {
  Dao.call(this, service, null, null);

  this.depDao = new DepDao(service);
};

util.inherits(DepBll, Dao);

module.exports = DepBll;

/**
 * 验证添加部门
 * @param {*} req 
 * @param {*} args 
 * dep(code name parent_id fullname shortname company_sign external_sign description)
 * @param {*} cb 
 * null msg
 */
DepBll.prototype.verify_insert_dep = function (req, args, cb) {
  var self = this;
  if (!args.dep.code) {
    cb(null, '请提供部门代码！');
    return;
  }
  if (!args.dep.name) {
    cb(null, '请提供部门名称！');
    return;
  }
  //if (!args.dep.parent_id) args.dep.parent_id = 0;

  cb(null);
  return;

  // //验证部门
  // self.execute("select count(*) as count from sys_dep where org_id=? and parent_id=? and name=? and status=0", [req.session.orgId, args.parent_id, args.name], function (rows) {
  //   if (rows[0].count > 0) {
  //     cb('该部门已经存在！');
  //     return;
  //   }
  //   cb(null);
  //   return;
  // });
};

/**
 * 添加部门
 * @param {*} req 
 * @param {*} args 
 * dep(code name parent_id fullname shortname company_sign external_sign description)
 * @param {*} cb 
 * obj(dep) msg
 */
DepBll.prototype.insert_dep = function (req, args, cb) {
  var self = this;
  var dep = {};
  dep.org_id = req.session.orgId;
  dep.code = args.dep.code;
  dep.name = args.dep.name;
  dep.parent_id = args.dep.parent_id;
  if (!dep.parent_id) dep.parent_id = 0;
  dep.fullname = args.dep.fullname;
  if (!dep.fullname) dep.fullname = dep.name;
  dep.shortname = args.dep.shortname;
  if (!dep.shortname) dep.shortname = dep.name;
  dep.company_sign = args.dep.company_sign;
  if (!dep.company_sign) dep.company_sign = 0;
  dep.external_sign = args.dep.external_sign;
  if (!dep.external_sign) dep.external_sign = 0;
  dep.description = args.dep.description;
  dep.status = 0;
  dep.creater_id = req.session.userId;
  dep.createtime = new Date();
  dep.last_modifier_id = req.session.userId;
  dep.last_modify_time = new Date();

  //添加部门
  self.depDao.create(dep, function (ret) {
    dep.id = ret.insertId;
    //获取路径
    self.depDao.execute('select fsys_dep_getcomid(' + dep.org_id + ',' + dep.id + ') as company_id, fsys_dep_getparentids(' + dep.org_id + ',' + dep.id + ') as parent_ids', null, function (rows) {
      dep.company_id = rows[0].company_id;
      dep.parent_ids = rows[0].parent_ids;
      //修改路径
      self.depDao.update({ 'company_id': dep.company_id, 'parent_ids': dep.parent_ids }, {
        where: 'org_id=? and id=?',
        params: [dep.org_id, dep.id]
      }, function () {
        cb({ "dep": dep });
        return;
      });
    });

    // if (dep.parent_id != 0) {
    //   //获取路径
    //   self.depDao.execute('select fsys_dep_getcomid(' + dep.org_id + ',' + dep.id + ') as company_id, fsys_dep_getparentids(' + dep.org_id + ',' + dep.id + ') as parent_ids', null, function (rows) {
    //     dep.company_id = rows[0].company_id;
    //     dep.parent_ids = rows[0].parent_ids;
    //     //修改路径
    //     self.depDao.update({ 'company_id': dep.company_id, 'parent_ids': dep.parent_ids }, {
    //       where: 'org_id=? and id=?',
    //       params: [dep.org_id, dep.id]
    //     }, function () {
    //       cb({ "dep": dep });
    //       return;
    //     });
    //   });
    // }
    // else {
    //   dep.parent_ids = "," + dep.id + ",";
    //   if (dep.company_sign == 0) dep.company_id = 0;
    //   else dep.company_id = dep.id;
    //   //修改路径
    //   self.depDao.update({ 'company_id': dep.company_id, 'parent_ids': dep.parent_ids }, {
    //     where: 'org_id=? and id=?',
    //     params: [dep.org_id, dep.id]
    //   }, function () {
    //     cb({ "dep": dep });
    //     return;
    //   });
    // }
  });
};

/**
 * 获取部门
 * @param {*} req 
 * @param {*} args 
 * id
 * @param {*} cb 
 * dep msg
 */
DepBll.prototype.get_dep = function (req, args, cb) {
  var self = this;
  if (!args.id) {
    cb(null, '请提供部门编号！');
    return;
  }

  var where = " org_id=? and id=? and status in (0)";
  var params = [req.session.orgId, args.id];
  self.execute("select id,org_id,code,name,parent_id,company_sign,external_sign from sys_dep where " + where, params, function (rows) {
    if (rows.length <= 0) {
      cb(null, "请提供正确的部门编号！");
      return;
    }
    cb(rows[0]);
    return;
  });
};

/**
 * 验证修改部门
 * @param {*} req 
 * @param {*} args 
 * dep(id code name parent_id fullname shortname company_sign external_sign description)
 * o_dep(id code name parent_id company_sign external_sign)
 * @param {*} cb 
 * null msg
 */
DepBll.prototype.verify_update_dep = function (req, args, cb) {
  var self = this;
  if (!args.dep.id) {
    cb(null, '请提供部门编号！');
    return;
  }
  if (!args.dep.code) {
    cb(null, '请提供部门代码！');
    return;
  }
  if (!args.dep.name) {
    cb(null, '请提供部门名称！');
    return;
  }

  //验证循环
  if (args.dep.parent_id != null && args.dep.parent_id != 0 && args.dep.parent_id != args.o_dep.parent_id) {
    self.depDao.execute("select count(*) as count from sys_dep where org_id=? and id=? and parent_ids like ? and status=0", [req.session.orgId, args.dep.parent_id, '%,' + args.dep.id + ',%'], function (rs) {
      if (rs[0].count > 0) {
        cb(null, '上级部门不能是本部门的下级！');
        return;
      }
    });
  }

  cb(null);
  return;
};

/**
 * 修改部门
 * @param {*} req 
 * @param {*} args 
 * dep(id code name parent_id fullname shortname company_sign external_sign description)
 * o_dep(id code name parent_id company_sign external_sign)
 * @param {*} cb 
 * obj(dep)
 */
DepBll.prototype.update_dep = function (req, args, cb) {
  var self = this;
  var dep = {};
  dep.org_id = req.session.orgId;
  dep.code = args.dep.code;
  dep.name = args.dep.name;
  dep.parent_id = args.dep.parent_id;
  if (!dep.parent_id) dep.parent_id = 0;
  dep.fullname = args.dep.fullname;
  if (!dep.fullname) dep.fullname = dep.name;
  dep.shortname = args.dep.shortname;
  if (!dep.shortname) dep.shortname = dep.name;
  dep.company_sign = args.dep.company_sign;
  if (!dep.company_sign) dep.company_sign = 0;
  dep.external_sign = args.dep.external_sign;
  if (!dep.external_sign) dep.external_sign = 0;
  dep.description = args.dep.description;
  dep.last_modifier_id = req.session.userId;
  dep.last_modify_time = new Date();

  //修改部门
  self.depDao.update(dep, {
    where: 'org_id=? and id=?',
    params: [req.session.orgId, args.dep.id]
  }, function () {
    dep.id = args.dep.id;
    if (args.o_dep.parent_id != dep.parent_id || args.o_dep.company_sign != dep.company_sign) {
      //获取路径
      self.depDao.execute('select fsys_dep_getcomid(' + dep.org_id + ',' + dep.id + ') as company_id,fsys_dep_getparentids(' + dep.org_id + ',' + dep.id + ') as parent_ids', null, function (rows) {
        dep.company_id = rows[0].company_id;
        dep.parent_ids = rows[0].parent_ids;
        //修改路径
        self.depDao.update({ 'company_id': dep.company_id, 'parent_ids': dep.parent_ids }, {
          where: 'org_id=? and id=?',
          params: [dep.org_id, dep.id]
        }, function () {
          //修改子部门单位标志
          self.depDao.execute("update sys_dep set company_sign=0 " +
            "where org_id=? and id<>? and parent_ids like connectvarchar3('%,',?,',%') and status=0 and 0=" + dep.company_sign,
            [dep.org_id, dep.id, dep.id], function () {
              //修改子部门路径
              self.depDao.execute("update sys_dep set company_id=fsys_dep_getcomid(org_id,id),parent_ids=fsys_dep_getparentids(org_id,id) " +
                "where org_id=? and id<>? and parent_ids like connectvarchar3('%,',?,',%') and status=0",
                [dep.org_id, dep.id, dep.id], function () {
                  cb({ "dep": dep });
                  return;
                });
            });
        });
      });
    }
    else {
      cb({ "dep": dep });
      return;
    }
  });
};

/**
 * 删除部门
 * @param {*} req 
 * @param {*} args 
 * id
 * @param {*} cb 
 * null msg
 */
DepBll.prototype.verify_delete_dep = function (req, args, cb) {
  var self = this;
  if (!args.id) {
    cb(null, '请提供部门编号！');
    return;
  }

  self.depDao.execute("select count(*) as count from sys_dep where org_id=? and parent_id=? and status=0", [req.session.orgId, args.id], function (rows0) {
    if (rows0[0].count > 0) {
      cb(null, '部门内还有子部门，目前不能删除！');
      return;
    }
    self.depDao.execute("select count(*) as count from vsys_user where org_id=? and dep_id=? and status = 0;", [req.session.orgId, args.id], function (rows1) {
      if (rows1[0].count > 0) {
        cb(null, '部门内还有用户，目前不能删除！');
        return;
      }
      cb(null);
      return;
    });
  });
};

/**
 * 删除部门
 * @param {*} req 
 * @param {*} args 
 * id
 * @param {*} cb 
 * obj(id) msg
 */
DepBll.prototype.delete_dep = function (req, args, cb) {
  var self = this;

  //删除部门
  self.depDao.update({ "deleter_id": req.session.userId, "delete_time": new Date(), "status": 1 }, {
    where: 'org_id=? and id=?',
    params: [req.session.orgId, args.id]
  }, function () {
    // cb(null);
    cb({ "id": args.id });
    return;
  });
};

/**
 * 部门列表
 * @param {*} req 
 * @param {*} args 
 * company_id parent_id company_sign external_sign keyword within_id without_id is_all
 * @param {*} cb 
 * list msg
 */
DepBll.prototype.list_dep = function (req, args, cb) {
  var self = this;
  var where = " org_id=? and status in (0)";
  var params = [req.session.orgId];
  if (args.company_id && args.company_id != 0) {
    where += " and company_id=?";
    params.push(args.company_id);
  }
  if(!args.keyword){
    if (args.parent_id) {
      where += " and parent_id=?";
      params.push(args.parent_id);
    }
    else {
      if (args.is_all == null) where += " and parent_id=0";
    }
  }
  if (args.company_sign != null) {
    where += " and company_sign=?";
    params.push(args.company_sign);
  }
  if (args.external_sign != null) {
    where += " and external_sign=?";
    params.push(args.external_sign);
  }
  if (args.keyword != null) {
    where += " and (name like ? or code like ?)";
    params.push('%' + args.keyword + '%');
    params.push('%' + args.keyword + '%');
  }
  if (args.within_id != null) {
    where += " and parent_ids like ?";
    params.push('%,' + args.within_id + ',%');
  }
  if (args.without_id != null) {
    where += " and parent_ids not like ?";
    params.push('%,' + args.without_id + ',%');
  }

  self.execute("select id,org_id,code,name,parent_id,parent_name,company_id,company_name,fullname,shortname,company_sign,external_sign,status," +
    "creater_id,createtime,last_modifier_id,last_modify_time," +
    "(select count(*) from sys_dep s where s.org_id=vsys_dep.org_id and s.parent_id=vsys_dep.id and s.status in (0)) as child_count " +
    "from vsys_dep where " + where + " order by code ASC, id ASC", params, function (rows) {
      // 如果是子公司管理员，进来时有上级编号，需要按照上级编号查找上级
      if (args.company_id && args.company_id != '0' && args.parent_id) {
        // self.execute("select * from vsys_dep where id=?", [args.company_id], function (parentRows) {
        //   var data = parentRows[0];
        //   data.parent_id = -1;
        //   data.child_count = 1;
        //   data.company_sign = 0;
        //   data.external_sign = 0;
        //   data.spread = true;
        //   rows.push(data);
          
        // });
        cb(rows);
      } else if (args.is_org) {
        self.execute("select * from sys_org where id=?", [req.session.orgId], function (orgRows) {
          var data = orgRows[0];
          data.id = 0;
          data.parent_id = -1;
          data.child_count = 1;
          data.company_sign = 0;
          data.external_sign = 0;
          data.spread = true;
          rows.push(data);
          cb(rows);
        });
      } else {
        cb(rows);
      }
      return;
    });
};

/**
 * 获取部门
 * @param {*} req 
 * @param {*} args 
 * id
 * @param {*} cb 
 * dep msg
 */
DepBll.prototype.getv_dep = function (req, args, cb) {
  var self = this;
  if (!args.id) {
    cb(null, '请提供部门编号！');
    return;
  }

  var where = " org_id=? and id=? and status in (0)";
  var params = [req.session.orgId, args.id];
  self.execute("select id,org_id,code,name,parent_id,parent_name,company_id,company_name,fullname,shortname,company_sign,external_sign,status," +
    "creater_id,createtime,last_modifier_id,last_modify_time,description " +
    "from vsys_dep where " + where, params, function (rows) {
      if (rows.length <= 0) {
        cb(null, "请提供正确的部门编号！");
        return;
      }
      cb(rows[0]);
      return;
    });
};

/**
 * 获取部门代码
 * @param {*} req 
 * @param {*} args 
 * parent_id
 * @param {*} cb 
 * info msg
 */
DepBll.prototype.getCode_dep = function (req, args, cb) {
  var self = this;
  if (args.parent_id == null) {
    cb(null, '请提供上级部门编号！');
    return;
  }

  var info = {};
  if (args.parent_id === 0 || args.parent_id === "0") {
    self.execute("select count(*) as child_count from sys_dep where org_id=? and parent_id=?", [req.session.orgId, args.parent_id], function (rows) {
      if (rows.length <= 0) {
        cb(null, '请提供正确的上级部门编号！');
        return;
      }

      info.code = (rows[0].child_count + 1) + "";
      for (var i = info.code.length; i < 2; i++) {
        info.code = "0" + info.code;
      }
      info.allow_company = "1";
      info.allow_external = "1";
      info.allow_dep = "1";
      info.company_sign = "0";
      info.external_sign = "0";

      cb(info);
      return;
    });
  }
  else {
    self.execute("select code,company_sign,external_sign," +
      "(select count(*) from sys_dep s where s.org_id=sys_dep.org_id and s.parent_id=sys_dep.id) as child_count " +
      "from sys_dep where org_id=? and id=?", [req.session.orgId, args.parent_id], function (rows) {
        if (rows.length <= 0) {
          cb(null, '请提供正确的上级部门编号！');
          return;
        }

        info.code = (rows[0].child_count + 1) + "";
        for (var i = info.code.length; i < 2; i++) {
          info.code = "0" + info.code;
        }
        info.code = rows[0].code + info.code;
        info.allow_dep = "1";
        if (rows[0].company_sign + "" == "1") {
          info.company_sign = "0";
          info.allow_company = "1";
        }
        else {
          info.company_sign = "0";
          info.allow_company = "0";
        }
        if (rows[0].external_sign + "" == "1") {
          info.external_sign = "1";
          info.allow_external = "1";
          info.allow_dep = "0";
        }
        else {
          info.external_sign = "0";
          info.allow_external = "0";
        }

        cb(info);
        return;
      });
  }
};