var util = require('util');
var Dao = require('Dao');
var fs = require('fs');
var path = require('path');
var pdf = require('html-pdf');
var uuid = require('node-uuid');
//var toPdf = require("office-to-pdf");
var utils = require('utils');
var AppAttachDao = require('../dao/app_attach');
var puppeteer = require('../../../node_modules/puppeteer');
var exec = require('child_process').exec;

/**
 * 生成pdf
 * @param {*} service 
 */
var CreatePdfBll = function (service) {
    Dao.call(this, service, null, null);
    this.attachDao = new AppAttachDao(service);
};

util.inherits(CreatePdfBll, Dao);

module.exports = CreatePdfBll;

/**
 *  生成pdf
 * @param {*} req 
 * @param {*} args 
 * html           内容 
 * sourcType      源类型（string、html文件、office、url）
 * appCode        应用代码
 * fileName       文件名称
 * isCreateAttach 是否生成附件信息 
 * directory      指定生成目录
 * options {}     可空，参考CreateOptions
 * @param {*} cb 
 */

CreatePdfBll.prototype.createPdf = function (req, args, cb) {
    var self = this;

    if (!args.html) {
        this.onLogicError(1, '请提供内容！');
        return;
    }
    if (!args.sourcType) {
        this.onLogicError(2, '请提供源类型！');
        return;
    }
    if (!args.options) {
        // this.onLogicError(3, '请提供要导出的配置！');
        // return;
        args.options = {};
    }

    if (!args.appCode) {
        this.onLogicError(4, '请提供应用代码！');
        return;
    }

    if (args.fileName) {
        if (utils.isValidDirOrFileName(args.fileName)) {
            this.onLogicError(5, '文件名称不能包含特殊字符：\\/:*?"<>|！');
            return;
        }
        if (!args.fileName.endWith('.pdf')) {
            this.onLogicError(6, '文件扩展名仅支持.pdf');
            return;
        }
    }

    var rootpath = process.cwd();

    if (args.sourcType == "html") {
        fs.readFile(path.join(rootpath, args.html), 'utf8', function (err, data) {
            if (err) {
                self.onLogicError(7, '读取文件内容失败：' + err.message);
                return;
            }
            args.html = data;
            self.create(req, args, cb);
        });
    }
    else if (args.sourcType == "string") {

        self.create(req, args, cb);
    }
    else if (args.sourcType == "office") {

        req.wordFile = path.join(rootpath, '/files' + args.html)
        self.createByoffice(req, args, cb);
    }
    else if (args.sourcType == "url") {

        self.createByUrl(req, args, cb);
    }
    else {
        this.onLogicError(7, '暂不支持该类型！');
        return;
    }

}

//根据string生成pdf
CreatePdfBll.prototype.create = function (req, args, cb) {
    var self = this;

    pdf.create(args.html, args.options).toBuffer(function (err, buffer) {

        var rootpath = process.cwd();// app.serverPath;
        var filepath = '/files/'; //默认目录

        //指定目录
        if (args.directory) {
            filepath = args.directory;

            if (!fs.existsSync(filepath)) {
                //this.onLogicError(4, '指定目录不存！');
                if (cb) {
                    cb();
                }
                return;
            }

        } else {
            if (!fs.existsSync(path.join(rootpath, filepath))) fs.mkdirSync(path.join(rootpath, filepath));
            filepath += req.session.orgCode + '/';
            if (!fs.existsSync(path.join(rootpath, filepath))) fs.mkdirSync(path.join(rootpath, filepath));
            filepath += 'exportFiles/';
            if (!fs.existsSync(path.join(rootpath, filepath))) fs.mkdirSync(path.join(rootpath, filepath));
            filepath += args.appCode + '/';
            if (!fs.existsSync(path.join(rootpath, filepath))) fs.mkdirSync(path.join(rootpath, filepath));
        }


        var fileCode = uuid.v1().replace(/-/g, '');
        var fileName = fileCode + '.pdf';
        if (args.fileName) fileName = args.fileName;
        filepath += fileCode + '.pdf';
        var _filePath = ""; //文件路径
        if (args.directory)
            _filePath = filepath;
        else
            _filePath = utils.getPath(filepath);

        fs.writeFileSync(_filePath, buffer, 'binary');

        if (args.isCreateAttach) {

            req.filePath = _filePath;
            req.save_path = filepath;
            req.fileCode = fileCode;
            req.fileName = fileName;
            self.createAttach(req, args, cb);
        }
        else {
            if (cb) {
                var ret = {}
                ret.fileCode = fileCode;
                cb(ret);
            } else {
                self.end(res);
            }
        }

    });

};


//根据office生成pdf
CreatePdfBll.prototype.createByoffice = function (req, args, cb) {
    var self = this;

    var rootpath = process.cwd();// app.serverPath;
    var filepath = '/files/'; //默认目录

    //指定目录
    if (args.directory) {
        filepath = args.directory;
        if (!fs.existsSync(filepath)) {
            //this.onLogicError(4, '指定目录不存！');
            if (cb) {
                cb();
            }
            return;
        }
    } else {
        if (!fs.existsSync(path.join(rootpath, filepath))) fs.mkdirSync(path.join(rootpath, filepath));
        filepath += req.session.orgCode + '/';
        if (!fs.existsSync(path.join(rootpath, filepath))) fs.mkdirSync(path.join(rootpath, filepath));
        filepath += 'exportFiles/';
        if (!fs.existsSync(path.join(rootpath, filepath))) fs.mkdirSync(path.join(rootpath, filepath));
        filepath += args.appCode + '/';
        if (!fs.existsSync(path.join(rootpath, filepath))) fs.mkdirSync(path.join(rootpath, filepath));
    }

    var _filePath = "";
    if (args.directory) {
        _filePath = filepath;
    } else {
        _filePath = utils.getPath(filepath);
    }

    var cmd = 'soffice --headless --convert-to pdf ' + req.wordFile + ' --outdir ' + _filePath;
    if (server.config.ServerType == 'linux') {
        cmd = 'libreoffice --headless --invisible --convert-to pdf:writer_pdf_Export ' + req.wordFile + ' --outdir ' + _filePath;
    }

    exec(cmd, { 'cp936': 'binary' }, function (error, stdout, stderr) {
        if (error) {
            if (cb) {
                logger.log(error);
                cb();
            } else {
                self.onError(error);
            }
        } else {

            var fileCode = uuid.v1().replace(/-/g, '');
            var new_path = _filePath + fileCode + '.pdf';
            var old_name = path.basename(req.wordFile);
            var i = old_name.lastIndexOf(".");
            var old_path = _filePath + old_name.substr(0, i) + '.pdf';
            fs.rename(old_path, new_path, function (err) {
                if (err) {
                    logger.log(err);
                    if (cb) {
                        cb();
                    } else {
                        self.onError(err);
                    }
                    return;
                }
                if (args.isCreateAttach) {
                    var fileName = fileCode + '.pdf';
                    if (args.fileName) fileName = args.fileName;
                    filepath += fileCode + '.pdf';
                    req.filePath = utils.getPath(filepath);
                    req.save_path = '/' + req.session.orgCode + '/exportFiles/' + args.appCode + '/' + fileCode + '.pdf';
                    req.fileCode = fileCode;
                    req.fileName = fileName;
                    self.createAttach(req, args, cb);
                }
                else {
                    if (cb) {
                        var ret = {}
                        ret.fileCode = fileCode;
                        cb(ret);
                    } else {
                        self.end(res);
                    }
                }
            });
        }
    });
};


//根据url生成pdf
CreatePdfBll.prototype.createByUrl = function (req, args, cb) {
    var self = this;

    var rootpath = process.cwd();
    var fileName = args.fileName;
    var viewUrl = args.html;
    var filepath = '/files/'; //默认目录
    var fileCode = uuid.v1().replace(/-/g, '');
    var _filePath = ""; //文件路径

    //指定目录
    if (args.directory) {
        filepath = args.directory;

        if (!fs.existsSync(filepath)) {
            //this.onLogicError(4, '指定目录不存！');
            if (cb) {
                cb();
            }
            return;
        }

    } else {
        if (!fs.existsSync(path.join(rootpath, filepath))) fs.mkdirSync(path.join(rootpath, filepath));
        filepath += req.session.orgCode + '/';
        if (!fs.existsSync(path.join(rootpath, filepath))) fs.mkdirSync(path.join(rootpath, filepath));
        filepath += 'exportFiles/';
        if (!fs.existsSync(path.join(rootpath, filepath))) fs.mkdirSync(path.join(rootpath, filepath));
        filepath += args.appCode + '/';
        if (!fs.existsSync(path.join(rootpath, filepath))) fs.mkdirSync(path.join(rootpath, filepath));
    }

    filepath = utils.getPath(filepath);

    //TODO 从配置文件读取协议和端口，通过localhost/127.0.0.1形式拼装
    var baseUrl = "http://127.0.0.1:" + server.config.Port;

    if (!req.session || !req.session.cache) {
        // 没有缓存的情况下通过表查询用户名与密码
        self.attachDao.execute('select loginname,password from tm_user where org_id=? and id=?', [req.session.orgId, req.session.userId], function (ret) {
            if (ret.length === 0) {
                self.onError('未找到职员数据！');
                return;
            }
            var loginname = ret[0].loginname;
            var password = ret[0].password;
            (async () => {
                try {
                    var executablePath = rootpath + '/chromium/win64-722234/chrome.exe';
                    if (server.config.ServerType == 'linux') {
                        executablePath = rootpath + '/chromium/linux64-722234/chromium';
                    }
                    const browser = await puppeteer.launch({
                        headless: true,
                        //defaultViewport:{width:1080,height:720},
                        defaultViewport: null,
                        args: ['--disable-infobars', '--no-sandbox', '--disable-setuid-andbox'],//'--start-maximized',
                        executablePath: executablePath,
                        ignoreHttpsErrors: true
                    });
                    const page = await browser.newPage();
                    await page.goto(baseUrl + "/loginFromPdf.html", { waitUntil: 'networkidle2', });
                    //TODO web端加一个通过登录名、md5密码登录的页面，并且只允许从本机访问
                    //登录
                    //TODO 当前用户登录名从session中获取，当前用户密码从user缓存中获取
                    //TODO 如何跳过短信验证、扫码登录、图形验证码等
                    await page.type('#input-loginname', loginname);
                    await page.type('#input-password', password);
                    await page.click('.submit');
                    await page.waitForNavigation({ timedout: 10 * 1000, waitUntil: 'load' });
                    //跳转掉要打印的页面
                    await page.goto(baseUrl + viewUrl, { timedout: 10 * 1000, waitUntil: 'networkidle0' });
                    await page.content();
                    await page.pdf({
                        path: filepath + fileCode + '.pdf', fromat: 'A4', printBackground: true,
                        '-webkit-print-color-adjust': 'exact'
                    });
                    await page.close();
                    await browser.close();
                    _filePath = filepath + fileCode + '.pdf';
                    if (args.isCreateAttach) {
                        req.filePath = _filePath;
                        req.save_path = '/' + req.session.orgCode + '/exportFiles/' + args.appCode + '/' + fileCode + '.pdf';
                        req.fileCode = fileCode;
                        req.fileName = fileName;
                        self.createAttach(req, args, cb);
                    }
                    else {
                        if (cb) {
                            var ret = {}
                            ret.fileCode = fileCode;
                            cb(ret);
                        } else {
                            self.end(res);
                        }
                    }
                } catch (e) {
                    logger.log('转换错误：' + e.message);
                }
            })();
        });
    } else {
        req.session.cache.get("user", req.session.userId, function (err, user) {
            if (err) {
                self.onError(err);
                return;
            }
            (async () => {

                var executablePath = rootpath + '/chromium/win64-722234/chrome.exe';
                if (server.config.ServerType == 'linux') {
                    executablePath = rootpath + '/chromium/linux64-722234/chromium';
                }

                const browser = await puppeteer.launch({
                    headless: true,
                    //defaultViewport:{width:1080,height:720},
                    defaultViewport: null,
                    args: ['--disable-infobars', '--no-sandbox', '--disable-setuid-andbox'],//'--start-maximized',
                    executablePath: executablePath,
                    ignoreHttpsErrors: true
                });

                const page = await browser.newPage();
                await page.goto(baseUrl + "/loginFromPdf.html", { waitUntil: 'networkidle2', });
                //TODO web端加一个通过登录名、md5密码登录的页面，并且只允许从本机访问
                //登录
                //TODO 当前用户登录名从session中获取，当前用户密码从user缓存中获取
                //TODO 如何跳过短信验证、扫码登录、图形验证码等
                await page.type('#input-loginname', req.session.userLoginname);
                await page.type('#input-password', user.password);
                await page.click('.submit');
                await page.waitForNavigation({ timedout: 10 * 1000, waitUntil: 'load' });
                //跳转掉要打印的页面
                await page.goto(baseUrl + viewUrl, { timedout: 10 * 1000, waitUntil: 'networkidle0' });
                await page.content();
                await page.pdf({
                    path: filepath + fileCode + '.pdf', fromat: 'A4', printBackground: true,
                    '-webkit-print-color-adjust': 'exact'
                });
                await page.close();
                await browser.close();

                _filePath = filepath + fileCode + '.pdf';
                if (args.isCreateAttach) {
                    req.filePath = _filePath;
                    req.save_path = '/' + req.session.orgCode + '/exportFiles/' + args.appCode + '/' + fileCode + '.pdf';
                    req.fileCode = fileCode;
                    req.fileName = fileName;
                    self.createAttach(req, args, cb);
                }
                else {
                    if (cb) {
                        var ret = {}
                        ret.fileCode = fileCode;
                        cb(ret);
                    } else {
                        self.end(res);
                    }
                }
            })();
        });
    }
}

//生成附件信息
CreatePdfBll.prototype.createAttach = function (req, args, cb) {
    var stat = fs.statSync(req.filePath);
    var attach = {};
    attach.code = req.fileCode;
    attach.name = req.fileName;
    attach.size = stat.size;
    attach.type = path.extname(req.fileName);
    attach.app_code = args.appCode;
    var app_data_id = 0;
    if (args.appDataId) app_data_id = args.appDataId;
    attach.app_data_id = app_data_id;
    attach.uploader_id = req.session.userId;
    attach.uploader_name = req.session.userName;
    attach.upload_time = new Date();
    attach.save_path = req.save_path;
    attach.org_id = req.session.orgId;

    var self = this;
    self.attachDao.create(attach, function (ret) {
        if (cb) {
            ret.fileCode = attach.code;
            cb(ret);
        } else {
            self.end(res);
        }
    });
}
