var util = require('util');
var Dao = require('Dao');

var Cache = function (service) {
    Dao.call(this, service, null, null);
};

util.inherits(Cache, Dao);

module.exports = Cache;

/////////////////

/**
 * 获取缓存项目！
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 回调（items）
 */
Cache.prototype.getItems = function (req, args, cb) {
    var items = [{ "name": "user", "title": "用户" }, { "name": "dep", "title": "部门" }, { "name": "post", "title": "岗位" }, { "name": "level", "title": "级别" }, { "name": "layer", "title": "层级" }, { "name": "role", "title": "角色" }, { "name": "position_user", "title": "任职" }, { "name": "user_position", "title": "管辖" }, { "name": "org_door", "title": "门户" }, { "name": "org_door_auth", "title": "门户权限" }, { "name": "org_door_apps", "title": "门户应用" }, { "name": "org_app", "title": "应用" }, { "name": "org_app_auth", "title": "应用权限" }

        // , { "name": "user", "title": "m用户" }
        // , { "name": "mdep", "title": "m部门" }
        // , { "name": "mpost", "title": "m岗位" }
        // , { "name": "mlevel", "title": "m级别" }
        // , { "name": "mlayer", "title": "m层级" }
        // , { "name": "mrole", "title": "m角色" }
        // , { "name": "mdeppost", "title": "m任职" }
        // , { "name": "msubdep", "title": "m分管" }
        // , { "name": "msupuser", "title": "m上级" }
        // , { "name": "mownrole", "title": "m拥有角色" }
    ];
    cb(items);
};

/**
 * 获取缓存数据列表！
 * @param {*} req 
 * @param {*} args 参数（name 缓存项目名称）
 * @param {*} cb 回调（objs）
 */
Cache.prototype.getPage = function (req, args, cb) {
    var where = " org_id==" + req.session.orgId;
    if (args.name == "user") {
        req.session.cache.getList('user', {
            "fields": 'org_id,id,code,name,loginname,sex,head_id,post,motto,mobile,nickname,email,tel_short,tel_work,password,theme_id',
            "where": where,
            "order": "id asc",
            "toPage": req.toPage,
            "pageSize": req.pageSize,
        }, function (err, objs) {
            if (err) {
                cb(null);
                return;
            }
            cb(objs);
        });
    } else if (args.name == "dep") {
        req.session.cache.getList('dep', {
            "fields": 'org_id,id,code,name,parent_id,company_sign,external_sign,company_id,parent_ids',
            "where": where,
            "order": "id asc",
            "toPage": req.toPage,
            "pageSize": req.pageSize,
        }, function (err, objs) {
            if (err) {
                cb(null);
                return;
            }
            cb(objs);
        });
    } else if (args.name == "post") {
        req.session.cache.getList('post', {
            "fields": 'org_id,id,code,name,parent_id',
            "where": where,
            "order": "id asc",
            "toPage": req.toPage,
            "pageSize": req.pageSize,
        }, function (err, objs) {
            if (err) {
                cb(null);
                return;
            }
            cb(objs);
        });
    } else if (args.name == "level") {
        req.session.cache.getList('level', {
            "fields": 'org_id,id,code,name',
            "where": where,
            "order": "id asc",
            "toPage": req.toPage,
            "pageSize": req.pageSize,
        }, function (err, objs) {
            if (err) {
                cb(null);
                return;
            }
            cb(objs);
        });
    } else if (args.name == "layer") {
        req.session.cache.getList('layer', {
            "fields": 'org_id,id,code,name',
            "where": where,
            "order": "id asc",
            "toPage": req.toPage,
            "pageSize": req.pageSize,
        }, function (err, objs) {
            if (err) {
                cb(null);
                return;
            }
            cb(objs);
        });
    } else if (args.name == "role") {
        req.session.cache.getList('role', {
            "fields": 'org_id,id,code,name,type_id',
            "where": where,
            "order": "id asc",
            "toPage": req.toPage,
            "pageSize": req.pageSize,
        }, function (err, objs) {
            if (err) {
                cb(null);
                return;
            }
            cb(objs);
        });
    } else if (args.name == "position_user") {
        req.session.cache.getList('position_user', {
            "fields": 'org_id,id,order_number,user_id,dep_id,post_id,level_id',
            "where": where,
            "order": "id asc",
            "toPage": req.toPage,
            "pageSize": req.pageSize,
        }, function (err, objs) {
            if (err) {
                cb(null);
                return;
            }
            cb(objs);
        });
    } else if (args.name == "user_position") {
        req.session.cache.getList('user_position', {
            "fields": 'org_id,id,order_number,user_id,dep_id,layer_id',
            "where": where,
            "order": "id asc",
            "toPage": req.toPage,
            "pageSize": req.pageSize,
        }, function (err, objs) {
            if (err) {
                cb(null);
                return;
            }
            cb(objs);
        });
    } else if (args.name == "org_door") {
        req.session.cache.getList('org_door', {
            "fields": 'org_id,id,code,name,parent_id,terminal,icon,url,order_no,group_apps',
            "where": where,
            "order": "id asc",
            "toPage": req.toPage,
            "pageSize": req.pageSize,
        }, function (err, objs) {
            if (err) {
                cb(null);
                return;
            }
            cb(objs);
        });
    } else if (args.name == "org_door_auth") {
        req.session.cache.getList('org_door_auth', {
            "fields": 'org_id,id,door_id,owner_type,owner_id,opration_id',
            "where": where,
            "order": "id asc",
            "toPage": req.toPage,
            "pageSize": req.pageSize,
        }, function (err, objs) {
            if (err) {
                cb(null);
                return;
            }
            cb(objs);
        });
    } else if (args.name == "org_door_apps") {
        req.session.cache.getList('org_door_apps', {
            "fields": 'org_id,id,door_id,app_id,order_no',
            "where": where,
            "order": "id asc",
            "toPage": req.toPage,
            "pageSize": req.pageSize,
        }, function (err, objs) {
            if (err) {
                cb(null);
                return;
            }
            cb(objs);
        });
    } else if (args.name == "org_app") {
        req.session.cache.getList('org_app', {
            "fields": 'org_id,id,app_id,code,name,parent_id,parent_code,order_no',
            "where": where,
            "order": "id asc",
            "toPage": req.toPage,
            "pageSize": req.pageSize,
        }, function (err, objs) {
            if (err) {
                cb(null);
                return;
            }
            cb(objs);
        });
    } else if (args.name == "org_app_auth") {
        req.session.cache.getList('org_app_auth', {
            "fields": 'org_id,id,app_id,terminal,owner_type,owner_id,opration_id',
            "where": where,
            "order": "id asc",
            "toPage": req.toPage,
            "pageSize": req.pageSize,
        }, function (err, objs) {
            if (err) {
                cb(null);
                return;
            }
            cb(objs);
        });
    } else {
        cb(null);
    }
};

/**
 * 获取缓存数据对象！
 * @param {*} req 
 * @param {*} args 参数（name 缓存项目名称 id 编号）
 * @param {*} cb 回调（obj）
 */
Cache.prototype.get = function (req, args, cb) {
    req.session.cache.get(args.name, args.id, function (err, obj) {
        if (err) {
            cb(null);
            return;
        }
        cb(obj);
    });
};

/**
 * 获取用户基本信息！
 * @param {*} req 
 * @param {*} args 参数（name 缓存项目名称 id 编号）
 * @param {*} cb 回调（obj）
 */
Cache.prototype.getBaseUserInfo = function (req, args, cb) {
    if (args.id == null) {
        cb(null);
        return;
    }
    req.session.cache.exec(args, function (cacheData, args) {
        var objUser = cacheData['user'].values[args.id];
        var userInfo = {};
        userInfo.id = objUser.id;
        userInfo.name = objUser.name;
        userInfo.code = objUser.code;
        var objJobs = cacheData['position_user'].values;
        for (var k in objJobs) {
            var objJob = objJobs[k];
            if (objJob != null && objJob.user_id == objUser.id) {
                if (objJob.order_number == 1) {
                    if (objJob.dep_id != null) {
                        var objDep = cacheData['dep'].values[objJob.dep_id];
                        if (objDep != null) {
                            userInfo.dep_id = objDep.id;
                            userInfo.dep_name = objDep.name;
                            userInfo.dep_code = objDep.code;
                            if (objDep.company_id != null) {
                                var objCom = cacheData['dep'].values[objDep.company_id];
                                if (objCom != null) {
                                    userInfo.com_id = objCom.id;
                                    userInfo.com_name = objCom.name;
                                    userInfo.com_code = objCom.code;
                                }
                            }
                        }
                    }

                    if (objJob.post_id != null) {
                        var objPost = cacheData['post'].values[objJob.post_id];
                        if (objPost != null) {
                            userInfo.post_id = objPost.id;
                            userInfo.post_name = objPost.name;
                            userInfo.post_code = objPost.code;
                        }
                    }
                }
                break;
            }
        }
        return userInfo
    }, function (err, ret) {
        if (err) {
            cb(null);
            return;
        }
        cb(ret);
    });
};

/**
 * 获取缓存用户信息（带层级）！
 * @param {*} req 
 * @param {*} args 参数（userId）
 * @param {*} cb 
 */
Cache.prototype.getTUser = function (req, args, cb) {
    // req.session.cache.get('user', args.userId, function(err, objUser) {
    //   if(err) {
    //     cb(null);
    //     return;
    //   }
    //   var obj = {};
    //   obj.userId = objUser.id;
    //   obj.userName = objUser.name;
    //   obj.userCode = objUser.code;
    //   obj.sex = objUser.sex;
    //   obj.nickname = objUser.nickname;
    //   obj.head_id = objUser.head_id;
    //   obj.theme_id = objUser.theme_id;
    //   obj.job_ids = objUser.positions;
    //   obj.jobs = [];
    //   obj.sub_ids = objUser.subPositions;
    //   obj.subs = [];
    //   obj.role_ids = objUser.roles;
    //   obj.roles = [];
    // });

    req.session.cache.exec(args, function (cacheData, args) {
        var obj = {};
        var objUser = cacheData['user'].values[args.userId];
        obj.userId = objUser.id;
        obj.userName = objUser.name;
        obj.userCode = objUser.code;
        obj.sex = objUser.sex;
        obj.nickname = objUser.nickname;
        obj.head_code = objUser.head_code;
        // obj.head_id = objUser.head_id; //!
        // obj.theme_id = objUser.theme_id; //!
        obj.comId = objUser.com_id;
        obj.comName = objUser.com_name;
        obj.comCode = objUser.com_code;
        obj.depId = objUser.dep_id;
        obj.depName = objUser.dep_name;
        obj.depCode = objUser.dep_code;
        obj.postId = objUser.post_id;
        obj.postName = objUser.post_name;
        obj.postCode = objUser.post_code;

        obj.job_ids = objUser.positions;
        obj.jobs = [];
        obj.sub_ids = objUser.subPositions;
        obj.subs = [];
        obj.role_ids = objUser.roles;
        obj.roles = [];

        var objJobs = cacheData['position_user'].values;
        for (var k in objJobs) {
            var objJob = objJobs[k];
            if (objJob != null && objJob.user_id == obj.userId) {
                var dep = null;
                if (objJob.dep_id != null) {
                    var objDep = cacheData['dep'].values[objJob.dep_id];
                    if (objDep != null)
                        dep = {
                            "id": objDep.id,
                            "name": objDep.name,
                            "code": objDep.code,
                            "parent_id": objDep.parent_id,
                            "fullname": objDep.fullname,
                            "shortname": objDep.shortname,
                            "company_id": objDep.company_id,
                            "parent_ids": objDep.parent_ids,
                            "company_sign": objDep.company_sign,
                            "external_sign": objDep.external_sign
                        };
                }
                var post = null;
                if (objJob.post_id != null) {
                    var objPost = cacheData['post'].values[objJob.post_id];
                    if (objPost != null)
                        post = {
                            "id": objPost.id,
                            "name": objPost.name,
                            "code": objPost.code,
                            "parent_id": objPost.parent_id
                        };
                }
                var level = null;
                if (objJob.level_id != null) {
                    var objLevel = cacheData['level'].values[objJob.level_id];
                    if (objLevel != null)
                        level = {
                            "id": objLevel.id,
                            "name": objLevel.name,
                            "code": objLevel.code
                        };
                }
                obj.jobs.push({
                    "id": objJob.id,
                    "order_number": objJob.order_number,
                    "dep": dep,
                    "post": post,
                    "level": level
                })
                if (objJob.order_number == 1) {
                    obj.dep = dep;
                    obj.post = post;
                    obj.level = level;
                }
            }
        }

        var objSubs = cacheData['user_position'].values;
        for (var r in objSubs) {
            var objSub = objSubs[r];
            if (objSub.user_id == obj.userId) {
                var dep = null;
                if (objSub.dep_id != null) {
                    var objDep = cacheData['dep'].values[objSub.dep_id];
                    if (objDep != null)
                        dep = {
                            "id": objDep.id,
                            "name": objDep.name,
                            "code": objDep.code,
                            "parent_id": objDep.parent_id,
                            "fullname": objDep.fullname,
                            "shortname": objDep.shortname,
                            "company_id": objDep.company_id,
                            "parent_ids": objDep.parent_ids,
                            "company_sign": objDep.company_sign,
                            "external_sign": objDep.external_sign
                        };
                }
                var layer = null;
                if (objSub.layer_id != null) {
                    var objLayer = cacheData['layer'].values[objSub.layer_id];
                    if (objLayer != null)
                        layer = {
                            "id": objLayer.id,
                            "name": objLayer.name,
                            "code": objLayer.code
                        };
                }
                obj.subs.push({
                    "id": objSub.id,
                    "dep": dep,
                    "layer": layer
                })
            }
        }

        for (var i = 0; i < objUser.roles.length; i++) {
            var objRole = cacheData['role'].values[objUser.roles[i]];
            obj.roles.push({
                "id": objRole.id,
                "name": objRole.name,
                "code": objRole.code,
                "type_id": objRole.type_id
            });
        }

        return obj;
    }, function (err, ret) {
        if (err) {
            cb(null);
            return;
        }
        cb(ret);
    });

};

/**
 * 获取缓存用户信息！
 * @param {*} req 
 * @param {*} args 参数（userId）
 * @param {*} cb 
 */
Cache.prototype.getUser = function (req, args, cb) {
    if (args.userId == null) {
        cb(null);
        return;
    }
    req.session.cache.exec(args, function (cacheData, args) {
        var obj = {};
        var objUser = cacheData['user'].values[args.userId];
        obj.org_id = objUser.org_id;
        obj.userId = objUser.id;
        obj.userName = objUser.name;
        obj.userCode = objUser.code;
        obj.sex = objUser.sex;
        obj.nickname = objUser.nickname;
        obj.head_code = objUser.head_code;
        // obj.head_id = objUser.head_id; //!
        // obj.theme_id = objUser.theme_id; //!
        // obj.comId = objUser.com_id;
        // obj.comName = objUser.com_name;
        // obj.comCode = objUser.com_code;
        // obj.depId = objUser.dep_id;
        // obj.depName = objUser.dep_name;
        // obj.depCode = objUser.dep_code;
        // obj.postId = objUser.post_id;
        // obj.postName = objUser.post_name;
        // obj.postCode = objUser.post_code;

        obj.job_ids = []; //任职记录
        obj.dep_ids = []; //任职部门
        obj.comId = null;
        obj.comName = null;
        obj.comCode = null;
        obj.depId = null;
        obj.depName = null;
        obj.depCode = null;
        obj.postId = null;
        obj.postName = null;
        obj.postCode = null;
        obj.levelId = null;
        obj.levelName = null;
        obj.levelCode = null;
        obj.sub_ids = []; //管辖记录
        obj.subdep_ids = []; //管辖部门
        obj.role_ids = []; //角色

        var objJobs = cacheData['position_user'].values;
        for (var k in objJobs) {
            var objJob = objJobs[k];
            if (objJob != null && objJob.user_id == obj.userId) {
                obj.job_ids.push(objJob.id);
                if (objJob.dep_id != null) obj.dep_ids.push(objJob.dep_id);

                if (objJob.order_number == 1) {
                    if (objJob.dep_id != null) {
                        var objDep = cacheData['dep'].values[objJob.dep_id];
                        if (objDep != null) {
                            obj.depId = objDep.id;
                            obj.depName = objDep.name;
                            obj.depCode = objDep.code;
                            if (objDep.company_id != null) {
                                var objCom = cacheData['dep'].values[objDep.company_id];
                                if (objCom != null) {
                                    obj.comId = objCom.id;
                                    obj.comName = objCom.name;
                                    obj.comCode = objCom.code;
                                }
                            }
                        }
                    }

                    if (objJob.post_id != null) {
                        var objPost = cacheData['post'].values[objJob.post_id];
                        if (objPost != null) {
                            obj.postId = objPost.id;
                            obj.postName = objPost.name;
                            obj.postCode = objPost.code;
                        }
                    }

                    if (objJob.level_id != null) {
                        var objLevel = cacheData['level'].values[objJob.level_id];
                        if (objLevel != null) {
                            obj.levelId = objLevel.id;
                            obj.levelName = objLevel.name;
                            obj.levelCode = objLevel.code;
                        }
                    }
                }
            }
        }
        var objSubs = cacheData['user_position'].values;
        obj.subdep_ids.push(-1);
        for (var r in objSubs) {
            var objSub = objSubs[r];
            if (objSub.user_id == obj.userId) {
                obj.sub_ids.push(objSub.id);
                if (objSub.dep_id != null) obj.subdep_ids.push(objSub.dep_id);
            }
        }
        obj.role_ids.push(-1);
        for (var i = 0; i < objUser.roles.length; i++) {
            obj.role_ids.push(objUser.roles[i]);
        }
        return obj;
    }, function (err, ret) {
        if (err) {
            cb(null);
            return;
        }
        cb(ret);
    });
};

/////////////////

/////////////////

/**
 * 用户列表
 * @param {*} req 
 * @param {*} args 
 * com_id keyword sex mobile status
 * dep_id is_all include_deps role_id 部门编号 包含子部门 包含兼职人员 角色编号
 * show_main 显示主职 show_deps 显示兼职 
 * show_subdeps 显示分管 show_roles 显示角色 show_supuser 显示上级 show_subuser 显示下属
 * @param {*} cb 
 * list msg
 */
Cache.prototype.getListMUser = function (req, args, cb) {
    var self = this;
    req.session.cache.exec(args, function (cacheData, args) {
        var list = [];
        var musers = cacheData['user']; //id,org_id,code,name,loginname,password,mobile,email,motto,sex,post,nickname,tel_short,tel_work,tel_home,tel_other,head_code,theme
        var mdeps = cacheData['mdep']; //id,org_id,code,name,company_sign,external_sign,parent_id,company_id,parent_ids
        var mposts = cacheData['mpost']; //id,org_id,code,name,parent_id,parent_ids
        var mlevels = cacheData['mlevel']; //id,org_id,code,name
        var mroles = cacheData['mrole']; //id,org_id,code,name

        var mdepposts = cacheData['mdeppost']; //id,org_id,order_number,user_id,dep_id,post_id,level_id
        // var mownroles = cacheData['mownrole']; //id,org_id,user_id,role_id,is_admin
        // var msubdeps = cacheData['msubdep']; //id,org_id,order_number,user_id,dep_id,layer_id
        // var msupusers = cacheData['msupuser']; //id,org_id,user_id,leader_id

        for (var i = 0; i < musers.keys.length; i++) {
            var muser = musers.values[musers.keys[i]];
            if (muser == null) continue;
            if (args.keyword != null) {
                if (muser.name.indexOf(args.keyword) < 0 && muser.code.indexOf(args.keyword) < 0 && muser.loginname.indexOf(args.keyword) < 0) {
                    if (!muser.mobile || (muser.mobile && muser.mobile.indexOf(args.keyword) < 0)) {
						if (!muser.tel_short || (muser.tel_short && muser.tel_short.indexOf(args.keyword) < 0)) {
							continue;
						}
					}
                }
            }
            if (args.sex != null) {
                if (muser.sex != args.sex) continue;
            }
            if (args.mobile != null) {
                if (muser.mobile.indexOf(args.mobile) < 0) continue;
            }

            var selected = false;

            //部门
            var maindep_id = null;
            var mainpost_id = null;
            var mainlevel_id = null;
            var condep_ids = [];
            // var condep_names = [];
            for (var j = 0; j < mdepposts.keys.length; j++) {
                var mdeppost = mdepposts.values[mdepposts.keys[j]];
                if (mdeppost == null) continue;
                if (muser.id == mdeppost.user_id) {
                    //主职
                    if (mdeppost.order_number == 1) {
                        maindep_id = mdeppost.dep_id;
                        mainpost_id = mdeppost.post_id;
                        mainlevel_id = mdeppost.level_id;
                    }

                    //兼职
                    if (mdeppost.dep_id != null) {
                        condep_ids.push(mdeppost.dep_id + "");
                    }
                }
            }

            //角色
            var role_ids = [];
            // var role_names = [];
            if (args.role_id != null || args.show_roles == "Y") {
                var mownroles = cacheData['mownrole']; //id,org_id,user_id,role_id,is_admin
                for (var b = 0; b < mownroles.keys.length; b++) {
                    var mownrole = mownroles.values[mownroles.keys[b]];
                    if (mownrole == null) continue;
                    if (muser.id == mownrole.user_id) {
                        if (mownrole.role_id != null) {
                            role_ids.push(mownrole.role_id + "");
                        }
                    }
                }
            }

            var maindep = null;
            if (maindep_id != null) maindep = mdeps.values[maindep_id];
            if (args.com_id != null) {
                if (maindep == null) continue;
                if (maindep.company_id != args.com_id) continue;
            }

            //按部门查询
            if (!selected && args.dep_id != null) {
                if (maindep == null) continue;
                if (args.is_all == null) {
                    if (maindep.id == args.dep_id) selected = true;
                    if (args.include_deps == "Y") {
                        if (condep_ids.length > 0 && condep_ids.includes(args.dep_id)) selected = true;
                        // if (dep_ids != null && ("," + dep_ids + ",").indexOf("," + args.dep_id + ",") >= 0) selected = true;
                    }
                }
                else {
                    if (maindep.parent_ids.indexOf("," + args.dep_id + ",") >= 0) selected = true;
                }
            }

            //按角色查询
            if (!selected && args.role_id != null) {
                if (role_ids.length > 0 && role_ids.includes(args.role_id)) selected = true;
                // if (role_ids != null && ("," + role_ids + ",").indexOf("," + args.role_id + ",") >= 0) selected = true;
            }

            //其他方式
            if (!selected && args.dep_id == null && args.role_id == null) {
                if (args.is_all == null) {
                    if (maindep_id == "0") selected = true;
                }
                else {
                    selected = true;
                }
            }

            if (!selected && args.keyword) {
                selected = true;
            }

            if (!selected) continue;

            //id,org_id,code,name,loginname,password,mobile,email,motto,sex,post,nickname,tel_short,tel_work,tel_home,tel_other,head_code,theme
            var user = {};
            user.id = muser.id;
            user.org_id = muser.org_id;
            user.code = muser.code;
            user.name = muser.name;
            if (args.include_deps == "Y" && args.dep_id != maindep_id) {
                user.name += ' [兼职]';
                user.sign = "兼职";
            }
            user.loginname = muser.loginname;
            user.mobile = muser.mobile;
            user.email = muser.email;
            user.sex = muser.sex;
            user.nickname = muser.nickname;
            user.head_code = muser.head_code;
            user.head_id = muser.head_id;

            if (args.show_main != "N") {
                if (maindep != null) {
                    // user.dep = {
                    //     "dep_id": maindep.id, "dep_code": maindep.code, "dep_name": maindep.name,
                    //     "com_id": maindep.company_id, "parent_id": maindep.parent_id, "parent_ids": maindep.parent_ids
                    // };
                    user.dep_id = maindep.id;
                    user.dep_code = maindep.code;
                    user.dep_name = maindep.name;
                    // user.com_id = maindep.company_id;
                    // user.parent_id = maindep.parent_id;

                    var t_com = null;
                    if (maindep.company_id > 0) t_com = mdeps.values[maindep.company_id];
                    if (t_com != null) {
                        user.com_id = t_com.id;
                        user.com_code = t_com.code;
                        user.com_name = t_com.name;
                    }
                    else {
                        user.com_id = maindep.company_id;
                        user.com_code = "";
                        user.com_name = "";
                    }
                    var t_parent = null;
                    if (maindep.parent_id > 0) t_parent = mdeps.values[maindep.parent_id];
                    if (t_parent != null) {
                        user.parent_id = t_parent.id;
                        user.parent_code = t_parent.code;
                        user.parent_name = t_parent.name;
                    }
                    else {
                        user.parent_id = maindep.parent_id;
                        user.parent_code = "";
                        user.parent_name = "";
                    }
                    user.parent_ids = maindep.parent_ids;
                }

                var mainpost = null;
                if (mainpost_id != null) mainpost = mposts.values[mainpost_id];
                if (mainpost != null) {
                    // user.post = {
                    //     "post_id": mainpost.id, "post_code": mainpost.code, "post_name": mainpost.name
                    // };
                    user.post_id = mainpost.id;
                    user.post_code = mainpost.code;
                    user.post_name = mainpost.name;
                }
                var mainlevel = null;
                if (mainlevel_id != null) mainlevel = mlevels.values[mainlevel_id];
                if (mainlevel != null) {
                    // user.level = {
                    //     "level_id": mainlevel.id, "level_code": mainlevel.code, "level_name": mainlevel.name
                    // };
                    user.level_id = mainlevel.id;
                    user.level_name = mainlevel.name;
                    user.level_code = mainlevel.code;
                }
            }

            if (args.show_deps != "N") {
                // var t_condeps = [];
                var t_condep_ids = [];
                var t_condep_names = [];
                for (var aa = 0; aa < condep_ids.length; aa++) {
                    var t_condep = mdeps.values[condep_ids[aa]];
                    if (t_condep != null) {
                        // t_condeps.push({ "id": t_condep.id, "name": t_condep.name });
                        t_condep_ids.push(t_condep.id);
                        t_condep_names.push(t_condep.name);
                    }
                }

                // user.deps = t_condeps;
                user.dep_ids = t_condep_ids.toString(",");
                user.dep_names = t_condep_names.toString(",");
            }

            if (args.show_roles == "Y") {
                // var t_roles = [];
                var t_role_ids = [];
                var t_role_names = [];
                for (var cc = 0; cc < role_ids.length; cc++) {
                    var t_role = mroles.values[role_ids[cc]];
                    if (t_role != null) {
                        // t_roles.push({ "id": t_role.id, "name": t_role.name });
                        t_role_ids.push(t_role.id);
                        t_role_names.push(t_role.name);
                    }
                }

                // user.roles = t_roles;
                user.role_ids = t_role_ids.toString(",");
                user.role_names = t_role_names.toString(",");
            }

            //分管
            if (args.show_subdeps == "Y") {
                // var subdeps = [];
                var subdep_ids = [];
                var subdep_names = [];
                var msubdeps = cacheData['msubdep']; //id,org_id,order_number,user_id,dep_id,layer_id
                for (var a = 0; a < msubdeps.keys.length; a++) {
                    var msubdep = msubdeps.values[msubdeps.keys[a]];
                    if (msubdep == null) continue;
                    if (muser.id == msubdep.user_id) {
                        var subdep = null;
                        if (msubdep.dep_id != null) subdep = mdeps.values[msubdep.dep_id];
                        if (subdep != null) {
                            // subdeps.push({ "id": subdep.id, "name": subdep.name });
                            subdep_ids.push(subdep.id);
                            subdep_names.push(subdep.name);
                        }
                    }
                }
                // user.subdeps = subdeps;
                user.subdep_ids = subdep_ids.toString(",");;
                user.subdep_names = subdep_names.toString(",");;
            }

            //上级 下级
            if (args.show_supuser == "Y" || args.show_subuser == "Y") {
                // var supusers = [];
                var supuser_ids = [];
                var supuser_names = [];
                // var subusers = [];
                var subuser_ids = [];
                var subuser_names = [];
                var msupusers = cacheData['msupuser']; //id,org_id,user_id,leader_id
                for (var c = 0; c < msupusers.keys.length; c++) {
                    var msupuser = msupusers.values[msupusers.keys[c]];
                    if (msupuser == null) continue;
                    if (muser.id == msupuser.user_id) {
                        var supuser = null;
                        if (msupuser.leader_id != null) supuser = musers.values[msupuser.leader_id];
                        if (supuser != null) {
                            // supusers.push({ "id": supuser.id, "name": supuser.name });
                            supuser_ids.push(supuser.id);
                            supuser_names.push(supuser.name);
                        }
                    }
                    if (muser.id == msupuser.leader_id) {
                        var subuser = null;
                        if (msupuser.user_id != null) subuser = musers.values[msupuser.user_id];
                        if (subuser != null) {
                            // subusers.push({ "id": subuser.id, "name": subuser.name });
                            subuser_ids.push(subuser.id);
                            subuser_names.push(subuser.name);
                        }
                    }
                }
                if (args.show_supuser == "Y") {
                    // user.supusers = supusers;
                    user.supuser_ids = supuser_ids.toString(",")
                    user.supuser_names = supuser_names.toString(",");
                }
                if (args.show_subuser == "Y") {
                    // user.subusers = subusers;
                    user.subuser_ids = subuser_ids.toString(",")
                    user.subuser_names = subuser_names.toString(",")
                }
            }

            list.push(user);
        }
        return list;
    }, function (err, ret) {
        cb(ret, err);
        return;
    });
};

/**
 * 获取用户信息
 * @param {*} req 
 * @param {*} args 
 * user_id 职员编号
 * show_main 显示主职 show_deps 显示兼职 
 * show_subdeps 显示分管 show_roles 显示角色 show_supuser 显示上级 show_subuser 显示下属
 * @param {*} cb 
 */
Cache.prototype.getMUser = function (req, args, cb) {
    var self = this;
    if (!args.user_id) {
        cb({}, null);
        return;
    }

    req.session.cache.exec(args, function (cacheData, args) {
        var musers = cacheData['user']; //id,org_id,code,name,loginname,password,mobile,email,motto,sex,post,nickname,tel_short,tel_work,tel_home,tel_other,head_code,theme
        var mdeps = cacheData['mdep']; //id,org_id,code,name,company_sign,external_sign,parent_id,company_id,parent_ids
        var mposts = cacheData['mpost']; //id,org_id,code,name,parent_id,parent_ids
        var mlevels = cacheData['mlevel']; //id,org_id,code,name
        var mroles = cacheData['mrole']; //id,org_id,code,name

        var mdepposts = cacheData['mdeppost']; //id,org_id,order_number,user_id,dep_id,post_id,level_id
        // var mownroles = cacheData['mownrole']; //id,org_id,user_id,role_id,is_admin
        // var msubdeps = cacheData['msubdep']; //id,org_id,order_number,user_id,dep_id,layer_id
        // var msupusers = cacheData['msupuser']; //id,org_id,user_id,leader_id

        var muser = musers.values[args.user_id];
        var user = {};
        user.org_id = muser.org_id;
        // user.id = muser.id;
        // user.code = muser.code;
        // user.name = muser.name;
        user.userId = muser.id; //user.id = muser.id;
        user.userCode = muser.code; //user.code = muser.code;
        user.userName = muser.name; //user.name = muser.name;
        user.loginname = muser.loginname;
        user.mobile = muser.mobile;
        user.email = muser.email;
        user.sex = muser.sex;
        user.nickname = muser.nickname;
        user.head_code = muser.head_code;
        user.head_id = muser.head_id;

        //部门
        var maindep_id = null;
        var mainpost_id = null;
        var mainlevel_id = null;
        // var condeps = [];
        var condep_ids = [];
        var condep_names = [];
        for (var j = 0; j < mdepposts.keys.length; j++) {
            var mdeppost = mdepposts.values[mdepposts.keys[j]];
            if (mdeppost == null) continue;
            if (muser.id == mdeppost.user_id) {
                //主职
                if (args.show_main != "N") {
                    if (mdeppost.order_number == 1) {
                        maindep_id = mdeppost.dep_id;
                        mainpost_id = mdeppost.post_id;
                        mainlevel_id = mdeppost.level_id;
                        var maindep = null;
                        if (maindep_id != null) maindep = mdeps.values[maindep_id];
                        if (maindep != null) {
                            // user.dep = {
                            //     "dep_id": maindep.id, "dep_code": maindep.code, "dep_name": maindep.name,
                            //     "com_id": maindep.com_id, "parent_id": maindep.parent_id, "parent_ids": maindep.parent_ids
                            // };
                            // user.dep_id = maindep.id;
                            // user.dep_code = maindep.code;
                            // user.dep_name = maindep.name;
                            // user.com_id = maindep.com_id;
                            // user.parent_id = maindep.parent_id;
                            // user.parent_ids = maindep.parent_ids;
                            user.depId = maindep.id; //user.dep_id = maindep.id;
                            user.depCode = maindep.code; //user.dep_code = maindep.code;
                            user.depName = maindep.name; //user.dep_name = maindep.name;
                            var t_com = null;
                            if (maindep.company_id > 0) t_com = mdeps.values[maindep.company_id];
                            if (t_com != null) {
                                user.comId = t_com.id;
                                user.comCode = t_com.code;
                                user.comName = t_com.name;
                            }
                            else {
                                user.comId = maindep.company_id;
                                user.comCode = "";
                                user.comName = "";
                            }
                            var t_parent = null;
                            if (maindep.parent_id > 0) t_parent = mdeps.values[maindep.parent_id];
                            if (t_parent != null) {
                                user.parentId = t_parent.id;
                                user.parentCode = t_parent.code;
                                user.parentName = t_parent.name;
                            }
                            else {
                                user.parentId = maindep.parent_id;
                                user.parentCode = "";
                                user.parentName = "";
                            }
                            user.parentIds = maindep.parent_ids; //user.parent_ids = maindep.parent_ids;
                        }
                        var mainpost = null;
                        if (mainpost_id != null) mainpost = mposts.values[mainpost_id];
                        if (mainpost != null) {
                            // user.post = {
                            //     "post_id": mainpost.id, "post_code": mainpost.code, "post_name": mainpost.name
                            // };
                            // user.post_id = mainpost.id;
                            // user.post_code = mainpost.code;
                            // user.post_name = mainpost.name;
                            user.postId = mainpost.id; // user.post_id = mainpost.id;
                            user.postCode = mainpost.code; //user.post_code = mainpost.code;
                            user.postName = mainpost.name; //user.post_name = mainpost.name;
                        }
                        var mainlevel = null;
                        if (mainlevel_id != null) mainlevel = mlevels.values[mainlevel_id];
                        if (mainlevel != null) {
                            // user.level = {
                            //     "level_id": mainlevel.id, "level_code": mainlevel.code, "level_name": mainlevel.name
                            // };
                            // user.level_id = mainlevel.id;
                            // user.level_name = mainlevel.name;
                            // user.level_code = mainlevel.code;
                            user.levelId = mainlevel.id; //user.level_id = mainlevel.id;
                            user.levelName = mainlevel.name; //user.level_name = mainlevel.name;
                            user.levelCode = mainlevel.code; //user.level_code = mainlevel.code;
                        }
                    }
                }

                //兼职
                if (args.show_deps != "N") {
                    var condep = null;
                    if (mdeppost.dep_id != null) condep = mdeps.values[mdeppost.dep_id];
                    if (condep != null) {
                        // condeps.push({ "id": condep.id, "name": condep.name });
                        condep_ids.push(condep.id);
                        condep_names.push(condep.name);
                    }
                }
            }
        }

        if (args.show_deps != "N") {
            // user.deps = condeps;
            // user.dep_ids = condep_ids.toString(",");
            // user.dep_names = condep_names.toString(",");
            user.depIds = condep_ids.toString(","); //user.dep_ids = condep_ids.toString(",");
            user.depNames = condep_names.toString(","); //user.dep_names = condep_names.toString(",");
        }

        //角色
        if (args.show_roles == "Y") {
            // var roles = [];
            var role_ids = [];
            var role_names = [];
            var mownroles = cacheData['mownrole']; //id,org_id,user_id,role_id,is_admin
            for (var b = 0; b < mownroles.keys.length; b++) {
                var mownrole = mownroles.values[mownroles.keys[b]];
                if (mownrole == null) continue;
                if (muser.id == mownrole.user_id) {
                    var role = null;
                    if (mownrole.role_id != null) role = mroles.values[mownrole.role_id];
                    if (role != null) {
                        // roles.push({ "id": role.id, "name": role.name });
                        role_ids.push(role.id);
                        role_names.push(role.name);
                    }
                }
            }
            // user.roles = roles;
            // user.role_ids = role_ids.toString(",");
            // user.role_names = role_names.toString(",");
            user.roleIds = role_ids.toString(","); //user.role_ids = role_ids.toString(",");
            user.roleNames = role_names.toString(","); //user.role_names = role_names.toString(",");
        }

        //分管
        if (args.show_subdeps == "Y") {
            // var subdeps = [];
            var subdep_ids = [];
            var subdep_names = [];
            var msubdeps = cacheData['msubdep']; //id,org_id,order_number,user_id,dep_id,layer_id
            for (var a = 0; a < msubdeps.keys.length; a++) {
                var msubdep = msubdeps.values[msubdeps.keys[a]];
                if (msubdep == null) continue;
                if (muser.id == msubdep.user_id) {
                    var subdep = null;
                    if (msubdep.dep_id != null) subdep = mdeps.values[msubdep.dep_id];
                    if (subdep != null) {
                        // subdeps.push({ "id": subdep.id, "name": subdep.name });
                        subdep_ids.push(subdep.id);
                        subdep_names.push(subdep.name);
                    }
                }
            }
            // user.subdeps = subdeps;
            // user.subdep_ids = subdep_ids.toString(",");
            // user.subdep_names = subdep_names.toString(",");
            user.subdepIds = subdep_ids.toString(","); //user.subdep_ids = subdep_ids.toString(",");
            user.subdepNames = subdep_names.toString(","); //user.subdep_names = subdep_names.toString(",");
        }

        //上级 下级
        if (args.show_supuser == "Y" || args.show_subuser == "Y") {
            // var supusers = [];
            var supuser_ids = [];
            var supuser_names = [];
            // var subusers = [];
            var subuser_ids = [];
            var subuser_names = [];
            var msupusers = cacheData['msupuser']; //id,org_id,user_id,leader_id
            for (var c = 0; c < msupusers.keys.length; c++) {
                var msupuser = msupusers.values[msupusers.keys[c]];
                if (msupuser == null) continue;
                if (muser.id == msupuser.user_id) {
                    var supuser = null;
                    if (msupuser.leader_id != null) supuser = musers.values[msupuser.leader_id];
                    if (supuser != null) {
                        // supusers.push({ "id": supuser.id, "name": supuser.name });
                        supuser_ids.push(supuser.id);
                        supuser_names.push(supuser.name);
                    }
                }
                if (muser.id == msupuser.leader_id) {
                    var subuser = null;
                    if (msupuser.user_id != null) subuser = musers.values[msupuser.user_id];
                    if (subuser != null) {
                        // subusers.push({ "id": subuser.id, "name": subuser.name });
                        subuser_ids.push(subuser.id);
                        subuser_names.push(subuser.name);
                    }
                }
            }
            if (args.show_supuser == "Y") {
                // user.supusers = supusers;
                // user.supuser_ids = supuser_ids.toString(",");
                // user.supuser_names = supuser_names.toString(",");
                user.supuserIds = supuser_ids.toString(","); //user.supuser_ids = supuser_ids.toString(",");
                user.supuserNames = supuser_names.toString(","); //user.supuser_names = supuser_names.toString(",");
            }
            if (args.show_subuser == "Y") {
                // user.subusers = subusers;
                // user.subuser_ids = subuser_ids.toString(",");
                // user.subuser_names = subuser_names.toString(",");
                user.subuserIds = subuser_ids.toString(","); //user.subuser_ids = subuser_ids.toString(",");
                user.subuserNames = subuser_names.toString(","); //user.subuser_names = subuser_names.toString(",");
            }
        }

        return user;
    }, function (err, ret) {
        cb(ret, err);
    });
};

/**
 * 添加用户
 * @param {*} req 
 * @param {*} args 
 * user deppost ownrole
 * @param {*} cb 
 * null err
 */
Cache.prototype.insertMUser = function (req, args, cb) {
    //用户
    var user = {
        "id": args.user.id,
        "org_id": args.user.org_id,
        "code": args.user.code,
        "name": args.user.name,
        "loginname": args.user.loginname,
        "password": args.user.password,
        "sex": args.user.sex,
        "mobile": args.user.mobile,
        "email": args.user.email,
        // "motto": args.user.motto,
        // "post": args.user.post,
        // "nickname": args.user.nickname,s
        "tel_short": args.user.tel_short,
        "tel_work": args.user.tel_work,
        "tel_home": args.user.tel_home,
        "tel_other": args.user.tel_other,
        "head_code": args.user.head_code,
        "theme": args.user.theme,
    };
    req.session.cache.set("user", user.id, user, false, function (err) {
        if (err) {
            cb(null, err);
            return;
        }
        req.session.cache.sort("user", function (err1) {
            if (err1) {
                cb(null, err1);
                return;
            }
            //用户任职
            var deppost = {
                "id": args.deppost.id,
                "org_id": args.deppost.org_id,
                "order_number": args.deppost.order_number,
                "user_id": args.deppost.user_id,
                "dep_id": args.deppost.dep_id,
                "post_id": args.deppost.post_id,
                "level_id": args.deppost.level_id
            };
            req.session.cache.set("mdeppost", deppost.id, deppost, false, function (errd) {
                if (errd) {
                    cb(null, errd);
                    return;
                }
                //用户角色
                var ownrole = {
                    "id": args.ownrole.id,
                    "org_id": args.ownrole.org_id,
                    "user_id": args.ownrole.user_id,
                    "role_id": args.ownrole.role_id,
                    "is_admin": args.ownrole.is_admin
                };
                req.session.cache.set("mownrole", ownrole.id, ownrole, false, function (errr) {
                    if (errr) {
                        cb(null, errr);
                        return;
                    }
                    cb(null);
                    return;
                });
            });
        });
    });
};

/**
 * 职员在职
 * @param {*} req 
 * @param {*} args 
 * user deppost ownrole
 * @param {*} cb 
 * null err
 */
Cache.prototype.enableMUser = function (req, args, cb) {
    //用户
    var user = {
        "id": args.user.id,
        "org_id": args.user.org_id,
        "code": args.user.code,
        "name": args.user.name,
        "loginname": args.user.loginname,
        "password": args.user.password,
        "sex": args.user.sex,
        "mobile": args.user.mobile,
        "email": args.user.email,
        // "motto": args.user.motto,
        // "post": args.user.post,
        // "nickname": args.user.nickname,s
        "tel_short": args.user.tel_short,
        "tel_work": args.user.tel_work,
        "tel_home": args.user.tel_home,
        "tel_other": args.user.tel_other,
        "head_code": args.user.head_code,
        "theme": args.user.theme,
    };
    req.session.cache.set("user", user.id, user, false, function (err) {
        if (err) {
            cb(null, err);
            return;
        }
        req.session.cache.sort("user", function (err1) {
            if (err1) {
                cb(null, err1);
                return;
            }
            cb(null);
            return;
        });
    });
};

/**
 * 修改用户
 * @param {*} req 
 * @param {*} args 
 * user
 * @param {*} cb 
 * null err
 */
Cache.prototype.updateMUser = function (req, args, cb) {
    //用户
    var user = {
        // "id": args.user.id,
        "org_id": args.user.org_id,
        "code": args.user.code,
        "name": args.user.name,
        "loginname": args.user.loginname,
        "sex": args.user.sex,
        "mobile": args.user.mobile,
        "email": args.user.email,
        "tel_short": args.user.tel_short,
        "tel_work": args.user.tel_work,
        "tel_home": args.user.tel_home,
        "tel_other": args.user.tel_other
    };
    req.session.cache.set("user", args.user.id, user, true, function (err) {
        if (err) {
            cb(null, err);
            return;
        }
        req.session.cache.sort("user", function (err1) {
            if (err1) {
                cb(null, err1);
                return;
            }
            cb(null);
            return;
        });
    });
};

/**
 * 删除用户
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 */
Cache.prototype.deleteMUser = function (req, args, cb) {
    req.session.cache.del("user", "[" + args.id + "].contains(#{id})", function (err) {
        cb(null, err);
    });
};

/**
 * 单位
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 * org err
 */
Cache.prototype.getMOrg = function (req, args, cb) {
    req.session.cache.getCurOrg(function (org) {
        if (!org) {
            cb(null, "未找到组织信息！");
            return;
        }
        cb(org);
    });
};

/**
 * 部门列表
 * @param {*} req 
 * @param {*} args 
 * company_id parent_id company_sign external_sign keyword within_id without_id is_all
 * @param {*} cb 
 * list msg
 */
Cache.prototype.getListMDep = function (req, args, cb) {
    var self = this;
    var where = "#{org_id}==" + req.session.orgId;
    if (args.company_id != null) {
        where += " && #{company_id}==" + args.company_id;
    }
    if (args.parent_id != null) {
        where += " && #{parent_id}==" + args.parent_id;
    } else {
        if (args.is_all == null) where += " && #{parent_id}==0";
    }
    if (args.company_sign != null) {
        where += " && #{company_sign}==" + args.company_sign;
    }
    if (args.external_sign != null) {
        where += " && #{external_sign}==" + args.external_sign;
    }
    if (args.keyword != null) {
        where += " && (#{name}.indexOf('" + args.keyword + "')>0 || #{code}.indexOf('" + args.keyword + "')>0)";
    }
    if (args.within_id != null) {
        where += " && parent_ids.indexOf('," + args.within_id + ",')>=0";
    }
    if (args.without_id != null) {
        where += " && parent_ids.indexOf('," + args.within_id + ",')<0";
    }

    req.session.cache.getList("dep", { "where": where }, function (err, list) {
        cb(list, err);
        return;
    });
};

/**
 * 添加部门
 * @param {*} req 
 * @param {*} args 
 * dep
 * @param {*} cb 
 * null err
 */
Cache.prototype.insertMDep = function (req, args, cb) {
    //fullname,shortname
    var dep = {
        "id": args.dep.id,
        "org_id": args.dep.org_id,
        "code": args.dep.code,
        "name": args.dep.name,
        "company_sign": args.dep.company_sign,
        "external_sign": args.dep.external_sign,
        "parent_id": args.dep.parent_id,
        "company_id": args.dep.company_id,
        "parent_ids": args.dep.parent_ids
    };
    req.session.cache.set("mdep", dep.id, dep, false, function (err) {
        if (null, err) {
            cb(null, err);
            return;
        }
        req.session.cache.sort("mdep", function (err1) {
            if (err1) {
                cb(null, err1);
                return;
            }
            cb(null);
            return;
        });
    });
};

/**
 * 修改部门
 * @param {*} req 
 * @param {*} args 
 * dep o_dep
 * @param {*} cb 
 * null err
 */
Cache.prototype.updateMDep = function (req, args, cb) {
    var params = [];
    var obj0 = {};
    obj0.modelName = 'mdep';
    obj0.key = args.dep.id;
    obj0.value = {
        //"id": args.dep.id,
        "org_id": args.dep.org_id,
        "code": args.dep.code,
        "name": args.dep.name,
        "company_sign": args.dep.company_sign,
        "external_sign": args.dep.external_sign,
        "parent_id": args.dep.parent_id
    };

    if (args.o_dep.parent_id != args.dep.parent_id || args.o_dep.company_sign != args.dep.company_sign) {
        obj0.value.company_id = args.dep.company_id;
        obj0.value.parent_ids = args.dep.parent_ids;
        obj0.dynamicUpdate = true;
        params.push(obj0);
        req.session.cache.getList("mdep", {
            "fields": "id,company_sign,parent_ids",
            "where": "#{org_id}==" + args.dep.org_id + " && #{id}!=" + args.dep.id + " && #{parent_ids}.indexOf('," + args.dep.id + ",')>=0"
        }, function (err0, objs) {
            if (err0) {
                cb(null, err0);
                return;
            }

            for (var i = 0; i < objs.length; i++) {
                var obj = {};
                obj.modelName = 'mdep';
                obj.key = objs[i].id;
                obj.value = {
                    "parent_ids": objs[i].parent_ids.replace(args.o_dep.parent_ids, args.dep.parent_ids)
                }
                if (args.dep.company_sign == 0) {
                    obj.value.company_sign = 0;
                    obj.value.company_id = args.dep.company_id;
                } else {
                    if (objs[i].company_sign == 0) obj.value.company_id = args.dep.company_id;
                }
                obj.dynamicUpdate = true;
                params.push(obj);
            }

            req.session.cache.mset(params, function (err) {
                if (err) {
                    cb(null, err);
                    return;
                }

                req.session.cache.sort("mdep", function (err1) {
                    if (err1) {
                        cb(null, err1);
                        return;
                    }
                    cb(null);
                    return;
                });
            });
        });
    } else {
        obj0.dynamicUpdate = true;
        params.push(obj0);

        req.session.cache.mset(params, function (err) {
            if (err) {
                cb(null, err);
                return;
            }

            req.session.cache.sort("mdep", function (err1) {
                if (err1) {
                    cb(null, err1);
                    return;
                }
                cb(null);
                return;
            });
        });
    }
};

/**
 * 删除部门
 * @param {*} req 
 * @param {*} args
 * id 
 * @param {*} cb 
 * null err
 */
Cache.prototype.deleteMDep = function (req, args, cb) {
    req.session.cache.del("mdep", args.id, function (err) {
        cb(null, err);
    });
};

/**
 * 查询部门
 * @param {*} req 
 * @param {*} args
 * id 
 * @param {*} cb 
 * null err
 */
Cache.prototype.getMDep = function (req, args, cb) {
    req.session.cache.get("dep", args.id, function (err, ret) {
        if (err) {
            cb(null, err);
            return;
        }
        cb(ret, err);
    });
};


/**
 * 岗位列表
 * @param {*} req 
 * @param {*} args 
 * parent_id keyword within_id without_id is_all
 * @param {*} cb 
 * list
 */
Cache.prototype.getListMPost = function (req, args, cb) {
    var self = this;
    var where = "#{org_id}==" + req.session.orgId;
    if (args.parent_id != null) {
        where += " && #{parent_id}==" + args.parent_id;
    } else {
        if (args.is_all == null) where += " && #{parent_id}==0";
    }
    if (args.keyword != null) {
        where += " && (#{name}.indexOf('" + args.keyword + "')>0 || #{code}.indexOf('" + args.keyword + "')>0)";
    }
    if (args.within_id != null) {
        where += " && parent_ids.indexOf('," + args.within_id + ",')>=0";
    }
    if (args.without_id != null) {
        where += " && parent_ids.indexOf('," + args.within_id + ",')<0";
    }

    req.session.cache.getList("mpost", { "where": where }, function (err, list) {
        cb(list, err);
        return;
    });
};

/**
 * 添加岗位
 * @param {*} req 
 * @param {*} args 
 * post
 * @param {*} cb 
 * null err
 */
Cache.prototype.insertMPost = function (req, args, cb) {
    var post = {
        "id": args.post.id,
        "org_id": args.post.org_id,
        "code": args.post.code,
        "name": args.post.name,
        "parent_id": args.post.parent_id,
        "parent_ids": args.post.parent_ids
    };
    req.session.cache.set("mpost", post.id, post, false, function (err) {
        if (null, err) {
            cb(null, err);
            return;
        }
        req.session.cache.sort("mpost", function (err1) {
            if (err1) {
                cb(null, err1);
                return;
            }
            cb(null);
            return;
        });
    });
};

/**
 * 修改岗位
 * @param {*} req 
 * @param {*} args 
 * post o_post
 * @param {*} cb 
 * null err
 */
Cache.prototype.updateMPost = function (req, args, cb) {
    var params = [];
    var obj0 = {};
    obj0.modelName = 'mpost';
    obj0.key = args.post.id;
    obj0.value = {
        //"id": args.post.id,
        "org_id": args.post.org_id,
        "code": args.post.code,
        "name": args.post.name,
        "parent_id": args.post.parent_id
    };

    if (args.o_post.parent_id != args.post.parent_id) {
        obj0.value.parent_ids = args.post.parent_ids;
        obj0.dynamicUpdate = true;
        params.push(obj0);
        req.session.cache.getList("mpost", {
            "fields": "id,parent_ids",
            "where": "#{org_id}==" + args.post.org_id + " && #{id}!=" + args.post.id + " && #{parent_ids}.indexOf('," + args.post.id + ",')>=0"
        }, function (err0, objs) {
            if (err0) {
                cb(null, err0);
                return;
            }

            for (var i = 0; i < objs.length; i++) {
                var obj = {};
                obj.modelName = 'mpost';
                obj.key = objs[i].id;
                obj.value = {
                    "parent_ids": objs[i].parent_ids.replace(args.o_post.parent_ids, args.post.parent_ids)
                }
                obj.dynamicUpdate = true;
                params.push(obj);
            }

            req.session.cache.mset(params, function (err) {
                if (err) {
                    cb(null, err);
                    return;
                }

                req.session.cache.sort("mpost", function (err1) {
                    if (err1) {
                        cb(null, err1);
                        return;
                    }
                    cb(null);
                    return;
                });
            });
        });
    } else {
        obj0.dynamicUpdate = true;
        params.push(obj0);

        req.session.cache.mset(params, function (err) {
            if (err) {
                cb(null, err);
                return;
            }

            req.session.cache.sort("mpost", function (err1) {
                if (err1) {
                    cb(null, err1);
                    return;
                }
                cb(null);
                return;
            });
        });
    }
};

/**
 * 删除岗位
 * @param {*} req 
 * @param {*} args
 * id 
 * @param {*} cb 
 * null err
 */
Cache.prototype.deleteMPost = function (req, args, cb) {
    req.session.cache.del("mpost", args.id, function (err) {
        cb(err);
    });
};

/**
 * 删除职员岗位
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 */
Cache.prototype.deleteMPostUser = function (req, args, cb) {
    var list = [];
    for (var i = 0; i < args.mPostUsers.length; i++) {
        var obj = {};
        obj.modelName = 'mdeppost';
        obj.key = args.mPostUsers[i].id;
        obj.value = args.mPostUsers[i];
        list.push(obj);
    }

    req.session.cache.mset(list, function (err) {
        if (err) {
            cb(err);
            return;
        }
        cb(null);
        return;
    });
};

/**
 * 级别列表
 * @param {*} req 
 * @param {*} args 
 * keyword
 * @param {*} cb 
 * list
 */
Cache.prototype.getListMLevel = function (req, args, cb) {
    var self = this;
    var where = "#{org_id}==" + req.session.orgId;

    if (req.keyword != null) {
        where += " && (#{name}.indexOf('" + args.keyword + "')>0 || #{code}.indexOf('" + args.keyword + "')>0)";
    }

    req.session.cache.getList("mlevel", { "where": where }, function (err, list) {
        cb(list, err);
    });
};

/**
 * 添加级别
 * @param {*} req 
 * @param {*} args 
 * level
 * @param {*} cb 
 * null err
 */
Cache.prototype.insertMLevel = function (req, args, cb) {
    var level = {
        "id": args.level.id,
        "org_id": args.level.org_id,
        "code": args.level.code,
        "name": args.level.name
    };
    req.session.cache.set("mlevel", level.id, level, false, function (err) {
        if (null, err) {
            cb(err);
            return;
        }
        req.session.cache.sort("mlevel", function (err1) {
            if (err1) {
                cb(null, err1);
                return;
            }
            cb(null);
            return;
        });
    });
};

/**
 * 修改级别
 * @param {*} req 
 * @param {*} args 
 * level
 * @param {*} cb 
 * null err
 */
Cache.prototype.updateMLevel = function (req, args, cb) {
    var params = [];
    var obj0 = {};
    obj0.modelName = 'mlevel';
    obj0.key = args.level.id;
    obj0.value = {
        //"id": args.level.id,
        "org_id": args.level.org_id,
        "code": args.level.code,
        "name": args.level.name
    };
    obj0.dynamicUpdate = true;
    params.push(obj0);

    req.session.cache.mset(params, function (err) {
        if (err) {
            cb(null, err);
            return;
        }

        req.session.cache.sort("mlevel", function (err1) {
            if (err1) {
                cb(null, err1);
                return;
            }
            cb(null);
            return;
        });
    });
};

/**
 * 删除级别
 * @param {*} req 
 * @param {*} args
 * id 
 * @param {*} cb 
 */
Cache.prototype.deleteMLevel = function (req, args, cb) {
    req.session.cache.del("mlevel", args.id, function (err) {
        cb(null, err);
        return;
    });
};


/**
 * 层级列表
 * @param {*} req 
 * @param {*} args 
 * keyword
 * @param {*} cb 
 * list
 */
Cache.prototype.getListMLayer = function (req, args, cb) {
    var self = this;
    var where = "#{org_id}==" + req.session.orgId;

    if (args.keyword != null) {
        where += " && (#{name}.indexOf('" + args.keyword + "')>0 || #{code}.indexOf('" + args.keyword + "')>0)";
    }

    req.session.cache.getList("mlayer", { "where": where }, function (err, list) {
        cb(list, err);
        return;
    });
};

/**
 * 添加层级
 * @param {*} req 
 * @param {*} args 
 * layer
 * @param {*} cb 
 * null err
 */
Cache.prototype.insertMLayer = function (req, args, cb) {
    var layer = {
        "id": args.layer.id,
        "org_id": args.layer.org_id,
        "code": args.layer.code,
        "name": args.layer.name
    };
    req.session.cache.set("mlayer", layer.id, layer, false, function (err) {
        if (null, err) {
            cb(err);
            return;
        }
        req.session.cache.sort("mlayer", function (err1) {
            if (err1) {
                cb(null, err1);
                return;
            }
            cb(null);
            return;
        });
    });
};

/**
 * 修改层级
 * @param {*} req 
 * @param {*} args 
 * layer
 * @param {*} cb 
 * null err
 */
Cache.prototype.updateMLayer = function (req, args, cb) {
    var params = [];
    var obj0 = {};
    obj0.modelName = 'mlayer';
    obj0.key = args.layer.id;
    obj0.value = {
        //"id": args.layer.id,
        "org_id": args.layer.org_id,
        "code": args.layer.code,
        "name": args.layer.name
    };
    obj0.dynamicUpdate = true;
    params.push(obj0);

    req.session.cache.mset(params, function (err) {
        if (err) {
            cb(null, err);
            return;
        }

        req.session.cache.sort("mlayer", function (err1) {
            if (err1) {
                cb(null, err1);
                return;
            }
            cb(null);
            return;
        });
    });
};

/**
 * 删除层级
 * @param {*} req 
 * @param {*} args
 * id 
 * @param {*} cb 
 */
Cache.prototype.deleteMLayer = function (req, args, cb) {
    req.session.cache.del("mlayer", args.id, function (err) {
        cb(null, err);
    });
};


/**
 * 删除上级
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 */
Cache.prototype.deleteMSupuser = function (req, args, cb) {
    var where = '';
    if (args.id) {
        where += "[" + args.id + "].contains(#{id})";
    }
    if (args.user_ids) {
        if (where) {
            where += '&&';
        }
        where += "[" + args.user_ids + "].contains(#{user_id})";
    }
    req.session.cache.del("msupuser", where, function (err) {
        cb(null, err);
        return;
    });
};

/**
 * 删除职员部门
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 */
Cache.prototype.deleteMDepUser = function (req, args, cb) {
    req.session.cache.del("mdeppost", "[" + args.id + "].contains(#{id})", function (err) {
        cb(null, err);
        return;
    });
};


/**
 * 添加角色
 * @param {*} req 
 * @param {*} args 
 * role 角色对象
 * role.id 角色编号
 * role.code 角色编码
 * role.name 角色名称
 * role.type_id 角色类型
 * @param {*} cb 
 */
Cache.prototype.insertMRole = function (req, args, cb) {
    var role = {
        "id": args.role.id,
        "org_id": args.role.org_id,
        "code": args.role.code,
        "name": args.role.name,
        "type_id": args.role.type_id
    };
    req.session.cache.set("mrole", role.id, role, false, function (err) {
        if (null, err) {
            cb(err);
            return;
        }
        req.session.cache.sort("mrole", function (err1) {
            if (err1) {
                cb(null, err1);
                return;
            }
            cb(null);
            return;
        });
    });
};

/**
 * 修改角色
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 */
Cache.prototype.updateMRole = function (req, args, cb) {
    var params = [];
    var obj0 = {};
    obj0.modelName = 'mrole';
    obj0.key = args.role.id;
    obj0.value = {
        "org_id": args.role.org_id,
        "code": args.role.code,
        "name": args.role.name
    };
    obj0.dynamicUpdate = true;
    params.push(obj0);

    req.session.cache.mset(params, function (err) {
        if (err) {
            cb(null, err);
            return;
        }

        req.session.cache.sort("mrole", function (err1) {
            if (err1) {
                cb(null, err1);
                return;
            }
            cb(null);
            return;
        });
    });
};

/**
 * 删除角色
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 */
Cache.prototype.deleteMRole = function (req, args, cb) {
    req.session.cache.del("mrole", args.id, function (err) {
        cb(null, err);
        return;
    });
};

/**
 * 添加用户上级
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 */
Cache.prototype.insertMSupUser = function (req, args, cb) {
    var params = [];
    if (args.mSupUsers) {
        for (var i = 0; i < args.mSupUsers.length; i++) {
            var msupuser = args.mSupUsers[i];
            params.push({
                modelName: 'msupuser',
                key: msupuser.id,
                value: JSON.parse(JSON.stringify(msupuser))
            });
        }
    }

    if (args.supuser) {
        var supuser = {
            "id": args.supuser.id,
            "org_id": args.supuser.org_id,
            "user_id": args.supuser.code,
            "leader_id": args.supuser.name
        };
        params.push({
            modelName: 'msupuser',
            key: supuser.id,
            value: supuser
        });
    }

    req.session.cache.mset(params, function (err) {
        if (err) {
            cb(null, err);
            return;
        }
        req.session.cache.sort("msupuser", function (err1) {
            if (err1) {
                cb(null, err1);
                return;
            }
            cb(null);
            return;
        });
    });
};

/**
 * 修改用户上级
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 */
Cache.prototype.updateMSupUser = function (req, args, cb) { };

/**
 * 获得用户上级
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 */
Cache.prototype.getListMRole = function (req, args, cb) { };

/**
 * 获取指定用户的角色信息
 * @param {*} req 
 * @param {*} args 
 * user_id 用户编号
 * @param {*} cb 
 */
Cache.prototype.getListMRoleByUser = function (req, args, cb) {
    req.session.cache.getList('mownrole', {
        "fields": 'role_id',
        "where": "#{user_id}==" + args.user_id,
        "order": "id asc"
    }, function (err, objs) {
        if (err) {
            cb(null, err);
            return;
        }
        if (objs.length == 0) {
            cb(null);
            return;
        }
        var roleIds = [];
        for (var i = 0; i < objs.length; i++) {
            roleIds.push(objs[i].role_id);
        }
        req.session.cache.getList('mrole', {
            "fields": 'id,org_id,type_id,code,name',
            "where": "[" + roleIds.join(',') + "].contains(#{id})",
            "order": "id asc"
        }, function (err, roles) {
            if (err) {
                cb(null, err);
                return;
            }
            cb(roles);
        });
    });
};

Cache.prototype.getMRole = function (req, args, cb) { };

Cache.prototype.getListMDepPost = function (req, args, cb) { };

Cache.prototype.getMDepPost = function (req, args, cb) { };

/**
 * 添加用户部门岗位对应
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 */
Cache.prototype.insertMDepPost = function (req, args, cb) {
    var self = this;
    var params = [];
    for (var i = 0; i < args.mDepPosts.length; i++) {
        var mdeppost = args.mDepPosts[i];
        params.push({
            modelName: 'mdeppost',
            key: mdeppost.id,
            value: JSON.parse(JSON.stringify(mdeppost))
        });
    }
    req.session.cache.mset(params, function (err) {
        if (err) {
            cb(null, err);
            return;
        }
        req.session.cache.sort("mdeppost", function (err1) {
            if (err1) {
                cb(null, err1);
                return;
            }
            cb(null);
            return;
        });
    });
};

Cache.prototype.updateMDepPost = function (req, args, cb) { };

/**
 * 删除指定部门岗位
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 */
Cache.prototype.deleteMDepPost = function (req, args, cb) {
    var where = '';
    if (args.dep_ids) {
        where = "[" + args.dep_ids + "].contains(#{dep_id})";
    }
    if (args.user_ids) {
        if (where) where += '&&';
        where += "[" + args.user_ids + "].contains(#{user_id})";
    }
    req.session.cache.del("mdeppost", where, function (err) {
        cb(null, err);
        return;
    });
};



Cache.prototype.getListMSubDep = function (req, args, cb) { };

Cache.prototype.getMSubDep = function (req, args, cb) { };

/**
 * 添加用户管辖对应
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 */
Cache.prototype.insertMSubDep = function (req, args, cb) {
    var self = this;
    var params = [];
    for (var i = 0; i < args.mSubDeps.length; i++) {
        var msubdep = args.mSubDeps[i];
        params.push({
            modelName: 'msubdep',
            key: msubdep.id,
            value: JSON.parse(JSON.stringify(msubdep))
        });
    }
    req.session.cache.mset(params, function (err) {
        if (err) {
            cb(null, err);
            return;
        }
        req.session.cache.sort("msubdep", function (err1) {
            if (err1) {
                cb(null, err1);
                return;
            }
            cb(null);
            return;
        });
    });
};

Cache.prototype.updateMSubDep = function (req, args, cb) { };

/**
 * 删除管辖
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 */
Cache.prototype.deleteMSubDep = function (req, args, cb) {
    var where = '';
    // if (args.dep_ids) {
    //     where = "[" + args.dep_ids + "].contains(#{dep_id})";
    // }
    if (args.user_ids) {
        if (where) where += '&&';
        where += "[" + args.user_ids + "].contains(#{user_id})";
    }
    req.session.cache.del("msubdep", where, function (err) {
        cb(null, err);
        return;
    });
};

/**
 * 删除上级
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 */
Cache.prototype.getListMSupUser = function (req, args, cb) {
    var where = '';
    // if (args.dep_ids) {
    //     where = "[" + args.dep_ids + "].contains(#{dep_id})";
    // }
    if (args.user_ids) {
        if (where) where += '&&';
        where += "[" + args.user_ids + "].contains(#{user_id})";
    }
    req.session.cache.del("msupuser", where, function (err) {
        cb(null, err);
        return;
    });
};

Cache.prototype.getMSupUser = function (req, args, cb) { };

Cache.prototype.getListMOwnRole = function (req, args, cb) { };

Cache.prototype.getMOwnRole = function (req, args, cb) { };

/**
 * 添加用户角色
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 */
Cache.prototype.insertMOwnRole = function (req, args, cb) {
    var self = this;
    var params = [];
    for (var i = 0; i < args.mOwnRoles.length; i++) {
        var mownrole = args.mOwnRoles[i];
        params.push({
            modelName: 'mownrole',
            key: mownrole.id,
            value: JSON.parse(JSON.stringify(mownrole))
        });
    }
    req.session.cache.mset(params, function (err) {
        if (err) {
            cb(null, err);
            return;
        }
        req.session.cache.sort("mownrole", function (err1) {
            if (err1) {
                cb(null, err1);
                return;
            }
            cb(null);
            return;
        });
    });
};

Cache.prototype.updateMOwnRole = function (req, args, cb) { };

/**
 * 删除用户角色
 * @param {*} req 
 * @param {*} args 
 * @param {*} cb 
 */
Cache.prototype.deleteMOwnRole = function (req, args, cb) {
    var where = '';
    if (args.role_ids) {
        where += "[" + args.role_ids + "].contains(#{role_id})";
    }
    if (args.user_ids) {
        if (where) where += '&&';
        where += "[" + args.user_ids + "].contains(#{user_id})";
    }
    if (args.user_id) {
        if (where) where += '&&';
        where += "#{user_id}==" + args.user_id;
    }
    if (args.role_id) {
        if (where) where += '&&';
        where += "#{role_id}==" + args.role_id;
    }
    if (!where) {
        cb(null, '请提供编号！');
        return;
    }

    // 删除角色用户
    req.session.cache.del("mownrole", where, function (err) {
        cb(null, err);
        return;
    });
};

