var util = require('util');
var Service = require('Service');
var utils = require('utils');
var uuid = require('node-uuid');
// var request = require('request');
var crypto = require('crypto');
var fs = require('fs');
var certificateobj = require('../wxPayPhone/certificate');
var Dao = require('Dao');

var PayOrder = function () {
  Service.call(this);
  this.checkLogin = false;
  this.checkAuthority = false;
  this._dao = new Dao(this);
};

util.inherits(PayOrder, Service);

module.exports = PayOrder;

PayOrder.prototype.process = function (req, res) {
  if (!req.total_fee) {
    this.onLogicError(3, "请提供付款金额！");
    return;
  }
  var self = this;
  let certificateObj = new certificateobj();
  certificateObj.getMiniProjectConfig(req, res, function (args) {
    self.mchid = args.mchid; //商户号
    self.appid = args.appid; //微信社交平台AppId（公众号/小程序/移动应用）
    self.serial_no = args.serial_no; //API证书序列号
    self.key_pem = args.key_pem;
    let params = [];
    self._dao.execute(
      `SELECT * FROM sys_app_attach where code = '${self.key_pem[0].code}'`, params,
      function (rows) {
        self.key_pem_path = rows[0].save_path;
        self.RequestPay(req, res);
      });

  })
};

/**
 * 预支付订单
 * @param {*} req 
 * @param {*} res 
 */
PayOrder.prototype.RequestPay = function (req, res) {
  var self = this;
  let out_trade_no = uuid.v1().replace(/-/g, ''); //商户生成的订单号，保证唯一
  let object = {
    "mchid": self.mchid,
    "out_trade_no": out_trade_no,
    "appid": self.appid,
    "description": "客库优选-微商城",
    "notify_url": "https://om.taskmsg.com/Service/wxPay/service/notify",
    "amount": {
      "total": Number(req.total_fee),
      "currency": "CNY"
    },
    "scene_info": {
      "payer_client_ip": "127.0.0.1",
      "h5_info": {
        "type": "Wap"
      }
    }
  }

  let method = 'POST'; //请求方式
  let pathname = '/v3/pay/transactions/h5'; //获取请求的绝对URL，并去除域名部分得到参与签名的URL
  let timestamp = Math.round(new Date().getTime() / 1000).toString(); //时间戳（单位：秒）
  let onece_str = self.GetRandomString(20); //随机字符串
  let private_key = fs.readFileSync(utils.getPath('/files' + self.key_pem_path), 'utf8'); //秘钥
  let signature = self.rsaSign(`${method}\n${pathname}\n${timestamp}\n${onece_str}\n${JSON.stringify(object)}\n`, private_key);
  let Authorization = `WECHATPAY2-SHA256-RSA2048 mchid="${self.mchid}",nonce_str="${onece_str}",timestamp="${timestamp}",signature="${signature}",serial_no="${self.serial_no}"`
  let url = `https://api.mch.weixin.qq.com/v3/pay/transactions/h5`;
  self.sendHttpRequest({
    "method": "post",
    "headers": {
      "Content-Type": 'application/json',
      "Accept": 'application/json',
      "Authorization": Authorization,
      "User-Agent": 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/63.0.3239.132 Safari/537.36'
    },
    "urlPath": url,
    "retToJson": true,
    "postdata": object
  }, function (reqHttp, resHttp, err, data) {
    if (!JSON.parse(data).h5_url) {
      self.onLogicError(1, JSON.parse(data).message);
      return;
    }
    //返回支付Url
    res.h5_url = JSON.parse(data).h5_url;
    self.end(res);
  });
};

/**
 * //获取随机字符串
 * @param {*} n 位数
 * @returns 
 */
PayOrder.prototype.GetRandomString = function (n) {
  var chars = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
    'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'
  ];
  var res = "";
  for (var i = 0; i < n; i++) {
    var id = Math.ceil(Math.random() * 35);
    res += chars[id];
  }
  return res;
};

/**
 * RSA加密
 * @param {*} content 加密串
 * @param {*} privateKey key
 * @returns 
 */
PayOrder.prototype.rsaSign = function (content, privateKey) {
  var signature = crypto.createSign('RSA-SHA256');
  signature.update(content);
  var signStr = signature.sign(privateKey, 'base64');
  return signStr;
}