var util = require('util');
var Service = require('Service');
var utils = require('utils');
var crypto = require('crypto');
var request = require('request');
var path = require('path');
var fs = require('fs');

var Notify = function () {
  Service.call(this);
  this.checkLogin = false;
};

util.inherits(Notify, Service);

module.exports = Notify;

Notify.prototype.process = function (req, res) {
  var self = this;

  //self.mchid = '1520773761'; //商户号
  //self.serial_no = '6349AF36413AA758F2A0316C17129021A6820D87'; //API证书序列号
  //self.apiv3_private_key = 'SVkIDWvPbW15pGoTBRox6JgWWReL3ZNl'; //API v3密钥

  /*
  //鉴权请求头报文，判断是否为微信支付回调
  var object_header = {
    'host': 'om.taskmsg.com:443',
    'x-real-ip': '140.207.54.74',
    'remote-host': '140.207.54.74',
    'x-forwarded-for': '140.207.54.74',
    'connection': 'close',
    'content-length': '923',
    'user-agent': 'Mozilla/4.0',
    'accept': '',
    'wechatpay-nonce': 'bAXZxVuNkjUQssElFHfqFIwPZmCHMsCD',
    'content-type': 'application/json',
    'wechatpay-serial': '18C6B7CEC1B53B5D79EB0A3F7C086F7E2BB9F4F4',
    'wechatpay-signature': 'av3JdNXBBrqB3qO1EDnW46Vjm6ehAOHCrcgE7J4RaiSnDWdLKXTyHHm6gPoDHNuB2s+6wSfa9CUkoyAjQfM40Aw70kmN/d62sh8GHm5Vbn7XiW8RojmNX/Kr+bmsmFsQPtV2nivIbnf6kL0aliRsfLdJ/sD049WO0NpjbGuxHmOL0gmIt3hzrGmFcL5i75AxixIOJulmB6r7OYUy8ZpIHEbfYBPwoUovcY+tAAHvzEu6n0o7eSUcr3HS9L8BtC7bqvG3DJu3YU1D3dduAZf39MKxFisJ2viSw3d4PYkWZsdTkeYNdDiYM/sq6z8t/BFDAlVwKBCZFg2wKXP8evFt8w==',
    'wechatpay-signature-type': 'WECHATPAY2-SHA256-RSA2048',
    'pragma': 'no-cache',
    'wechatpay-timestamp': '1678797586'
  }
  */

  //读取请求头
  var object_header = req.socket.httpRequest.headers;

  if (!object_header['wechatpay-serial']) {
    self.onLogicError(500, "证书序列号为空！");
    return;
  }
  if (!object_header['wechatpay-timestamp']) {
    self.onLogicError(500, "应答时间戳为空！");
    return;
  }
  if (!object_header['wechatpay-nonce']) {
    self.onLogicError(500, "应答随机字符串为空！");
    return;
  }
  if (!object_header['wechatpay-signature']) {
    self.onLogicError(500, "应答报文为空！");
    return;
  }

  //获取微信平台证书
  self.getCertificates(function (body) {
    //查找要验签的微信平台证书
    var certificates = JSON.parse(body).data;
    var certificate_data = null;
    for (let i = 0; i < certificates.length; i++) {
      if (certificates[i].serial_no == object_header['wechatpay-serial']) {
        certificate_data = certificates[i];
        break;
      }
    }
    if (!certificate_data) {
      self.onLogicError(500, "获取微信平台证书失败！");
      return;
    }

    //验证请求头签名（TODO）
    /*
    //时间戳（单位：秒）
    let timestamp = object_header['wechatpay-timestamp']; 
    //随机字符串
    let onece_str = object_header['wechatpay-nonce']; 
    //应答报文
    let sign = object_header['wechatpay-signature']; 
    //解码base64，转成hex，用于验签
    let buffer = Buffer.from(sign, 'base64');
    sign = buffer.toString('hex');
    //验签串
    let src = `${timestamp}\n${onece_str}\n${body}\n`;

    //验证是否存在微信平台证书
    let rootPath = '/config/wx_cert/';
    let keyPath = utils.getPath(rootPath + "/" + object_header['wechatpay-serial'] + "_public_key.pem");
    if (!fs.existsSync(keyPath)) {
      //创建证书存储路径
      if (!fs.existsSync(utils.getPath(rootPath))) fs.mkdirSync(utils.getPath(rootPath));
      //证书写入文件
      let public_cert = self.decryptAES256(certificate_data['encrypt_certificate']);
      let certPath = utils.getPath(rootPath + "/" + object_header['wechatpay-serial'] + "_public_cert.pem");
      fs.writeFileSync(certPath, public_cert);
      //获取微信平台证书公钥，用于验签

      //公钥
      let public_key = fs.readFileSync(keyPath, 'utf8');
      //验签
      let verifyature = crypto.createVerify('RSA-SHA256');
      verifyature.update(src);
      let verify_status = verifyature.verify(public_key, sign, 'hex');
      if (!verify_status) {
        self.onLogicError(500, "签名验证失败！");
        return;
      }
      self.end(res);
    } else {
      //公钥
      let public_key = fs.readFileSync(keyPath, 'utf8');
      //验签
      let verifyature = crypto.createVerify('RSA-SHA256');
      verifyature.update(src);
      let verify_status = verifyature.verify(public_key, sign, 'hex');
      if (!verify_status) {
        self.onLogicError(500, "签名验证失败！");
        return;
      }
      self.end(res);
    }
    */

    //解析支付回调信息
    var data = self.decryptAES256(req.resource);
    res.data = data;
    self.end(res);
  });

  /*
  //微信支付回调报文
  var object_body = {
    "id": "c30129a7-ae97-5c6a-807a-42b67403e35e",
    "create_time": "2023-03-10T16:00:04+08:00",
    "resource_type": "encrypt-resource",
    "event_type": "TRANSACTION.SUCCESS",
    "summary": "支付成功",
    "resource": {
      "original_type": "transaction",
      "algorithm": "AEAD_AES_256_GCM",
      "ciphertext": "tO1KX8jyfBVKBlNsz3RxyKkzqaD0C+/rPIjeIxxyGNx36jmR/NDghUAyeRoDYW2EUqwluVUw4hz+LEmpLk6hxxC7Ccw+j7/9jMOxTvWXjZ+1laG72KY1rpsCxfOsfT8T4Tz3dpOY+1Gye9aw8uZ4pd9D4TvYBo7E6RQwINR0k/DDZKvYV2LMr2XHUWdOmzdvnbHSnoMu1AGGqZmRMUJi87Xk8Dz29I3ShfCtLRSkg+CPKr4ku64y/r1IA2NcXndUZMfocBYd4RpgCeU0r+hHLT6I3rm3CXeBN7ZmiVZilh4/8WLxC2LQdalB8kVJUqg6zIjxv1ZhDrrRWMMl03yffcP9U/ADAuqi92ApsqhpnOZHfFtd6Ijz0DGHhEwD8Wsa+AD4NCFLahtbltpggOCYT4R6E5rY9StLwNkJRZSWTibgnGF4nppUsytdYasXvkb3BKCs7aQAFj+TfYSfb3Q6Zftxbf2UAaSQkFj29zsRRLfqBKrWzz7HX8/yNmm6aWP2HAk7h7RxtwtPFz3PFj8Si5JX2QrZrS9queJp49bVP3W3jCG+OTH02PZE8jxqiDxIaZc0VcHm/ZHokJlaI82Q",
      "associated_data": "transaction",
      "nonce": "D5ubuUqXgnJW"
    }
  }
  */

  /*
  //微信支付回调报文解析后的数据
  var object = {
    "mchid": "1520773761", //商户号
    "appid": "wx06777b245c090673", //AppId
    "out_trade_no": "81ba6f00bf1911edb81855957e4cf276", //商户订单号
    "transaction_id": "4200001774202303100355550579", //微信支付订单号
    "trade_type": "JSAPI", //交易类型
    "trade_state": "SUCCESS", //交易状态
    "trade_state_desc": "支付成功", //交易状态描述
    "bank_type": "OTHERS", //付款银行
    "attach": "", //附加数据
    "success_time": "2023-03-10T16:00:04+08:00", //支付完成时间
    "payer": {
      "openid": "odHcR5aonoYmZv7U3Cym5OCkaqPI" //支付人
    },
    "amount": {
      "total": 1, //总金额
      "payer_total": 1, //支付金额
      "currency": "CNY", //货币类型
      "payer_currency": "CNY" //用户支付币种
    }
  }
  */
};

/**
 * 获取微信平台证书
 * @param {*} resource 
 * @returns 
 */
Notify.prototype.getCertificates = function (cb) {
  var self = this;
  let method = 'GET'; //请求方式
  let pathname = '/v3/certificates'; //获取请求的绝对URL，并去除域名部分得到参与签名的URL
  let timestamp = Math.round(new Date().getTime() / 1000).toString(); //时间戳（单位：秒）
  let onece_str = self.GetRandomString(20); //随机字符串
  let body = "";
  let private_key = fs.readFileSync(utils.getPath('/config/wx_cert/apiclient_key.pem'), 'utf8'); //秘钥
  let signature = self.rsaSign(`${method}\n${pathname}\n${timestamp}\n${onece_str}\n${body}\n`, private_key);
  let Authorization = `WECHATPAY2-SHA256-RSA2048 mchid="${self.mchid}",nonce_str="${onece_str}",timestamp="${timestamp}",signature="${signature}",serial_no="${self.serial_no}"`
  let url = `https://api.mch.weixin.qq.com/v3/certificates`;
  request.get({
    url: url,
    method: "GET",
    headers: {
      "Content-Type": 'application/json',
      "Accept": 'application/json',
      "Authorization": Authorization,
      "User-Agent": 'https://zh.wikipedia.org/wiki/User_agent'
    }
  }, function (error, response, body) {
    console.log(response.body);
    if (error || !body) {
      self.onLogicError(500, "获取微信平台证书失败！");
      return;
    }
    cb(body);
  });
}

/**
 * AES256解密
 * algorithm = 加密方式，ciphertext = 密文，associated_data = 填充内容， nonce = 位移
 */
Notify.prototype.decryptAES256 = function (resource) {
  // KEY长度
  const AUTH_KEY_LENGTH = 16;
  // 密钥
  const key_bytes = Buffer.from(this.apiv3_private_key, 'utf8');
  // 位移
  const nonce_bytes = Buffer.from(resource.nonce, 'utf8');
  // 填充内容
  const associated_data_bytes = Buffer.from(resource.associated_data, 'utf8');
  // 密文Buffer
  const ciphertext_bytes = Buffer.from(resource.ciphertext, 'base64');
  // 计算减去16位长度
  const cipherdata_length = ciphertext_bytes.length - AUTH_KEY_LENGTH;
  // upodata
  const cipherdata_bytes = ciphertext_bytes.slice(0, cipherdata_length);
  // tag
  const auth_tag_bytes = ciphertext_bytes.slice(cipherdata_length, ciphertext_bytes.length);
  const decipher = crypto.createDecipheriv(
    'aes-256-gcm', key_bytes, nonce_bytes
  );
  decipher.setAuthTag(auth_tag_bytes);
  decipher.setAAD(Buffer.from(associated_data_bytes));

  const output = Buffer.concat([
    decipher.update(cipherdata_bytes),
    decipher.final(),
  ]);
  const outputStr = Buffer.from(output, 'utf8');
  if (outputStr) {
    return outputStr;
  } else {
    return null;
  }
}

/**
 * //获取随机字符串
 * @param {*} n 位数
 * @returns 
 */
Notify.prototype.GetRandomString = function (n) {
  var chars = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
    'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'
  ];
  var res = "";
  for (var i = 0; i < n; i++) {
    var id = Math.ceil(Math.random() * 35);
    res += chars[id];
  }
  return res;
};

/**
 * RSA加密
 * @param {*} content 加密串
 * @param {*} privateKey key
 * @returns 
 */
Notify.prototype.rsaSign = function (content, privateKey) {
  var signature = crypto.createSign('RSA-SHA256');
  signature.update(content);
  var signStr = signature.sign(privateKey, 'base64');
  console.log(signStr);
  return signStr;
}