var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');

var certificate = function () {
    this.tfp = null;
};

module.exports = certificate;

certificate.prototype.process = function (req, res) {
    var self = this;
    self.getMiniProjectConfig(req, res, function () {

    });
};

/**
 * project.config.json
 * @param {*} req 
 * @param {*} res 
 * @param {*} cb 
 */
certificate.prototype.getMiniProjectConfig = function (req, res, cb) {
    var self = this;
    var miniProjectConfigFile = utils.getPath("/app/" + req.filepath + "/setting.json");
    fs.readFile(miniProjectConfigFile, "utf-8", function (err, data) {
        var data0 = JSON.parse(data);
        var args = {};
        if (data0['wxpay'] && data0['wxpay'].mchid) {
            args.mchid = data0['wxpay'].mchid
        }
        if (data0['wxpay'] && data0['wxpay'].appid) {
            args.appid = data0['wxpay'].appid
        }
        if (data0['wxpay'] && data0['wxpay'].apiv3_key) {
            args.apiv3_key = data0['wxpay'].apiv3_key
        }
        if (data0['wxpay'] && data0['wxpay'].serial_no) {
            args.serial_no = data0['wxpay'].serial_no
        }
        if (data0['wxpay'] && data0['wxpay'].cert_p12) {
            args.cert_p12 = data0['wxpay'].cert_p12
        }
        if (data0['wxpay'] && data0['wxpay'].cert_pem) {
            args.cert_pem = data0['wxpay'].cert_pem
        }
        if (data0['wxpay'] && data0['wxpay'].key_pem) {
            args.key_pem = data0['wxpay'].key_pem
        }
        if (data0['wxpay'] && data0['wxpay'].pathArray) {
            args.pathArray = data0['wxpay'].pathArray
        }
        cb(args);
    });
};