var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');

var certificate = function () {
    this.tfp = null;
};

module.exports = certificate;

certificate.prototype.process = function (req, res) {
    var self = this;
    self.getMiniProjectConfig(req, res, function () {

    });
};

/**
 * project.config.json
 * @param {*} req 
 * @param {*} res 
 * @param {*} cb 
 */
certificate.prototype.getMiniProjectConfig = function (req, res, cb) {
    var self = this;
    var miniProjectConfigFile = utils.getPath("/app/" + req.projCode + "/config.json");
    // var miniProjectConfigFile = utils.getPath("/miniprogram/" + req.projCode + "/" + req.miniCode + "/project.config.json");
    fs.readFile(miniProjectConfigFile, "utf-8", function (err, data) {
        var data0 = JSON.parse(data);
        var args = {};
        if (data0["miniconfig"][req.miniCode] && data0["miniconfig"][req.miniCode].appid){
            args.appid = data0["miniconfig"][req.miniCode].appid;
        }
        if (data0["miniconfig"][req.miniCode] && data0["miniconfig"][req.miniCode].appsecret){
            args.appsecret = data0["miniconfig"][req.miniCode].appsecret;
        }
        if (data0["miniconfig"][req.miniCode] && data0["miniconfig"][req.miniCode].mchid){
            self.mchid = data0["miniconfig"][req.miniCode].mchid;
            args.mchid = data0["miniconfig"][req.miniCode].mchid;
        }
        if (data0["miniconfig"][req.miniCode] && data0["miniconfig"][req.miniCode].apiv3_key){
            self.apiv3_private_key = data0["miniconfig"][req.miniCode].apiv3_key;
            args.apiv3_private_key = data0["miniconfig"][req.miniCode].apiv3_key;
        }
        if (data0["miniconfig"][req.miniCode] && data0["miniconfig"][req.miniCode].serial_no){
            self.serial_no = data0["miniconfig"][req.miniCode].serial_no;
            args.serial_no = data0["miniconfig"][req.miniCode].serial_no;
        }
        if (data0["miniconfig"][req.miniCode] && data0["miniconfig"][req.miniCode].cert_p12){
            args.cert_p12 = data0["miniconfig"][req.miniCode].cert_p12;
        }
        if (data0["miniconfig"][req.miniCode] && data0["miniconfig"][req.miniCode].cert_pem){
            args.cert_pem = data0["miniconfig"][req.miniCode].cert_pem;
        }
        if (data0["miniconfig"][req.miniCode] && data0["miniconfig"][req.miniCode].key_pem){
            self.key_pem = data0["miniconfig"][req.miniCode].key_pem;
            args.key_pem = data0["miniconfig"][req.miniCode].key_pem;
        }
        if (data0["miniconfig"][req.miniCode] && data0["miniconfig"][req.miniCode].pathArray){
            args.pathArray = data0["miniconfig"][req.miniCode].pathArray;
        }
        cb(args);
    });
};


certificate.prototype.getCertificates = function (cb) {
    var self = this;
    let method = 'GET'; //请求方式
    let pathname = '/v3/certificates'; //获取请求的绝对URL，并去除域名部分得到参与签名的URL
    let timestamp = Math.round(new Date().getTime() / 1000).toString(); //时间戳（单位：秒）
    let onece_str = self.GetRandomString(20); //随机字符串
    let body = "";
    let private_key = fs.readFileSync(utils.getPath(self.key_pem), 'utf8'); //秘钥
    let signature = self.rsaSign(`${method}\n${pathname}\n${timestamp}\n${onece_str}\n${body}\n`, private_key);
    let Authorization = `WECHATPAY2-SHA256-RSA2048 mchid="${self.mchid}",nonce_str="${onece_str}",timestamp="${timestamp}",signature="${signature}",serial_no="${self.serial_no}"`
    let url = `https://api.mch.weixin.qq.com/v3/certificates`;
    request.get({
        url: url,
        method: "GET",
        headers: {
            "Content-Type": 'application/json',
            "Accept": 'application/json',
            "Authorization": Authorization,
            "User-Agent": 'https://zh.wikipedia.org/wiki/User_agent'
        }
    }, function (error, response, body) {
        console.log(response.body);
        if (error || !body) {
            self.onLogicError(500, "获取微信平台证书失败！");
            return;
        }
        cb(body);
    });
};

/**
 * AES256解密
 * algorithm = 加密方式，ciphertext = 密文，associated_data = 填充内容， nonce = 位移
 */
certificate.prototype.decryptAES256 = function (resource) {
    // KEY长度
    const AUTH_KEY_LENGTH = 16;
    // 密钥
    const key_bytes = Buffer.from(this.apiv3_private_key, 'utf8');
    // 位移
    const nonce_bytes = Buffer.from(resource.nonce, 'utf8');
    // 填充内容
    const associated_data_bytes = Buffer.from(resource.associated_data, 'utf8');
    // 密文Buffer
    const ciphertext_bytes = Buffer.from(resource.ciphertext, 'base64');
    // 计算减去16位长度
    const cipherdata_length = ciphertext_bytes.length - AUTH_KEY_LENGTH;
    // upodata
    const cipherdata_bytes = ciphertext_bytes.slice(0, cipherdata_length);
    // tag
    const auth_tag_bytes = ciphertext_bytes.slice(cipherdata_length, ciphertext_bytes.length);
    const decipher = crypto.createDecipheriv(
        'aes-256-gcm', key_bytes, nonce_bytes
    );
    decipher.setAuthTag(auth_tag_bytes);
    decipher.setAAD(Buffer.from(associated_data_bytes));

    const output = Buffer.concat([
        decipher.update(cipherdata_bytes),
        decipher.final(),
    ]);
    const outputStr = Buffer.from(output, 'utf8');
    if (outputStr) {
        return outputStr;
    } else {
        return null;
    }
};


/**
 * //获取随机字符串
 * @param {*} n 位数
 * @returns 
 */
certificate.prototype.GetRandomString = function (n) {
    var chars = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
        'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'
    ];
    var res = "";
    for (var i = 0; i < n; i++) {
        var id = Math.ceil(Math.random() * 35);
        res += chars[id];
    }
    return res;
};

/**
 * RSA加密
 * @param {*} content 加密串
 * @param {*} privateKey key
 * @returns 
 */
certificate.prototype.rsaSign = function (content, privateKey) {
    var signature = crypto.createSign('RSA-SHA256');
    signature.update(content);
    var signStr = signature.sign(privateKey, 'base64');
    console.log(signStr);
    return signStr;
}