var Service = require('Service');
var utils = require('utils');
var util = require('util');
var fs = require('fs')

// 第三方企业微信授权
var getConfigWeixin = function () {
    Service.call(this);
    this.checkLogin = false;
    this.checkAuthority = false;
};

util.inherits(getConfigWeixin, Service);

module.exports = getConfigWeixin;

getConfigWeixin.prototype.process = function (req, res) {
    if (!req.filepath) {
        this.onLogicError(1, '请提供文件路径！', req, res);
        return;
    }
    var self = this;
    fs.readFile('./app/' + req.filepath + '/setting.json', 'utf-8', function (err, data) {
        if (err){
            console.log(err);
            self.onLogicError(1, '配置文件不存在！', req, res);
            return;
        }
        if (!data) {
            self.onLogicError(1, '配置文件不存在！', req, res);
            return;
        }
        req.corpid = JSON.parse(data).wx.corpid;
        res.corpid = JSON.parse(data).wx.corpid;
        req.corpsecret = JSON.parse(data).wx.appsecret;
        req.agentid = JSON.parse(data).wx.agentid;
        res.realmName = JSON.parse(data).dd.realmName;
        if (!server.cache[req.agentId]) {
            self.getToken(req, res);
        } else {
            var wxInfo = server.cache[req.agentId];
            var oldTime = wxInfo.expires_time;
            if (oldTime) {
                var newTime = new Date().getTime();
                //判断上一次获取access_token时间是否超过7000秒，超过重新获取access_token
                if (newTime - oldTime > 7000 * 1000) {
                    self.getToken(req, res);
                } else {
                    if (wxInfo.access_token) {
                        req.access_token = wxInfo.access_token;
                        self.geturl(req, res);
                    } else {
                        self.getToken(req, res);
                    }
                }
            } else {
                self.getToken(req, res);
            }
        }
    });
}

// 获取应用token
// 每个应用有独立的secret，获取到的access_token只能本应用使用，所以每个应用的access_token应该分开来获取
getConfigWeixin.prototype.getToken = function (req, res) {
    var self = this;
    // 应用secret编号
    let url = `https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=${req.corpid}&corpsecret=${req.corpsecret}`;
    logger.log(url);
    self.sendHttpRequest({
        "method": "get",
        "urlPath": url,
        "retToJson": true
    }, function (reqHttp, resHttp, err, data) {
        data = JSON.parse(data);
        if (!err && data.errcode == 0) {
            var obj = {
                access_token: data.access_token,
                expires_time: new Date().getTime()
            }
            server.cache[req.agentId] = obj;
            req.access_token = data.access_token;
            self.geturl(req, res);
        } else {
            res.code = -1;
            res.message = data.errmsg;
            self.end(res);
        }
    });
}


// 获取临时素材
getConfigWeixin.prototype.geturl = function (req, res) {
    var self = this;
    // 应用secret编号
    let url = `https://qyapi.weixin.qq.com/cgi-bin/media/get?access_token=${req.access_token}&media_id=${req.serverId}`;
    logger.log(url);
    self.sendHttpRequest({
        "method": "get",
        "urlPath": url,
        "retToJson": true
    }, function (reqHttp, resHttp, err, data) {
        // data = JSON.parse(data);
        if (!err && data.errcode == 0) {
            // res.data = data;
            var readStream = fs.createReadStream('../../files/tmp/aaaa.jpg');
            readStream.write(data);
            readStream.end();
            readStream.on('finish',()=>{
                console.log('传输完成');
                res.data = data;
                self.end(res);
            })
        } else {
            res.code = -1;
            res.message = data.errmsg;
            self.end(res);
        }
    });
}