var Service = require('Service');
var utils = require('utils');
var util = require('util');
var fs = require('fs')

// 第三方企业微信授权
var getOauth2Weixin = function () {
    Service.call(this);
    this.checkLogin = false;
    this.checkAuthority = false;
};

util.inherits(getOauth2Weixin, Service);

module.exports = getOauth2Weixin;
getOauth2Weixin.prototype.process = function (req, res) {
    // if (!req.corpid) {
    //     this.onLogicError(1, '请提供企业ID！');
    //     return;
    // }
    // if (!req.corpsecret) {
    //     this.onLogicError(1, '请提供应用秘钥！');
    //     return;
    // }
    // if (!req.agentid) {
    //     this.onLogicError(1, '请提供应用ID！');
    //     return;
    // }
    if (!req.filepath) {
        this.onLogicError(1, '请提供文件路径！', req, res);
        return;
    }

    var self = this;
    fs.readFile('./app/' + req.filepath + '/setting.json', 'utf-8', function (err, data) {
        if (err) console.log(err);
        if (!data) {
            self.onLogicError(1, '文件不存在！', req, res);
            return;
        }
        req.corpid = JSON.parse(data).wx.corpid;
        req.corpsecret = JSON.parse(data).wx.appsecret;
        req.agentid = JSON.parse(data).wx.agentid;
        if (!server.cache[req.agentid]) {
            self.getToken(req, res);
        } else {
            var wxInfo = server.cache[req.agentid];
            var oldTime = wxInfo.expires_time;
            if (oldTime) {
                var newTime = new Date().getTime();
                //判断上一次获取access_token时间是否超过7000秒，超过重新获取access_token
                if (newTime - oldTime > 7000 * 1000) {
                    self.getToken(req, res);
                } else {
                    if (wxInfo.access_token) {
                        req.access_token = wxInfo.access_token;
                        self.getUserId(req, res);
                    } else {
                        self.getToken(req, res);
                    }
                }
            } else {
                self.getToken(req, res);
            }
        }
    });
}

// 获取应用token
// 每个应用有独立的secret，获取到的access_token只能本应用使用，所以每个应用的access_token应该分开来获取
getOauth2Weixin.prototype.getToken = function (req, res) {
    var self = this;
    // 应用secret编号
    let url = `https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=${req.corpid}&corpsecret=${req.corpsecret}`;
    logger.log(url);
    self.sendHttpRequest({
        "method": "get",
        "urlPath": url,
        "retToJson": true
    }, function (reqHttp, resHttp, err, data) {
        data = JSON.parse(data);
        if (!err && data.errcode == 0) {
            var obj = {
                access_token: data.access_token,
                expires_time: new Date().getTime()
            }
            server.cache[req.agentid] = obj;
            req.access_token = data.access_token;
            logger.log("获取应用token");
            self.getUserId(req, res);
        } else {
            res.code = -1;
            res.message = data.errmsg;
            self.end(res);
        }
    });
}
// 通过token和code获取userid
getOauth2Weixin.prototype.getUserId = function (req, res) {
    var self = this;
    let url = `https://qyapi.weixin.qq.com/cgi-bin/auth/getuserinfo?access_token=${req.access_token}&code=${req.code}`;
    self.sendHttpRequest({
        "method": "get",
        "urlPath": url,
        "retToJson": true
    }, function (reqHttp, resHttp, err, data) {
        data = JSON.parse(data);
        if (!err && data.errcode == 0) {
            req.userid = data.userid;
			req.user_ticket = data.user_ticket;
            logger.log("通过token和code获取userid");
            self.getUserInfo(req, res);
        } else {
            res.code = -1;
            res.message = data.errmsg;
            self.end(res);
        }
    });
}
// 通过userid获取用户信息
getOauth2Weixin.prototype.getUserInfo = function (req, res) {
    var self = this;
    //let url = `https://qyapi.weixin.qq.com/cgi-bin/user/get?access_token=${req.access_token}&userid=${req.userid}`;
	let url = `https://qyapi.weixin.qq.com/cgi-bin/auth/getuserdetail?access_token=${req.access_token}`;
    self.sendHttpRequest({
        "method": "post",
        "urlPath": url,
        "retToJson": true,
		"postdata":{user_ticket:req.user_ticket}	
    }, function (reqHttp, resHttp, err, data) {
        data = JSON.parse(data);
		console.log(data)
        if (!err && data.errcode == 0) {
            logger.log("通过userid获取用户信息");
            res.userid = req.userid;
            res.userinfo = data;
            self.end(res);
        } else {
            res.code = -1;
            res.message = data.errmsg;
            self.end(res);
        }
    });
}


// 根据手机号查询系统中对应信息
getOauth2Weixin.prototype.getMobileToUserInfo = function (req, res) {
    var self = this;
    var userDao = new UserDao(self);
    userDao.query({
        fields: 'id,loginname,password',
        where: "mobile='" + req.data.mobile + "' and status=0"
    }, function (rows) {
        if (rows.length > 0) {
            req.id = rows[0].id;
            req.loginname = rows[0].loginname
            req.password = rows[0].password;
            self.TestLogin(req, res);
        } else {
            res.code = -1;
            res.message = "未查询到用户信息,请联系管理员添加！";
            self.end(res);
        }
    });
}
// 模拟登录
getOauth2Weixin.prototype.TestLogin = function (req, res) {
    var self = this;
    // http请求模拟登录
    let password = req.password;
    let loginname = req.loginname;
    var body = {};
    body.loginname = loginname;
    body.password = password;
    body.clientType = 'web';
    body.ts = new Date().getTime();
    var ivData = [body.loginname, body.password, body.clientType, body.ts];
    var iv = utils.md5(JSON.stringify(ivData)).substr(0, 16);
    ivData.push(iv);
    var key = utils.md5(JSON.stringify(ivData));
    body.data = utils.encryptAES(JSON.stringify(ivData), key, iv);
    body.app = 'sys';
    body.service = 'login';
    var options = {
        method: 'POST',
        url: 'https://zcz.tongxiner.net/TaskMsgService',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify(body)

    };
    self.sendHttpRequest({
        "method": "post",
        "urlPath": options.url,
        "postdata": options,
        "retToJson": true
    }, function (reqHttp, resHttp, err, data) {
        let resp = JSON.parse(response.body);
        resp.loginname = loginname;
        resp.pwd = password;
        res = resp;
        // response.writeHead(302,{
        //     'Location': 'http://zcz.tongxiner.net:8002/#/notice/index?hideNavBar=true'
        // })
        // response.end();
        self.end(res);
    });
}