var Service = require('Service');
var utils = require('utils');
var util = require('util');
var fs = require('fs')

// 第三方企业微信授权
var getConfigWeixin = function () {
    Service.call(this);
    this.checkLogin = false;
    this.checkAuthority = false;
};

util.inherits(getConfigWeixin, Service);

module.exports = getConfigWeixin;

getConfigWeixin.prototype.process = function (req, res) {
    // if (!req.corpId) {
    //     this.onLogicError(1, '请提供企业ID！');
    //     return;
    // }
    // if (!req.corpSecret) {
    //     this.onLogicError(1, '请提供应用秘钥！');
    //     return;
    // }
    // if (!req.agentId) {
    //     this.onLogicError(1, '请提供应用ID！');
    //     return;
    // }
    if (!req.url) {
        this.onLogicError(1, '请提供url！');
        return;
    }
    if (!req.timestamp) {
        this.onLogicError(1, '请提供timestamp！');
        return;
    }
    if (!req.filepath) {
        this.onLogicError(1, '请提供文件路径！', req, res);
        return;
    }

    var self = this;
    fs.readFile('./app/' + req.filepath + '/setting.json', 'utf-8', function (err, data) {
        if (err){
            console.log(err);
            self.onLogicError(1, '配置文件不存在！', req, res);
            return;
        }
        if (!data) {
            self.onLogicError(1, '配置文件不存在！', req, res);
            return;
        }
        req.corpid = JSON.parse(data).wx.corpid;
        res.corpid = JSON.parse(data).wx.corpid;
        req.corpsecret = JSON.parse(data).wx.appsecret;
        req.agentid = JSON.parse(data).wx.agentid;
        res.realmName = JSON.parse(data).dd.realmName;
        if (!server.cache[req.agentId]) {
            self.getToken(req, res);
        } else {
            var wxInfo = server.cache[req.agentId];
            var oldTime = wxInfo.expires_time;
            if (oldTime) {
                var newTime = new Date().getTime();
                //判断上一次获取access_token时间是否超过7000秒，超过重新获取access_token
                if (newTime - oldTime > 7000 * 1000) {
                    self.getToken(req, res);
                } else {
                    if (wxInfo.access_token) {
                        req.access_token = wxInfo.access_token;
                        self.checkJsapiTicket(req, res);
                    } else {
                        self.getToken(req, res);
                    }
                }
            } else {
                self.getToken(req, res);
            }
        }
    });
}

// 获取应用token
// 每个应用有独立的secret，获取到的access_token只能本应用使用，所以每个应用的access_token应该分开来获取
getConfigWeixin.prototype.getToken = function (req, res) {
    var self = this;
    // 应用secret编号
    let url = `https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=${req.corpid}&corpsecret=${req.corpsecret}`;
    logger.log(url);
    self.sendHttpRequest({
        "method": "get",
        "urlPath": url,
        "retToJson": true
    }, function (reqHttp, resHttp, err, data) {
        data = JSON.parse(data);
        if (!err && data.errcode == 0) {
            var obj = {
                access_token: data.access_token,
                expires_time: new Date().getTime()
            }
            server.cache[req.agentId] = obj;
            req.access_token = data.access_token;
            self.checkJsapiTicket(req, res);
        } else {
            res.code = -1;
            res.message = data.errmsg;
            self.end(res);
        }
    });
}

// 验证缓存是否存在jsapi_ticket
getConfigWeixin.prototype.checkJsapiTicket = function (req, res) {
    var self = this;
    if (!server.cache[req.agentId + '_ticket']) {
        self.getJsapiTicket(req, res);
    } else {
        var wxInfo = server.cache[req.agentId + '_ticket'];
        var oldTime = wxInfo.expires_time;
        if (oldTime) {
            var newTime = new Date().getTime();
            //判断上一次获取jsapi_ticket时间是否超过7000秒，超过重新获取jsapi_ticket
            if (newTime - oldTime > 7000 * 1000) {
                self.getJsapiTicket(req, res);
            } else {
                if (wxInfo.ticket) {
                    req.ticket = wxInfo.ticket;
                    res.nonceStr = self.GetRandomString(20);
                    var ret = {
                        jsapi_ticket: req.ticket,
                        nonceStr: res.nonceStr,
                        timestamp: req.timestamp,
                        url: req.url
                    };
                    var string = self.raw(ret);
                    res.sign = self.sha1(string);
                    res.time_stamp = req.timestamp;
                    self.end(res);
                } else {
                    self.getJsapiTicket(req, res);
                }
            }
        } else {
            self.getJsapiTicket(req, res);
        }
    }
}

// 通过token获取jsapi_ticket
getConfigWeixin.prototype.getJsapiTicket = function (req, res) {
    var self = this;
    let url = `https://qyapi.weixin.qq.com/cgi-bin/get_jsapi_ticket?access_token=${req.access_token}`;
    self.sendHttpRequest({
        "method": "get",
        "urlPath": url,
        "retToJson": true
    }, function (reqHttp, resHttp, err, data) {
        data = JSON.parse(data);
        if (!err && data.errcode == 0) {
            var obj = {
                ticket: data.ticket,
                expires_time: new Date().getTime()
            }
            server.cache[req.agentId + '_ticket'] = obj;
            req.ticket = data.ticket;
            res.nonceStr = self.GetRandomString(20);
            var ret = {
                jsapi_ticket: req.ticket,
                nonceStr: res.nonceStr,
                timestamp: req.timestamp,
                url: req.url
            };
            var string = self.raw(ret);
            res.sign = self.sha1(string);
            res.time_stamp = req.timestamp;
            self.end(res);
        } else {
            res.code = -1;
            res.message = data.errmsg;
            self.end(res);
        }
    });
}

// 字符串加密成 hex 字符串
getConfigWeixin.prototype.sha1 = function (s) {
    var self = this;
    var data = new Uint8Array(self.encodeUTF8(s));
    var i, j, t;
    var l = ((data.length + 8) >>> 6 << 4) + 16, s = new Uint8Array(l << 2);
    s.set(new Uint8Array(data.buffer)), s = new Uint32Array(s.buffer);
    for (t = new DataView(s.buffer), i = 0; i < l; i++)s[i] = t.getUint32(i << 2);
    s[data.length >> 2] |= 0x80 << (24 - (data.length & 3) * 8);
    s[l - 1] = data.length << 3;
    var w = [], f = [
        function () { return m[1] & m[2] | ~m[1] & m[3]; },
        function () { return m[1] ^ m[2] ^ m[3]; },
        function () { return m[1] & m[2] | m[1] & m[3] | m[2] & m[3]; },
        function () { return m[1] ^ m[2] ^ m[3]; }
    ], rol = function (n, c) { return n << c | n >>> (32 - c); },
        k = [1518500249, 1859775393, -1894007588, -899497514],
        m = [1732584193, -271733879, null, null, -1009589776];
    m[2] = ~m[0], m[3] = ~m[1];
    for (i = 0; i < s.length; i += 16) {
        var o = m.slice(0);
        for (j = 0; j < 80; j++)
            w[j] = j < 16 ? s[i + j] : rol(w[j - 3] ^ w[j - 8] ^ w[j - 14] ^ w[j - 16], 1),
                t = rol(m[0], 5) + f[j / 20 | 0]() + m[4] + w[j] + k[j / 20 | 0] | 0,
                m[1] = rol(m[1], 30), m.pop(), m.unshift(t);
        for (j = 0; j < 5; j++)m[j] = m[j] + o[j] | 0;
    }
    t = new DataView(new Uint32Array(m).buffer);
    for (var i = 0; i < 5; i++)m[i] = t.getUint32(i << 2);

    var hex = Array.prototype.map.call(new Uint8Array(new Uint32Array(m).buffer), function (e) {
        return (e < 16 ? "0" : "") + e.toString(16);
    }).join("");
    return hex;
};

getConfigWeixin.prototype.encodeUTF8 = function (s) {
    var i, r = [], c, x;
    for (i = 0; i < s.length; i++)
        if ((c = s.charCodeAt(i)) < 0x80) r.push(c);
        else if (c < 0x800) r.push(0xC0 + (c >> 6 & 0x1F), 0x80 + (c & 0x3F));
        else {
            if ((x = c ^ 0xD800) >> 10 === 0) {//对四字节UTF-16转换为Unicode
                c = (x << 10) + (s.charCodeAt(++i) ^ 0xDC00) + 0x10000,
                    r.push(0xF0 + (c >> 18 & 0x7), 0x80 + (c >> 12 & 0x3F));
            }
            else {
                r.push(0xE0 + (c >> 12 & 0xF));
                r.push(0x80 + (c >> 6 & 0x3F), 0x80 + (c & 0x3F));
            }
        }
    return r;
};

getConfigWeixin.prototype.GetRandomString = function (n) {
    var chars = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
        'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'
    ];
    var res = "";
    for (var i = 0; i < n; i++) {
        var id = Math.ceil(Math.random() * 35);
        res += chars[id];
    }
    return res;
};

getConfigWeixin.prototype.raw = function (args) {
    var keys = Object.keys(args);
    keys = keys.sort();
    var newArgs = {};
    keys.forEach(function (key) {
        newArgs[key.toLowerCase()] = args[key];
    });
    var string = '';
    for (var k in newArgs) {
        string += '&' + k + '=' + newArgs[k];
    }
    string = string.substr(1);
    return string;
};