var Service = require('Service');
var util = require('util');
var utils = require('utils');
var WeixinBl = require('../../bll/WeixinBl');
var IntroductionBl = require('../../bll/IntroductionBl');

var GetPhoneNumber = function () {
  Service.call(this);
  this.checkLogin = false;
  this.sqlInject.exclude = ["encryptedData"];
  this.xssInject.exclude = ["encryptedData"];
};

util.inherits(GetPhoneNumber, Service);

module.exports = GetPhoneNumber;

/**
 * 处理服务请求
 * js_code 
 * @param  {object} req 服务请求对象
 * @param  {object} res 服务响应对象
 */
GetPhoneNumber.prototype.process = function (req, res) {
  var self = this;
  var weixinBl = new WeixinBl(self);
  if (!req.phone_code) {
    console.log('decryptData');
    res.phoneNumber = weixinBl.decryptData(req.encryptedData, req.iv, req.session_key).phoneNumber;
    self.end(res);
  }
  else {
    console.log('getPhoneNumber');
    weixinBl.checkAccessToken({ "id": 1 }, function (wxobj) {
      weixinBl.getPhoneNumber({
        // "encryptedData": req.encryptedData,
        // "iv": req.iv,
        // "session_key": req.session_key,
        "phone_code": req.phone_code,
        "access_token": wxobj.access_token
      }, function (obj) {
        res.phoneNumber = obj.phoneNumber;
        self.end(res);
      });
    });

    // var introductionBl = new IntroductionBl(self);
    // introductionBl.get({ "id": 1 }, function (data) {
    //   if (!data || !data.access_token || !data.access_time || data.access_time < new Date()) {
    //     weixinBl.getAccessToken({}, function (wxobj) {
    //       data = wxobj;
    //       introductionBl.update({
    //         "id": 1,
    //         "access_token": wxobj.access_token,
    //         "expires_in": wxobj.expires_in,
    //         "access_time": wxobj.access_time,
    //       }, function () {
    //         weixinBl.getPhoneNumber({
    //           "encryptedData": req.encryptedData,
    //           "iv": req.iv,
    //           "session_key": req.session_key,
    //           "phone_code": req.phone_code,
    //           "access_token": data.access_token
    //         }, function (obj) {
    //           res.phoneNumber = obj.phoneNumber;
    //           self.end(res);
    //         });
    //       });
    //     });
    //   }
    //   else {
    //     weixinBl.getPhoneNumber({
    //       "encryptedData": req.encryptedData,
    //       "iv": req.iv,
    //       "session_key": req.session_key,
    //       "phone_code": req.phone_code,
    //       "access_token": data.access_token
    //     }, function (obj) {
    //       res.phoneNumber = obj.phoneNumber;
    //       self.end(res);
    //     });
    //   }
    // });

  }
};

