var Service = require('Service');
var util = require('util');
var utils = require('utils');
var WeixinBl = require('../../bll/WeixinBl');

var GetAccessToken = function () {
  Service.call(this);
  this.checkLogin = false;
};

util.inherits(GetAccessToken, Service);

module.exports = GetAccessToken;

/**
 * 处理服务请求
 * @param  {object} req 服务请求对象
 * @param  {object} res 服务响应对象
 */
GetAccessToken.prototype.process = function (req, res) {
  var self = this;

  var weixinBl = new WeixinBl(self);
  weixinBl.getAccessToken({}, function (wxobj) {
    res.access_token = wxobj.access_token;
    res.expires_in = wxobj.expires_in;
    res.access_time = wxobj.access_time;
    self.end(res);
  });
};
