var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');

var Code2Session = function () {
  Service.call(this);
  this.checkLogin = false;

  this.appid = "";
  this.appsecret = "";
  this.url_code2Session = "https://api.weixin.qq.com/sns/jscode2session";
};

util.inherits(Code2Session, Service);

module.exports = Code2Session;

/**
 * 处理服务请求
 * @param  {object} req 服务请求对象
 * @param  {object} res 服务响应对象
 */
Code2Session.prototype.process = function (req, res) {
  var self = this;
  self.getProjectConfig(req, function () {
    console.log(self)
    var urlPath = self.url_code2Session + "?appid=" + self.appid + "&secret=" + self.appsecret + "&js_code=" + req.code + "&grant_type=authorization_code";
    self.sendHttpRequest({
      "method": "get",
      "urlPath": urlPath,
      "retToJson": true
    }, function (reqHttp, resHttp, err, data) {
      if(typeof(data) == 'string'){
        data = JSON.parse(data);
      }
      res.sessionKey = data.session_key;
      res.openId = data.openid;
      res.unionId = data.unionid;
      self.end(res);
    });
  });
};


/**
 * 
 * @param {*} req 
 * @param {*} cb 
 */
Code2Session.prototype.getProjectConfig = function (req, cb) {
  var self = this;
  var projectConfigFile = utils.getPath("/app/" + req.projCode + "/config.json");
  fs.readFile(projectConfigFile, "utf-8", function (err, data) {
    if (data) {
      var data0 = JSON.parse(data);
      console.log(data0.miniconfig[req.miniCode].appsecret)
      if (data0.miniconfig[req.miniCode] && data0.miniconfig[req.miniCode].appid) self.appid = data0.miniconfig[req.miniCode].appid;
      if (data0.miniconfig[req.miniCode] && data0.miniconfig[req.miniCode].appsecret) self.appsecret = data0.miniconfig[req.miniCode].appsecret;
    }
    cb();
  });
};
