var Service = require('Service');
var Dao = require('Dao');
var User = require('../../dao/user');
var util = require('util');
var crypto = require('crypto');

/**
 * 修改签章密码
 */
var UpdateSignPwd = function () {
    Service.call(this);
    this.checkAuthority = false;
    this._dao = new Dao(this);
};

util.inherits(UpdateSignPwd, Service);

module.exports = UpdateSignPwd;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
UpdateSignPwd.prototype.process = function (req, res) {
    //   if(req.serverType=='im') res.type = 'UpdateSignPwdRet';

    if (!req.userPwd) {
        this.onLogicError(1, '请提供登录密码！');
        return;
    }

    if (!req.signPwd) {
        this.onLogicError(2, '签章密码不能为空！');
        return;
    }

    if (req.signPwd.length < 4) {
        this.onLogicError(3, '签章密码长度不能小于4位！');
        return;
    }

    if (req.signPwd.length > 20) {
        this.onLogicError(4, '签章密码长度不能超过20！');
        return;
    }

    var reg = /\s|'/i;
    if (reg.test(req.signPwd)) {
        this.onLogicError(5, '签章密码不能包含单引号和空格！');
        return;
    }

    var self = this;
    var userDao = (new User(this));
    userDao.query({
        fields: 'password', where: 'org_id=' + req.session.orgId
            + ' and id=' + req.session.userId
    }, function (users) {
        if (users.length == 0) {
            self.onLogicError(4, '用户信息有误！');
            return;
        }

        //加密
        var md5 = crypto.createHash('md5');
        md5.update(req.userPwd);
        req.userPwd = md5.digest('hex');

        var user = users[0];
        if (user.password != (req.userPwd + '')) {
            self.onLogicError(5, '登录密码不正确！');
            return;
        }

        var md52 = crypto.createHash('md5');
        md52.update(req.signPwd);
        req.signPwd = md52.digest('hex');

        var signInfo = {};
        signInfo.sign_password = req.signPwd;
        let options = {
            where: "user_id=? and sign_status=0",
            params: [req.session.userId]
        };
        self._dao.model = server.loadModule('/app/sys/model/sys_user_sign.tdm');
        self._dao.update(signInfo, options, function () {
            self.end(res);
        });
    });
};