var Service = require('Service');
var User = require('../../dao/user');
var util = require('util');
var utils = require('utils');
var crypto = require('crypto');

/**
 * 修改自己的登录密码
 */
var UpdateSelfPwd = function () {
  Service.call(this);
  this.checkAuthority = false;
};

util.inherits(UpdateSelfPwd, Service);

module.exports = UpdateSelfPwd;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
UpdateSelfPwd.prototype.process = function (req, res) {
  if (server.config.Cache.type && server.config.Cache.type == 'taskmsg') {
    this.pipe(require('../../../system/service/user/updateSelfPwd'), req, res);
    return;
  }
  if (req.serverType == 'im') res.type = 'updateSelfPwdRet';

  if (!req.oldPwd) {
    this.onLogicError(1, '请提供原密码！');
    return;
  }

  if (!req.newPwd) {
    this.onLogicError(2, '新密码不能为空！');
    return;
  }

  if (req.newPwd.length < 4) {
    this.onLogicError(3, '密码长度不能小于4位！');
    return;
  }

  if (req.newPwd.length > 20) {
    this.onLogicError(4, '密码长度不能超过20！');
    return;
  }

  var reg = /\s|'/i;
  if (reg.test(req.newPwd)) {
    this.onLogicError(5, '密码不能包含单引号和空格！');
    return;
  }

  var self = this;
  var userDao = (new User(this));
  userDao.query({
    fields: 'password', where: 'org_id=' + req.session.orgId
      + ' and id=' + req.session.userId
  }, function (users) {
    if (users.length == 0) {
      self.onLogicError(4, '用户信息有误！');
      return;
    }

    //加密
    var md5 = crypto.createHash('md5');
    md5.update(req.oldPwd);
    req.oldPwd = md5.digest('hex');

    var user = users[0];
    if (user.password != (req.oldPwd + '')) {
      self.onLogicError(5, '原密码不正确！');
      return;
    }

    var md52 = crypto.createHash('md5');
    md52.update(req.newPwd);
    req.newPwd = md52.digest('hex');

    var userInfo = {};
    userInfo.password = req.newPwd;
    if (!req.fromOtherSys) userInfo.last_update_pwd = new Date();
    userDao.update(userInfo, {
      where: 'org_id=' + req.session.orgId
        + ' and id=' + req.session.userId
    }, function (ret) {
      req.session.cache.set('user', req.session.userId, { password: req.newPwd }, true, function (err) {
        if (err) {
          self.onLogicError(3, err.message);
          return;
        }
        self.end(res);
      });
    });
  });
};