var Service = require('Service');
var User = require('../../dao/user');
var util = require('util');
var utils = require('utils');

/**
 * 修改自己的个性签名
 */
var UpdateSelfMotto = function () {
    Service.call(this);
    this.checkAuthority = false;
};

util.inherits(UpdateSelfMotto, Service);

module.exports = UpdateSelfMotto;

/**
 * 处理服务请求
 * @param {Object} req 服务请求对象
 * @param {Object} res 服务响应对象
 */
UpdateSelfMotto.prototype.process = function (req, res) {
    if (server.config.Cache.type && server.config.Cache.type == 'taskmsg') {
        this.pipe(require('../../../system/service/user/updateSelfMotto'), req, res);
        return;
    }
    if (!req.motto) req.motto = null;
    var self = this;
    (new User(this)).update({
        motto: req.motto
    }, {
        where: 'id=' + req.session.userId
    }, function () {
        req.session.cache.set('user', req.session.userId, { motto: req.motto }, true, function (err) {
            if (err) {
                self.onLogicError(2, err.message);
                return;
            }
            self.end(res);
        });
    });
}