var Service = require('Service');
var utils = require('utils');
var User = require('../../dao/user');
var util = require('util');

/**
 * 修改自己的个性签名
 */
var UpdateSelfContact = function () {
  Service.call(this);
  this.checkAuthority = false;
};

util.inherits(UpdateSelfContact, Service);

module.exports = UpdateSelfContact;

/**
 * 处理服务请求
 * @param {Object} req 服务请求对象
 * @param {Object} res 服务响应对象
 */
UpdateSelfContact.prototype.process = function (req, res) {
  if (req.serverType == 'im') res.type = 'updateSelfContactRet';
  if (!('mobile' in req) && !('email' in req)) {
    this.onLogicError(1, '请提供必须的参数！');
    return;
  }
  if (!req.mobile) {
    req.mobile = null;
  } else {
    if (!utils.isPhone(req.mobile)) {
      this.onLogicError(2, '手机号格式不正确！');
      return;
    }
  }
  if (!req.email) {
    req.email = null;
  } else {
    if (!utils.isEmail(req.email)) {
      this.onLogicError(3, '电子信箱格式不正确！');
      return;
    }
  }

  var self = this;
  (new User(this)).update({
    mobile: req.mobile,
    email: req.email
  }, {
    where: 'id=' + req.session.userId
  }, function () {
    //修改缓存数据
    var args = {};
    args.user = {};
    args.user.mobile = req.mobile;
    args.user.email = req.email;
    args.userId = req.session.userId;
    self.requestIMService('sys/service/cache/updateUser',
      args, req,
      function (resIM) {
        if (resIM.code != 0) {
          self.onError(resIM);
          return;
        }
        self.end(res);
      });
  });
};