var Service = require('Service');
var utils = require('utils');
var User = require('../../dao/user');
var Org = require('../../dao/org');
var Dep_User = require('../../dao/dep_user');
var util = require('util');

/**
 * 添加用户
 */
var Update = function() { 
  Service.call(this);
};

util.inherits(Update, Service);

module.exports = Update;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Update.prototype.process =  function(req, res) {
  if(!req.loginname) {
    this.onLogicError(1, '请提供登录名！');
    return;
  }
  var reg = /^([_a-zA-Z0-9\u4E00-\u9FA5\uFE30-\uFFA0]{3,20})$/;
  if(!reg.test(req.loginname)){
    this.onLogicError(1, '登录名格式无效，只能是字母、数字、下划线或汉字，长度：3-20！', req, res);
    return; 
  }
  if(req.mobile && !utils.isPhone(req.mobile)){
    this.onLogicError(1, '请输入正确的手机号！');
    return;
  }
  if(req.email && !utils.isEmail(req.email)){
    this.onLogicError(1, '请提供有效的邮箱地址！');
    return;
  }
  if(req.email && this.strlen(req.email) > 50){
    this.onLogicError(1, '电子信箱字符长度不能超过50！');
    return;
  }
  if(req.tel_short && this.strlen(req.tel_short) > 10){
    this.onLogicError(1, '集团小号字符长度不能超过10！');
    return;
  }
  if(req.tel_work && this.strlen(req.tel_work) > 20){
    this.onLogicError(1, '工作电话字符长度不能超过20！');
    return;
  }
  if(req.tel_home && this.strlen(req.tel_home) > 20){
    this.onLogicError(1, '家庭电话字符长度不能超过20！');
    return;
  }
  if(req.tel_other && this.strlen(req.tel_other) > 20){
    this.onLogicError(1, '其他电话字符长度不能超过20！');
    return;
  }


  var self = this;
  var dao = new User(this);
  var daoDepUser = new Dep_User(this);
  dao.query({ 
    where: 'org_id='+req.session.orgId+' and id='+req.session.userId,
    fields: 'loginname'
  }, function(rows1) {
    if(rows1.length==0) {
      self.onLogicError(2, '用户不存在！');
      return;
    }
    if(rows1[0].loginname=='admin' && req.loginname!='admin') {
      self.onLogicError(3, '该用户的登录名不允许修改！');
      return;
    }
    dao.query({ 
      where: 'loginname=? and org_id='+req.session.orgId
      +' and id<>'+req.session.userId+' and status=0',
      fields: 'id',
      params: [req.loginname]
    }, function(rows) {
      if(rows.length>0) {
        self.onLogicError(4, '用户名已经存在！');
        return;
      }
      var user = {}; 
      user.loginname = req.loginname; 
      user.mobile = req.mobile;
      user.email = req.email;
      user.tel_short = req.tel_short;
      user.tel_work = req.tel_work;
      user.tel_home = req.tel_home;
      user.tel_other = req.tel_other;
      //user.motto = req.motto;
      user.nickname = req.nickname;
      dao.update(user, {where: 'id='+req.session.userId
        +' and org_id='+req.session.orgId}, function(ret) {
        req.session.cache.set('user', req.session.userId, user, true, function(err){
          if(err) {
            self.onLogicError(2, err.message);
            return;
          }
          self.end(res);
        });
      });
    });
  });
};

Update.prototype.strlen =  function(str) {
  var len = 0;
  for (var i=0; i<str.length; i++) { 
    var c = str.charCodeAt(i); 
    //单字节加1 
    if ((c >= 0x0001 && c <= 0x007e) || (0xff60<=c && c<=0xff9f)) { 
      len++; 
    } 
    else { 
      len+=2; 
    } 
  } 
  return len;
};