var Service = require('Service');
var User = require('../../dao/user');
var util = require('util');
var utils = require('utils');
var crypto = require('crypto');

/**
 * 修改密码
 */
var UpdatePwd = function() { 
  Service.call(this);
};

util.inherits(UpdatePwd, Service);

module.exports = UpdatePwd;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
UpdatePwd.prototype.process =  function(req, res) {
  if(!req.id) {
    this.onLogicError(1, '请提供用户编号！');
    return;
  }
  if(!utils.isInt(req.id)) {
    this.onLogicError(2, '请提供正确的用户编号！');
    return;
  }
  if(!req.pwd) {
    this.onLogicError(3, '请提供新密码！');
    return;
  }
  if(req.pwd.length<4) {
    this.onLogicError(3, '密码长度不能小于4位！');
    return;
  }
  if(req.pwd.length>20) {
    this.onLogicError(4, '密码长度不能超过20！');
    return;
  }
  var reg = /\s|'/i;
  if(reg.test(req.pwd)) {
    this.onLogicError(5, '密码不能包含单引号和空格！');
    return;
  }

  var self = this;
  var userDao = (new User(this));
  var userInfo = {};
  //加密
  var md5 = crypto.createHash('md5');
  md5.update(req.pwd);
  req.pwd = md5.digest('hex');
  userInfo.password = req.pwd;
  if(!req.fromOtherSys) userInfo.last_update_pwd = new Date();
  userDao.update(userInfo, {where: 'org_id='+req.session.orgId
    +' and id='+req.id}, function(ret) {
    req.session.cache.set('user', parseInt(req.id), {password: req.pwd}, true, function(err){
      if(err) {
        self.onLogicError(3, err.message);
        return;
      }
      self.end(res);
    });
  });
}