var util = require('util');
var Service = require('Service');
var utils = require('utils');
var AppAttachDao = require('../../dao/app_attach');
var UserDao = require('../../dao/user');

/**
 * 修改用户头像
 * */
var UpdateHeadManage = function() {
  Service.call(this);
};

util.inherits(UpdateHeadManage, Service);

module.exports = UpdateHeadManage;

UpdateHeadManage.prototype.process =  function(req, res) {
  if(!req.user_id) {
    this.onLogicError(1, '请提供用户编号！');
    return;
  }
  if(!utils.isInt(req.user_id)) {
    this.onLogicError(2, '请提供正确的用户编号！');
    return;
  }
  if(!req.headId) {
    this.onLogicError(3, '请提供头像编号！');
    return;
  }
  if(!utils.isInt(req.headId)) {
    this.onLogicError(4, '请提供正确的头像编号！');
    return;
  }

  var self = this;
  var dao = new UserDao(this);
  dao.update({head_id:req.headId},'id='+req.user_id
    +' and org_id='+req.session.orgId, function(){
    req.session.cache.set('user', req.user_id, 
      {head_id:req.headId}, true, function(err){
      if(err) {
        self.onLogicError(5, err.message);
        return;
      }
      self.end(res);
    });
  });
};