var util = require('util');
var Service = require('Service');
var UserDao = require('../../dao/user');
var utils = require('utils');

/**
 * 修改用户头像
 */
var UpdateHead = function() { 
  Service.call(this);
  this.checkAuthority = false;
};

util.inherits(UpdateHead, Service);

module.exports = UpdateHead;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
UpdateHead.prototype.process =  function(req, res) {
  if (server.config.Cache.type && server.config.Cache.type == 'taskmsg') {
    this.pipe(require('../../../system/service/user/updateUserHead'), req, res);
    return;
  }
  if(!req.headId) {
    this.onLogicError(1, '请提供头像编号！');
    return;
  }
  if(!utils.isInt(req.headId)) {
    this.onLogicError(4, '请提供正确的头像编号！');
    return;
  }

  var self = this;
  var dao = new UserDao(this);
  dao.update({head_id:req.headId},'id='+req.session.userId
    +' and org_id='+req.session.orgId, function(){
    req.session.cache.set('user', req.session.userId, 
      {head_id:req.headId}, true, function(err){
      if(err) {
        self.onLogicError(2, err.message);
        return;
      }
      self.end(res);
    });
  });
};