var Service = require('Service');
var utils = require('utils');
var Org = require('../../dao/org');
var Dep = require('../../dao/dep');
var User = require('../../dao/user');
var Dep_User = require('../../dao/dep_user');
var util = require('util');

/**
 * 修改用户所在部门
 */
var UpdateDep = function () {
  Service.call(this);
  this.delOldDep = false;
};

util.inherits(UpdateDep, Service);

module.exports = UpdateDep;

/**
 * 处理服务请求
 * @param {Object} req 服务请求对象
 * @param {Object} res 服务响应对象
 */
UpdateDep.prototype.process = function (req, res) {
  if (!req.userCode) {
    this.onLogicError(1, '请提供用户代码！');
    return;
  }
  if (!req.oldDepCode) {
    this.onLogicError(2, '请提供原部门代码！');
    return;
  }
  if (!req.newDepCode) {
    this.onLogicError(3, '请提供新部门代码！');
    return;
  }

  var self = this;
  var daoUser = new User(this);
  var daoDep = new Dep(this);
  var daoDepUser = new Dep_User(this);
  var user = null;
  var depNew = null;
  var depOld = null;
  daoUser.query({
    fields: 'id',
    where: 'org_id=' + req.session.org_id +
      ' and code=\'' + req.userCode + '\' and status=0'
  }, function (users) {
    if (users.length == 0) {
      self.onLogicError(4, '请提供正确的用户代码！');
      return;
    }
    user = users[0];
    daoDep.query({
      fields: 'id',
      where: 'org_id=' + req.session.org_id +
        ' and code=\'' + req.newDepCode + '\' and status=0'
    }, function (depsNew) {
      if (depsNew.length == 0) {
        self.onLogicError(4, '请提供正确的新部门代码！');
        return;
      }
      depNew = depsNew[0];
      daoDep.query({
        fields: 'id',
        where: 'org_id=' + req.session.org_id +
          ' and code=\'' + req.oldDepCode + '\' and status=0'
      }, function (depsOld) {
        var depIds = depNew.id;
        if (depsOld.length > 0) {
          depOld = depsOld[0];
          depIds += ',' + depOld.id;
        }
        daoDepUser.delete('user_id=' + user.id + ' and dep_id in (' + depIds +
          ') and org_id=' + req.session.orgId,
          function () {
            self.addDep(req, res, depOld, depNew, user, daoDepUser);
          });
      });
    });
  });
};

UpdateDep.prototype.addDep = function (req, res, depOld, depNew, user, daoDepUser) {
  var self = this;
  daoDepUser.create({
    org_id: req.session.orgId,
    dep_id: depNew.id,
    user_id: user.id,
    creater_id: req.session.userId,
    createtime: new Date()
  }, function () {
    var orgDao = new Org(self);
    orgDao.setLastUpdate(req.session.orgId, function (lastUpdate) {
      var args = {};
      args.userId = user.id;
      args.newDepId = depNew.id;
      if (depOld) args.oldDepId = depOld.id;
      self.requestIMService('sys/service/cache/updateUserDep',
        args, req,
        function (resIM) {
          if (resIM.code != 0) {
            self.onError(resIM);
            return;
          }
          self.end(res);
        });
    });
  });
};