var Service = require('Service');
var User = require('../../dao/user');
var util = require('util');
var utils = require('utils');
var crypto = require('crypto');

/**
 * 修改密码
 */
var UpdateDefaultPwd = function () {
    Service.call(this);
};

util.inherits(UpdateDefaultPwd, Service);

module.exports = UpdateDefaultPwd;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
UpdateDefaultPwd.prototype.process = function (req, res) {
    if (server.config.Cache.type && server.config.Cache.type == 'taskmsg') {
        this.pipe(require('../../../system/service/user/updateDefaultPwd'), req, res);
        return;
    }
    var self = this;
    if (!req.password) {
        this.onLogicError(1, '请提供新密码！');
        return;
    }
    if (!req.encryptionString) {
        this.onLogicError(2, '请提供用户信息！');
        return;
    }

    var encryptionString = self.decryptData(req.encryptionString, 'vKxSsJeDrNqVhBkClErUeS8H');
    var list = encryptionString.split('_');
    if (list.length != 4) {
        this.onLogicError(3, '信息错误！');
        return;
    }
    var userId = list[0];// 用户编号
    var orgId = list[1];// 组织编号
    var safety_level = list[2];// 安全等级
    var datetime = list[3];// 时间戳

    var password = self.decryptPassword(req.password, req.encryptionString.substring(0, 8));
    logger.log(password);
    if (password.length > 20) {
        this.onLogicError(4, '密码长度不能超过20！');
        return;
    }
    var reg = /\s|'/i;
    if (reg.test(password)) {
        this.onLogicError(5, '密码不能包含单引号和空格！');
        return;
    }

    if (new Date().getTime() - parseInt(datetime) > (10 * 60 * 1000)) {
        this.onLogicError(4, '已超时，请重新登录！');
        return;
    }

    var list1 = ['a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'];
    // var list2 = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'];
    var list2 = list1;
    var list3 = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
    var list4 = ['!', '@', '#', '$', '%', '^', '&', '*', '?', '\\'];
    if (safety_level == '0') {
        // 四位
        if (password.length < 4) {
            this.onLogicError(5, '密码长度不能小于4位！');
            return;
        }
    } else if (safety_level == '1') {
        // 六位、字母、数字
        if (password.length < 6) {
            this.onLogicError(5, '密码长度不能小于6位！');
            return;
        }
        var dBool = false;
        var xBool = false;
        var sBool = false;
        var tBool = false;
        var index = 0;
        for (var i = 0; i < password.length; i++) {
            if (list1.contains(password[i]) && !xBool) {
                xBool = true;
                index++;
            } else if (list2.contains(password[i]) && !dBool) {
                dBool = true;
                index++;
            } else if (list3.contains(password[i]) && !sBool) {
                sBool = true;
                index++;
            } else if (list4.contains(password[i]) && !tBool) {
                tBool = true;
                index++;
            }
        }
        if (index < 2) {
            this.onLogicError(6, '弱密码强度，至少含有小写字符、数字、特殊字符中的两种！');
            return;
        }
    } else if (safety_level == '2') {
        // 六位、大写字母、小写字母、数字、特殊字符
        // 六位、字母、数字
        if (password.length < 6) {
            this.onLogicError(5, '密码长度不能小于6位！');
            return;
        }
        var dBool = false;
        var xBool = false;
        var sBool = false;
        var tBool = false;
        var index = 0;
        for (var i = 0; i < password.length; i++) {
            if (list1.contains(password[i]) && !xBool) {
                xBool = true;
                index++;
            } else if (list2.contains(password[i]) && !dBool) {
                dBool = true;
                index++;
            } else if (list3.contains(password[i]) && !sBool) {
                sBool = true;
                index++;
            } else if (list4.contains(password[i]) && !tBool) {
                tBool = true;
                index++;
            }
        }
        if (index < 4) {
            this.onLogicError(6, '弱密码强度，需要含有大写字符、小写字符、数字、特殊字符！');
            return;
        }
    }

    var userDao = (new User(this));
    var userInfo = {};
    //加密
    var md5 = crypto.createHash('md5');
    md5.update(password);
    req.pwd = md5.digest('hex');
    userInfo.password = req.pwd;
    if (!req.fromOtherSys) userInfo.last_update_pwd = new Date();
    userDao.update(userInfo, {
        where: 'org_id=' + orgId + ' and id=' + userId
    }, function (ret) {
        req.session.cache.set('user', parseInt(userId), { password: req.pwd }, true, function (err) {
            if (err) {
                self.onLogicError(3, err.message);
                return;
            }
            server.sessionManager.endSession(req.sessionId, req);
            self.end(res);
        });
    });
}

/**
 * 解密用户信息
 * @param {*} data 
 * @returns 
 */
UpdateDefaultPwd.prototype.decryptData = function (data, key) {
    var k = crypto.createHash('md5').update(key).digest('hex');
    k = k.substring(0, 24);
    var decipher = crypto.createDecipheriv('des-ede3', k, Buffer.alloc(0));
    var decrypted = decipher.update(data, 'base64', 'utf8');
    decrypted += decipher.final('utf8');
    return decrypted;
};

/**
 * 解密密码
 * @param {*} data 
 * @param {*} key 
 * @returns 
 */
UpdateDefaultPwd.prototype.decryptPassword = function (data, key) {
    var decipher = crypto.createDecipheriv('des-ecb', new Buffer(key), Buffer.alloc(0));
    var decrypted = decipher.update(data, 'base64', 'utf8');
    decrypted += decipher.final('utf8');
    return decrypted;
};