var Service = require('Service');
var utils = require('utils');
var util = require('util');
var User = require('../../dao/user');
var Org = require('../../dao/org');
var Dep_User = require('../../dao/dep_user');

/**
 * 修改用户
 */
var Update = function() { 
  Service.call(this);
};

util.inherits(Update, Service);

module.exports = Update;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Update.prototype.process =  function(req, res, cb) {
  if(!req.id) {
    this.onLogicError(1, '请提供用户编号！', req, res, cb);
    return;
  }
  if(!utils.isInt(req.id)) {
    this.onLogicError(2, '请提供正确的用户编号！');
    return;
  }
  if(!req.code) {
    this.onLogicError(3, '请提供用户编码！', req, res, cb);
    return;
  }
  var reg = /^([a-zA-Z0-9]{2,10})$/;
  if(!reg.test(req.code)){
    this.onLogicError(3, '用户编码格式无效，只能是字母或数字，长度：2-10！', req, res);
    return; 
  }
  if(!req.name) {
    this.onLogicError(4, '请提供用户姓名！', req, res, cb);
    return;
  }
  reg = /^([a-zA-Z0-9\u4E00-\u9FA5\uFE30-\uFFA0]{2,10})$/;
  if(!reg.test(req.name)){
    this.onLogicError(4, '用户姓名格式无效，只能是汉字、字母或数字，长度：2-10！', req, res);
    return; 
  }
  if(!req.loginname) {
    this.onLogicError(5, '请提供登录名！', req, res, cb);
    return;
  }
  reg = /^([_a-zA-Z0-9\u4E00-\u9FA5\uFE30-\uFFA0]{3,20})$/;
  if(!reg.test(req.loginname)){
    this.onLogicError(5, '登录名格式无效，只能是字母、数字、下划线或汉字，长度：3-20！', req, res);
    return; 
  }
  if(!req.sex && req.sex!=0) {
    this.onLogicError(6, '请提供用户性别！', req, res, cb);
    return;
  }
  if(req.mobile && !utils.isPhone(req.mobile)) {
    this.onLogicError(7, '请提供正确的手机号！', req, res, cb);
    return;
  }
  
  var self = this;
  var dao = new User(this);
  var where = '';
  if(req.mobile) {
    where = '#{loginname}=="'+req.loginname+'" || #{mobile}=="'+req.mobile+'"';
  } else {
    where = '#{loginname}=="'+req.loginname+'"';
  }
  req.session.cache.exists('user', "("+where+") && #{id}!="+req.id, function(err, isExists){
    if(err) {
      self.onLogicError(7, err.message, req, res, cb);
      return;
    }
    if(isExists) {
      self.onLogicError(7, '用户名或手机号已经被使用！', req, res, cb);
      return;
    }
    req.session.cache.getList('user', {fields:'loginname',where:'#{id}=='+req.id}, function(err2, users){
      if(err2) {
        self.onLogicError(7, err2.message, req, res, cb);
        return;
      }
      console.log(users);
      if(users.length==0) {
        self.onLogicError(8, '用户不存在！', req, res, cb);
        return;
      }
      if(users[0].loginname=='admin' && req.loginname!='admin') {
        self.onLogicError(5, '该用户的登录名不允许修改！', req, res, cb);
        return;
      }

      self.updateUser(req, res, cb);
    });
  }); 
};

Update.prototype.updateUser =  function(req, res, cb) {
  var user = {};
  user.code = req.code;
  user.name = req.name; 
  user.loginname = req.loginname; 
  user.mobile = req.mobile;
  user.email = req.email;
  user.tel_short = req.tel_short;
  user.tel_work = req.tel_work;
  user.tel_home = req.tel_home;
  user.tel_other = req.tel_other;
  user.sex = parseInt(req.sex);
  user.post = req.post;
  user.nickname = user.name;
  if(req.nickname) user.nickname = req.nickname;
  
  var self = this;
  var dao = new User(this);
  dao.update(user, {where: 'id='+req.id+' and org_id='+req.session.orgId}, function(ret) {
    self.updateCache(req, res, user, cb);
  });
};

Update.prototype.updateCache =  function(req, res, user, cb) {
  var self = this;
  var orgDao = new Org(this);
  orgDao.setLastUpdate(req.session.orgId, function(lastUpdate) {
    if(!req.isImport) {
      req.session.cache.set('user', parseInt(req.id), user, true, function(err){
        if(err) {
          self.onLogicError(6, err.message, req, res, cb);
          return;
        }
        if(cb) {
          cb(req, res);
        } else {
          self.end(res);
        }
      });
    } else {
      if(cb) {
        cb(req, res);
      } else {
        self.end(res);
      }
    }
  });
};