var util = require('util');
var Service = require('Service');
var utils = require('utils');

var SetMute = function () {
  Service.call(this);
};

util.inherits(SetMute, Service);

module.exports = SetMute;

SetMute.prototype.process = function (req, res) {
  if (!(req.isMute || req.isMute === 0)) {
    this.onLogicError(1, '请提供是否免打扰！');
    return;
  }
  if (req.isMute && (!req.muteStartTime || !req.muteEndTime)) {
    this.onLogicError(2, '请提供勿扰开始时间和结束时间！');
    return;
  }
  var self = this;
  req.session.user.isMute = req.isMute;
  if (req.isMute) {
    req.session.user.muteStartTime = req.muteStartTime;
    req.session.user.muteEndTime = req.muteEndTime;
  }

  //TODO通知同一用户的其他在线客户端？
  self.end(res);
};