var util = require('util');
var fs= require('fs');
var http= require('http');
var Service = require('Service');
var AppAttachDao = require('../../dao/app_attach');
var UserDao = require('../../dao/user');
var utils = require('utils');

/**
 * 设置用户头像
 */
var SetHead = function() { 
  Service.call(this);
  this.checkAuthority = false;
  this.attachDao = new AppAttachDao(this);
};

util.inherits(SetHead, Service);

module.exports = SetHead;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
SetHead.prototype.process =  function(req, res) {
  if (server.config.Cache.type && server.config.Cache.type == 'taskmsg') {
    this.pipe(require('../../../system/service/user/setUserHead'), req, res);
    return;
  }
  if(!req.fileCode) {
    this.onLogicError(1, '请提供文件代码！');
    return;
  }

  //创建文件保存路径
  var rootpath = server.attachSavePath;
  var filepath = '/'+req.session.orgCode+'/';
  if(!fs.existsSync(path.join(rootpath,filepath))) fs.mkdirSync(path.join(rootpath,filepath));
  filepath += 'sys.userHead/';
  if(!fs.existsSync(path.join(rootpath,filepath))) fs.mkdirSync(path.join(rootpath,filepath));
  filepath += utils.formatDate(new Date(), 'yyyy_MM')+'/';
  if(!fs.existsSync(path.join(rootpath,filepath))) fs.mkdirSync(path.join(rootpath,filepath));
  filepath += req.fileCode+'.file';

  var self = this;
  fs.rename(path, rootpath+filepath, function() {
    self.attachDao.delete('app_code=\'sys.userHead\' and app_data_Id='
      +req.session.userId+' and org_id='+req.session.orgId, function() {
        self.addAttach(req, res, filepath);
    });
  });
};

SetHead.prototype.addAttach =  function(req, res, filepath) {
  var self = this;
  var attach = {};
  attach.code = req.fileCode;
  attach.name = 'UserHead.png';
  attach.size = req.fileSize;
  attach.type = '.png';
  attach.app_code = 'sys.userHead';
  attach.app_data_id = req.session.userId;
  attach.uploader_id = req.session.userId;
  attach.uploader_name = req.session.userName;
  attach.upload_time = new Date();
  attach.save_path = filepath.replace(/\\/g,'/');
  attach.org_id = req.session.orgId;
  
  this.attachDao.create(attach, function(ret) {
    var userDao = new UserDao(self);
    userDao.update({head_id:ret.insertId},{where:'org_id='+req.session.orgId
      +' and id='+req.session.userId}, function() {
      res.head_id = ret.insertId;
      req.session.cache.set('user', req.session.userId, {head_id:ret.insertId}, true, function(err){
        if(err) {
          self.onLogicError(3, err.message);
          return;
        }
        self.end(res);
      });
    });
  });
};