var Service = require('Service');
var utils = require('utils');
var User = require('../../dao/user');
var util = require('util');

/**
 * 获得用户权限信息
 */
var GetAuth = function () {
  Service.call(this);
};

util.inherits(GetAuth, Service);

module.exports = GetAuth;

/**
 * 处理服务请求
 * @param {Object} req 服务请求对象
 * @param {Object} res 服务响应对象
 */
GetAuth.prototype.process = function (req, res) {
  if (!req.userId) {
    this.onLogicError(1, '请提供用户编号！');
    return;
  }

  var auth = {
    create_group: req.create_group,
    look_all: req.look_all,
    look_self_bureau: req.look_self_bureau,
    look_self_dep: req.look_self_dep,
    look_leader: req.look_leader,
    look_under: req.look_under
  };

  var self = this;
  var dao = new User(this);
  dao.update(auth, {
      where: 'org_id=' + req.session.orgId + ' and id in (' + req.userId + ')'
    },
    function () {
      self.requestIMService('sys/service/cache/setUserAuth', {
        userId: req.userId,
        auth: auth
      }, req, function () {
        self.end(res);
      });
    });
};