var Service = require('Service');
var utils = require('utils');
var User = require('../../dao/vuser');
var util = require('util');

/**
 * 发送注册验证码
 */
var SendVerifyCode = function () {
  Service.call(this);
  this.checkLogin = false;
};

util.inherits(SendVerifyCode, Service);

module.exports = SendVerifyCode;

/**
 * 处理服务请求
 * @param {Object} req 服务请求对象
 * @param {Object} res 服务响应对象
 */
SendVerifyCode.prototype.process = function (req, res) {
  if (!req.mobile) {
    this.onLogicError(1, '请提供手机号码！');
    return;
  }
  if (!req.orgCode) {
    this.onLogicError(2, '请提供组织代码！');
    return;
  }
  var org = app.cache.getOrgByCode(req.orgCode);
  if (!org) {
    this.onLogicError(3, '组织不存在！');
    return;
  }
  if (!utils.isPhone(req.mobile)) {
    this.onLogicError(4, '请提供有效的手机号码！');
    return;
  }

  for (var userId in org.users) {
    var user = org.users[userId];
    if (user.mobile == req.mobile || user.loginname == req.mobile) {
      this.onLogicError(5, '手机号码已存在！');
      return;
    }
  }

  res.verifyCode = utils.createVerifyCode(6, true).toLowerCase();
  if (!app.cache.registVerifyCodes) app.cache.registVerifyCodes = {};
  app.cache.registVerifyCodes[req.mobile] = {
    mobile: req.mobile,
    time: new Date(),
    code: res.verifyCode
  };
  self.end(res);
};